/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service.model;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.milkbowl.vault.chat.Chat;
import net.thenextlvl.service.api.chat.ChatProfile;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WrappedChatProfile
implements ChatProfile {
    private final @Nullable World world;
    private final Chat chat;
    private final OfflinePlayer holder;

    public WrappedChatProfile(@Nullable World world, Chat chat, OfflinePlayer holder) {
        this.world = world;
        this.chat = chat;
        this.holder = holder;
    }

    @Override
    public Optional<String> getDisplayName() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.holder.getName());
    }

    @Override
    public Optional<String> getPrefix(int priority) {
        return Optional.ofNullable(this.chat.getPlayerPrefix(this.world != null ? this.world.getName() : null, this.holder));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getPrefixes() {
        return this.getPrefix().map(prefix -> Map.of(0, prefix)).orElseGet(Map::of);
    }

    @Override
    public Optional<String> getPrimaryGroup() {
        return Optional.ofNullable(this.chat.getPrimaryGroup(this.world != null ? this.world.getName() : null, this.holder));
    }

    @Override
    public Optional<String> getSuffix(int priority) {
        return Optional.ofNullable(this.chat.getPlayerSuffix(this.world != null ? this.world.getName() : null, this.holder));
    }

    @Override
    public @Unmodifiable Map<Integer, String> getSuffixes() {
        return this.getSuffix().map(suffix -> Map.of(0, suffix)).orElseGet(Map::of);
    }

    @Override
    public @Unmodifiable Set<String> getGroups() {
        return Set.of(this.chat.getPlayerGroups(this.world != null ? this.world.getName() : null, this.holder));
    }

    @Override
    public boolean setDisplayName(@Nullable String displayName) {
        return false;
    }

    @Override
    public boolean setPrefix(@Nullable String prefix, int priority) {
        this.chat.setPlayerPrefix(this.world != null ? this.world.getName() : null, this.holder, prefix);
        return true;
    }

    @Override
    public boolean setSuffix(@Nullable String suffix, int priority) {
        this.chat.setPlayerSuffix(this.world != null ? this.world.getName() : null, this.holder, suffix);
        return true;
    }

    @Override
    public <T> Optional<T> getInfoNode(String key, Function<@Nullable String, @Nullable T> mapper) {
        return Optional.ofNullable(this.chat.getPlayerInfoString(this.world != null ? this.world.getName() : null, this.holder, key, null)).map(mapper);
    }

    @Override
    public Optional<Boolean> booleanInfoNode(String key) {
        return Optional.of(this.chat.getPlayerInfoBoolean(this.world != null ? this.world.getName() : null, this.holder, key, false));
    }

    @Override
    public Optional<Double> doubleInfoNode(String key) throws NumberFormatException {
        return Optional.of(this.chat.getPlayerInfoDouble(this.world != null ? this.world.getName() : null, this.holder, key, 0.0));
    }

    @Override
    public Optional<Integer> intInfoNode(String key) throws NumberFormatException {
        return Optional.of(this.chat.getPlayerInfoInteger(this.world != null ? this.world.getName() : null, this.holder, key, 0));
    }

    @Override
    public boolean removeInfoNode(String key) {
        this.chat.setPlayerInfoString(this.world != null ? this.world.getName() : null, this.holder, key, null);
        return true;
    }

    @Override
    public boolean setInfoNode(String key, String value) {
        this.chat.setPlayerInfoString(this.world != null ? this.world.getName() : null, this.holder, key, value);
        return true;
    }
}

