/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import com.example.lightaura.LightManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class DroppedItemLightingHandler {
    private static final int MAX_LIGHT_LEVEL = 15;

    public void handleDroppedItemLighting(Level level, Player player, LightManager lightManager, int scanRadius, int maxTrackedEntities, double droppedItemLightMultiplier) {
        BlockPos playerPos = player.blockPosition();
        List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(playerPos).inflate((double)scanRadius), entity -> entity != null && entity.isAlive());
        if (items.size() > maxTrackedEntities) {
            items = items.subList(0, maxTrackedEntities);
        }
        HashSet<Entity> itemsToRemove = new HashSet<Entity>();
        for (Map.Entry<Entity, BlockPos> entry : lightManager.getEntityLights().entrySet()) {
            Entity entity2 = entry.getKey();
            if (entity2.isAlive() && !lightManager.getPendingPickupEntities().contains(entity2)) continue;
            itemsToRemove.add(entity2);
        }
        for (Entity entity3 : itemsToRemove) {
            lightManager.removeEntityLight(entity3);
        }
        lightManager.clearPendingPickupEntities();
        for (ItemEntity item : items) {
            int light;
            if (lightManager.getEntityLights().containsKey(item) || (light = this.getLightLevel(item.getItem())) <= 0) continue;
            light = this.clampLightLevel((int)Math.max(1.0, (double)light * droppedItemLightMultiplier));
            BlockPos pos = item.blockPosition();
            BlockPos lightPlacementPos = pos.above();
            lightManager.placeLight(level, lightPlacementPos, light, false, (Entity)item, false, false);
            lightManager.putEntityLight((Entity)item, lightPlacementPos);
        }
        HashMap<Entity, BlockPos> entityLightsCopy = new HashMap<Entity, BlockPos>(lightManager.getEntityLights());
        for (Map.Entry entry : entityLightsCopy.entrySet()) {
            ItemEntity itemEntity;
            int light;
            BlockPos newPos;
            BlockPos newLightPlacementPos;
            Entity entity4 = (Entity)entry.getKey();
            BlockPos pos = (BlockPos)entry.getValue();
            if (!entity4.isAlive() || lightManager.getPendingPickupEntities().contains(entity4) || (newLightPlacementPos = (newPos = entity4.blockPosition()).above()).equals((Object)pos)) continue;
            lightManager.removeLight(level, pos, true);
            if (!(entity4 instanceof ItemEntity) || (light = this.getLightLevel((itemEntity = (ItemEntity)entity4).getItem())) <= 0) continue;
            int finalLight = this.clampLightLevel((int)Math.max(1.0, (double)light * droppedItemLightMultiplier));
            lightManager.placeLight(level, newLightPlacementPos, finalLight, false, entity4, false, false);
            lightManager.putEntityLight(entity4, newLightPlacementPos);
        }
    }

    private int getLightLevel(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Map<Item, Integer> lightItems = DynamicLightingConfig.getLightItems();
        int level = lightItems.getOrDefault(stack.getItem(), 0);
        return this.clampLightLevel(level);
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }
}

