/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.LightSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightManager {
    private final Map<BlockPos, LightSource> activeLights = new HashMap<BlockPos, LightSource>();
    private final Map<Entity, BlockPos> entityLights = new HashMap<Entity, BlockPos>();
    private final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
    private final Map<BlockPos, Integer> transitioningLights = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, BlockState> originalBlockStates = new HashMap<BlockPos, BlockState>();
    private final Set<BlockPos> preservedPlantPositions = new HashSet<BlockPos>();
    private final Set<Entity> pendingPickupEntities = new HashSet<Entity>();
    private boolean enableSmoothTransitions = true;
    private static final int MAX_LIGHT_LEVEL = 15;

    public void cleanupAllLights() {
        this.activeLights.clear();
        this.entityLights.clear();
        this.pendingUpdates.clear();
        this.transitioningLights.clear();
        this.originalBlockStates.clear();
        this.preservedPlantPositions.clear();
        this.pendingPickupEntities.clear();
    }

    public void addPendingPickupEntity(Entity entity) {
        this.pendingPickupEntities.add(entity);
    }

    public void removeEntityLight(Entity entity) {
        if (this.entityLights.containsKey(entity)) {
            BlockPos lightPos = this.entityLights.get(entity);
            this.removeLight(entity.level(), lightPos, true);
            this.entityLights.remove(entity);
        }
    }

    public void processTransitioningLights(Level level, boolean enableSmoothTransitions, int transitionLightDuration, boolean isAscending) {
        long now = level.getGameTime();
        Iterator<Map.Entry<BlockPos, Integer>> it = this.transitioningLights.entrySet().iterator();
        while (it.hasNext()) {
            int transitionDuration;
            Map.Entry<BlockPos, Integer> entry = it.next();
            BlockPos pos = entry.getKey();
            int targetLevel = this.clampLightLevel(entry.getValue());
            LightSource source = this.activeLights.get(pos);
            if (source == null) {
                it.remove();
                continue;
            }
            long elapsed = now - source.getLastUpdate();
            int n = transitionDuration = isAscending ? Math.max(1, transitionLightDuration / 2) : transitionLightDuration;
            if (elapsed >= (long)transitionDuration) {
                if (targetLevel > 0) {
                    this.setLightBlock(level, pos, targetLevel);
                } else {
                    this.removeLight(level, pos);
                }
                it.remove();
                continue;
            }
            if (elapsed % 2L != 0L) continue;
            float progress = (float)elapsed / (float)transitionDuration;
            int currentLevel = source.getLightLevel();
            int newLevel = targetLevel > currentLevel ? currentLevel + (int)(progress * (float)(targetLevel - currentLevel)) : currentLevel - (int)(progress * (float)(currentLevel - targetLevel));
            newLevel = this.clampLightLevel(newLevel);
            if (newLevel == currentLevel || newLevel <= 0) continue;
            this.setLightBlock(level, pos, newLevel);
            this.pendingUpdates.add(pos);
        }
    }

    public void setEnableSmoothTransitions(boolean enable) {
        this.enableSmoothTransitions = enable;
    }

    public void cleanupLights(Level level, BlockPos playerPos, boolean forceCleanup, Set<BlockPos> playerLightPositions, Set<BlockPos> offhandLightPositions, Set<BlockPos> mainhandLightPositions, Set<BlockPos> tallGrassLightPositions, int cleanupDelay, int transitionLightDuration, int lightUpdateDistance, boolean optimizeLightUpdates, boolean enableSmoothTransitions) {
        long now = level.getGameTime();
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        HashMap<BlockPos, LightSource> activeLightsCopy = new HashMap<BlockPos, LightSource>(this.activeLights);
        for (Map.Entry entry : activeLightsCopy.entrySet()) {
            boolean shouldRemove;
            boolean stillInUse;
            BlockPos pos = (BlockPos)entry.getKey();
            LightSource src = (LightSource)entry.getValue();
            boolean bl = stillInUse = playerLightPositions.contains(pos) || offhandLightPositions.contains(pos) || mainhandLightPositions.contains(pos) || tallGrassLightPositions.contains(pos);
            if (stillInUse) {
                src.setActive(true);
                continue;
            }
            if (src.getTrackedEntity() != null && src.getTrackedEntity().isAlive() && !this.pendingPickupEntities.contains(src.getTrackedEntity()) || !forceCleanup && this.transitioningLights.containsKey(pos)) continue;
            if (optimizeLightUpdates && playerPos.distSqr((Vec3i)pos) > (double)(lightUpdateDistance * lightUpdateDistance)) {
                toRemove.add(pos);
                continue;
            }
            int effectiveCleanupDelay = src.isPlayerLight() ? Math.max(1, cleanupDelay / 2) : cleanupDelay;
            boolean bl2 = shouldRemove = !src.isActive() || now - src.getLastUpdate() > (long)effectiveCleanupDelay;
            if (forceCleanup && pos.getY() >= playerPos.getY()) {
                shouldRemove = true;
            }
            if (src.getTrackedEntity() != null && this.pendingPickupEntities.contains(src.getTrackedEntity())) {
                shouldRemove = true;
                forceCleanup = true;
            }
            if (src.isPlayerLight() && !stillInUse) {
                shouldRemove = true;
                forceCleanup = true;
            }
            if (!shouldRemove) continue;
            if (enableSmoothTransitions && !forceCleanup && src.getLightLevel() > 0 && !src.isPlayerLight()) {
                this.transitioningLights.put(pos, 0);
                src.setActive(false);
                this.activeLights.put(pos, src);
                continue;
            }
            toRemove.add(pos);
        }
        for (BlockPos pos : toRemove) {
            this.removeLight(level, pos, forceCleanup || this.activeLights.get(pos).isPlayerLight());
        }
    }

    public void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight, boolean isMainhandLight) {
        LightSource existing;
        if ((lightLevel = this.clampLightLevel(lightLevel)) <= 0 || pos == null) {
            return;
        }
        if (entity != null && this.pendingPickupEntities.contains(entity)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        boolean isPlantBlock = this.isPlantBlock(state);
        BlockPos lightPos = pos;
        if (isPlantBlock) {
            lightPos = this.findNearbyAirBlock(level, pos);
            if (lightPos == null && !level.getBlockState(lightPos = pos.above()).isAir() && !level.getBlockState(lightPos).is(Blocks.LIGHT)) {
                return;
            }
        } else {
            boolean canPlaceLight;
            boolean bl = canPlaceLight = state.isAir() || state.is(Blocks.LIGHT);
            if (!canPlaceLight) {
                return;
            }
        }
        if ((existing = this.activeLights.get(lightPos)) != null && existing.isPlayerLight() && (isOffhandLight || isMainhandLight) ? lightLevel <= existing.getLightLevel() : (!(existing == null || !existing.isOffhandLight() && !existing.isMainhandLight() || !isOffhandLight && !isMainhandLight) ? lightLevel <= existing.getLightLevel() : existing != null && lightLevel <= existing.getLightLevel())) {
            return;
        }
        this.setLightBlock(level, lightPos, lightLevel);
        this.activeLights.put(lightPos, new LightSource(lightLevel, level.getGameTime(), isPlayerLight, entity, isOffhandLight, isMainhandLight));
        this.pendingUpdates.add(lightPos);
    }

    private BlockPos findNearbyAirBlock(Level level, BlockPos center) {
        BlockPos[] offsets;
        for (BlockPos testPos : offsets = new BlockPos[]{center.above(), center.north(), center.south(), center.east(), center.west(), center.above().north(), center.above().south(), center.above().east(), center.above().west()}) {
            BlockState testState = level.getBlockState(testPos);
            if (!testState.isAir() && !testState.is(Blocks.LIGHT)) continue;
            return testPos;
        }
        return null;
    }

    public void removeLight(Level level, BlockPos pos) {
        this.removeLight(level, pos, false);
    }

    public void removeLight(Level level, BlockPos pos, boolean forceImmediate) {
        LightSource source = this.activeLights.remove(pos);
        if (source != null) {
            boolean useTransition;
            boolean bl = useTransition = this.enableSmoothTransitions && !forceImmediate && source.getLightLevel() > 0 && !source.isPlayerLight();
            if (useTransition) {
                this.transitioningLights.put(pos, 0);
                source.setActive(false);
                this.activeLights.put(pos, source);
            } else {
                this.transitioningLights.remove(pos);
                BlockState current = level.getBlockState(pos);
                if (current.is(Blocks.LIGHT)) {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
            this.pendingUpdates.add(pos);
        }
    }

    public void setLightBlock(Level level, BlockPos pos, int lightLevel) {
        lightLevel = this.clampLightLevel(lightLevel);
        if (level.isClientSide) {
            BlockState current = level.getBlockState(pos);
            if (lightLevel > 0) {
                if (!(!current.isAir() && !current.is(Blocks.LIGHT) || current.is(Blocks.LIGHT) && (Integer)current.getValue((Property)LightBlock.LEVEL) == lightLevel)) {
                    level.setBlock(pos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(lightLevel)), 3);
                }
            } else if (lightLevel == 0 && current.is(Blocks.LIGHT)) {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
    }

    public void applyLightUpdates(Level level, BlockPos lastPlayerPos, boolean isAscending) {
        if (!this.pendingUpdates.isEmpty() && level.isClientSide) {
            if (isAscending && lastPlayerPos != null) {
                for (BlockPos pos : this.pendingUpdates) {
                    if (pos.getY() < lastPlayerPos.getY()) continue;
                    level.getLightEngine().checkBlock(pos);
                }
                for (BlockPos pos : this.pendingUpdates) {
                    if (pos.getY() >= lastPlayerPos.getY()) continue;
                    level.getLightEngine().checkBlock(pos);
                }
            } else {
                for (BlockPos pos : this.pendingUpdates) {
                    level.getLightEngine().checkBlock(pos);
                }
            }
            this.pendingUpdates.clear();
        }
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }

    private boolean isPlantBlock(BlockState state) {
        return state.is(Blocks.TALL_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.SUGAR_CANE) || state.is(Blocks.WHEAT) || state.is(Blocks.CARROTS) || state.is(Blocks.POTATOES) || state.is(Blocks.BEETROOTS) || state.is(Blocks.PUMPKIN_STEM) || state.is(Blocks.MELON_STEM) || state.is(Blocks.VINE) || state.is(Blocks.LILY_PAD) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS) || state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT) || state.is(Blocks.BAMBOO) || state.is(Blocks.BAMBOO_SAPLING) || state.is(Blocks.CACTUS) || state.is(Blocks.DEAD_BUSH) || state.is(Blocks.DANDELION) || state.is(Blocks.POPPY) || state.is(Blocks.BLUE_ORCHID) || state.is(Blocks.ALLIUM) || state.is(Blocks.AZURE_BLUET) || state.is(Blocks.RED_TULIP) || state.is(Blocks.ORANGE_TULIP) || state.is(Blocks.WHITE_TULIP) || state.is(Blocks.PINK_TULIP) || state.is(Blocks.OXEYE_DAISY) || state.is(Blocks.CORNFLOWER) || state.is(Blocks.LILY_OF_THE_VALLEY) || state.is(Blocks.WITHER_ROSE) || state.is(Blocks.SUNFLOWER) || state.is(Blocks.LILAC) || state.is(Blocks.ROSE_BUSH) || state.is(Blocks.PEONY) || state.is(Blocks.CRIMSON_ROOTS) || state.is(Blocks.WARPED_ROOTS) || state.is(Blocks.NETHER_SPROUTS) || state.is(Blocks.WEEPING_VINES) || state.is(Blocks.TWISTING_VINES) || state.is(Blocks.GLOW_LICHEN);
    }

    public Map<Entity, BlockPos> getEntityLights() {
        return this.entityLights;
    }

    public Set<Entity> getPendingPickupEntities() {
        return this.pendingPickupEntities;
    }

    public void clearPendingPickupEntities() {
        this.pendingPickupEntities.clear();
    }

    public void putEntityLight(Entity entity, BlockPos pos) {
        this.entityLights.put(entity, pos);
    }

    public Map<BlockPos, LightSource> getActiveLights() {
        return this.activeLights;
    }

    public Set<BlockPos> getPreservedPlantPositions() {
        return this.preservedPlantPositions;
    }

    public Map<BlockPos, BlockState> getOriginalBlockStates() {
        return this.originalBlockStates;
    }

    public Map<BlockPos, Integer> getTransitioningLights() {
        return this.transitioningLights;
    }

    public void removeOldLightPositions(Level level, Set<BlockPos> playerLightPositions, Set<BlockPos> playerLightPositions1, boolean isAscending) {
    }
}

