/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import com.example.lightaura.LightManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerLightingHandler {
    private int playerLightLevel = 0;
    private int mainHandLightLevel = 0;
    private int offHandLightLevel = 0;
    private boolean isPlayerDigging = false;
    private long lastDiggingTime = 0L;
    private boolean isAscending = false;
    private long lastVerticalMoveTime = 0L;
    private int verticalMoveCooldown = 0;
    private final Set<BlockPos> playerLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> offhandLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> mainhandLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> tallGrassLightPositions = new HashSet<BlockPos>();
    private static final int MAX_LIGHT_LEVEL = 15;

    public void detectVerticalMovement(Player player, BlockPos currentPos, BlockPos lastPlayerPos) {
        if (lastPlayerPos != null) {
            boolean movingUpward;
            boolean movingVertically = currentPos.getY() != lastPlayerPos.getY();
            boolean bl = movingUpward = currentPos.getY() > lastPlayerPos.getY();
            if (movingVertically) {
                this.lastVerticalMoveTime = player.level().getGameTime();
                if (movingUpward) {
                    this.isAscending = true;
                    this.verticalMoveCooldown = 5;
                }
            } else {
                long timeSinceVerticalMove = player.level().getGameTime() - this.lastVerticalMoveTime;
                if (timeSinceVerticalMove > 3L) {
                    this.isAscending = false;
                }
            }
        }
    }

    public void detectPlayerDigging(Minecraft mc) {
        boolean digging;
        boolean bl = digging = mc.gameMode != null && mc.gameMode.isDestroying();
        if (digging && !this.isPlayerDigging) {
            this.lastDiggingTime = mc.level.getGameTime();
        }
        this.isPlayerDigging = digging;
    }

    public void updatePlayerLightLevels(Player player) {
        this.playerLightLevel = 0;
        this.mainHandLightLevel = 0;
        this.offHandLightLevel = 0;
        this.mainHandLightLevel = this.getLightLevel(player.getMainHandItem());
        this.playerLightLevel = Math.max(this.playerLightLevel, this.mainHandLightLevel);
        this.offHandLightLevel = this.getLightLevel(player.getOffhandItem());
        this.playerLightLevel = Math.max(this.playerLightLevel, this.offHandLightLevel);
        for (ItemStack armor : player.getArmorSlots()) {
            int armorLight = this.getLightLevel(armor);
            this.playerLightLevel = Math.max(this.playerLightLevel, armorLight);
        }
        this.playerLightLevel = this.clampLightLevel(this.playerLightLevel);
        this.mainHandLightLevel = this.clampLightLevel(this.mainHandLightLevel);
        this.offHandLightLevel = this.clampLightLevel(this.offHandLightLevel);
    }

    private int getLightLevel(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        Map<Item, Integer> lightItems = DynamicLightingConfig.getLightItems();
        int level = lightItems.getOrDefault(stack.getItem(), 0);
        return this.clampLightLevel(level);
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }

    public void handlePlayerLighting(Level level, Player player, BlockPos currentPos, LightManager lightManager, boolean enablePlayerLightingOffsets, boolean enhancedMainhandLighting, boolean enhancedOffhandLighting) {
        this.playerLightPositions.clear();
        this.mainhandLightPositions.clear();
        this.offhandLightPositions.clear();
        this.tallGrassLightPositions.clear();
        boolean inTallGrass = this.isPlayerInTallGrass(level, player, currentPos);
        boolean onSpecialBlock = this.isSpecialBlock(level, currentPos);
        if (this.playerLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.playerLightPositions);
            } else {
                this.playerLightPositions.add(currentPos);
                if (enablePlayerLightingOffsets) {
                    BlockPos headPos = BlockPos.containing((Position)player.getEyePosition());
                    this.playerLightPositions.add(headPos);
                    if (this.isAscending) {
                        this.playerLightPositions.add(headPos.above());
                    }
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos offsetPos = currentPos.offset(x, 0, z);
                        if (this.isPlantBlock(level.getBlockState(offsetPos))) continue;
                        this.playerLightPositions.add(offsetPos);
                    }
                }
                if (onSpecialBlock) {
                    this.playerLightPositions.add(currentPos.above());
                }
            }
        }
        if (enhancedMainhandLighting && this.mainHandLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.mainhandLightPositions);
            } else {
                this.mainhandLightPositions.add(currentPos);
                Vec3 lookVec = player.getLookAngle();
                BlockPos frontPos = currentPos.offset((int)Math.round(lookVec.x), (int)Math.round(lookVec.y), (int)Math.round(lookVec.z));
                if (!this.isPlantBlock(level.getBlockState(frontPos))) {
                    this.mainhandLightPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    this.mainhandLightPositions.add(currentPos.above());
                }
            }
        }
        if (enhancedOffhandLighting && this.offHandLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.offhandLightPositions);
            } else {
                this.offhandLightPositions.add(currentPos);
                Vec3 lookVec = player.getLookAngle();
                BlockPos frontPos = currentPos.offset((int)Math.round(lookVec.x), (int)Math.round(lookVec.y), (int)Math.round(lookVec.z));
                if (!this.isPlantBlock(level.getBlockState(frontPos))) {
                    this.offhandLightPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    this.offhandLightPositions.add(currentPos.above());
                }
            }
        }
        for (BlockPos pos : this.playerLightPositions) {
            lightManager.placeLight(level, pos, this.playerLightLevel, true, null, false, false);
        }
        for (BlockPos pos : this.mainhandLightPositions) {
            lightManager.placeLight(level, pos, this.mainHandLightLevel, true, null, false, true);
        }
        for (BlockPos pos : this.offhandLightPositions) {
            lightManager.placeLight(level, pos, this.offHandLightLevel, true, null, true, false);
        }
        for (BlockPos pos : this.tallGrassLightPositions) {
            lightManager.placeLight(level, pos, this.playerLightLevel, true, null, false, false);
        }
        lightManager.removeOldLightPositions(level, this.getPlayerLightPositions(), this.playerLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getMainhandLightPositions(), this.mainhandLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getOffhandLightPositions(), this.offhandLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getTallGrassLightPositions(), this.tallGrassLightPositions, this.isAscending);
    }

    private boolean isPlayerInTallGrass(Level level, Player player, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        BlockState aboveState = level.getBlockState(pos.above());
        BlockState belowState = level.getBlockState(pos.below());
        boolean inPlant = this.isPlantBlock(state) || this.isPlantBlock(aboveState);
        boolean onPlant = this.isPlantBlock(belowState) || belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.DIRT_PATH);
        return inPlant || onPlant;
    }

    private boolean isSpecialBlock(Level level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        return !belowState.isAir() && !belowState.is(Blocks.LIGHT) && (belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.DIRT) || belowState.is(Blocks.PODZOL) || belowState.is(Blocks.MYCELIUM) || belowState.is(Blocks.FARMLAND) || belowState.is(Blocks.DIRT_PATH) || belowState.is(Blocks.RAIL) || belowState.is(Blocks.POWERED_RAIL) || belowState.is(Blocks.DETECTOR_RAIL) || belowState.is(Blocks.ACTIVATOR_RAIL) || belowState.is(Blocks.SNOW) || belowState.is(Blocks.SNOW_BLOCK) || this.isPlantBlock(belowState));
    }

    private void addTallGrassLightPositions(Level level, Player player, BlockPos currentPos, Set<BlockPos> targetSet) {
        targetSet.add(currentPos.above());
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos offsetPos = currentPos.offset(x, 0, z);
                BlockState offsetState = level.getBlockState(offsetPos);
                if (!this.isPlantBlock(offsetState)) {
                    targetSet.add(offsetPos);
                    continue;
                }
                BlockPos aboveOffset = offsetPos.above();
                if (!level.getBlockState(aboveOffset).isAir()) continue;
                targetSet.add(aboveOffset);
            }
        }
        targetSet.add(currentPos.above().north());
        targetSet.add(currentPos.above().south());
        targetSet.add(currentPos.above().east());
        targetSet.add(currentPos.above().west());
    }

    private boolean isPlantBlock(BlockState state) {
        return state.is(Blocks.TALL_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.SUGAR_CANE) || state.is(Blocks.WHEAT) || state.is(Blocks.CARROTS) || state.is(Blocks.POTATOES) || state.is(Blocks.BEETROOTS) || state.is(Blocks.PUMPKIN_STEM) || state.is(Blocks.MELON_STEM) || state.is(Blocks.VINE) || state.is(Blocks.LILY_PAD) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS) || state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT) || state.is(Blocks.BAMBOO) || state.is(Blocks.BAMBOO_SAPLING) || state.is(Blocks.CACTUS) || state.is(Blocks.DEAD_BUSH) || state.is(Blocks.DANDELION) || state.is(Blocks.POPPY) || state.is(Blocks.BLUE_ORCHID) || state.is(Blocks.ALLIUM) || state.is(Blocks.AZURE_BLUET) || state.is(Blocks.RED_TULIP) || state.is(Blocks.ORANGE_TULIP) || state.is(Blocks.WHITE_TULIP) || state.is(Blocks.PINK_TULIP) || state.is(Blocks.OXEYE_DAISY) || state.is(Blocks.CORNFLOWER) || state.is(Blocks.LILY_OF_THE_VALLEY) || state.is(Blocks.WITHER_ROSE) || state.is(Blocks.SUNFLOWER) || state.is(Blocks.LILAC) || state.is(Blocks.ROSE_BUSH) || state.is(Blocks.PEONY) || state.is(Blocks.CRIMSON_ROOTS) || state.is(Blocks.WARPED_ROOTS) || state.is(Blocks.NETHER_SPROUTS) || state.is(Blocks.WEEPING_VINES) || state.is(Blocks.TWISTING_VINES) || state.is(Blocks.GLOW_LICHEN);
    }

    public int getPlayerLightLevel() {
        return this.playerLightLevel;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public int getVerticalMoveCooldown() {
        return this.verticalMoveCooldown;
    }

    public void setVerticalMoveCooldown(int verticalMoveCooldown) {
        this.verticalMoveCooldown = verticalMoveCooldown;
    }

    public Set<BlockPos> getPlayerLightPositions() {
        return this.playerLightPositions;
    }

    public Set<BlockPos> getOffhandLightPositions() {
        return this.offhandLightPositions;
    }

    public Set<BlockPos> getMainhandLightPositions() {
        return this.mainhandLightPositions;
    }

    public Set<BlockPos> getTallGrassLightPositions() {
        return this.tallGrassLightPositions;
    }

    public boolean isPlayerDigging() {
        return this.isPlayerDigging;
    }

    public long getLastDiggingTime() {
        return this.lastDiggingTime;
    }

    public void cleanup() {
        this.playerLightLevel = 0;
        this.mainHandLightLevel = 0;
        this.offHandLightLevel = 0;
        this.isPlayerDigging = false;
        this.lastDiggingTime = 0L;
        this.isAscending = false;
        this.lastVerticalMoveTime = 0L;
        this.verticalMoveCooldown = 0;
        this.playerLightPositions.clear();
        this.offhandLightPositions.clear();
        this.mainhandLightPositions.clear();
        this.tallGrassLightPositions.clear();
    }
}

