/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightaura", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue UPDATE_FREQUENCY;
    public static final ForgeConfigSpec.IntValue CLEANUP_DELAY;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING;
    public static final ForgeConfigSpec.IntValue DROPPED_ITEM_SCAN_RADIUS;
    public static final ForgeConfigSpec.DoubleValue DROPPED_ITEM_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CUSTOM_LIGHT_ITEMS;
    private static final Map<String, Integer> DEFAULT_LIGHT_ITEMS;
    public static final ForgeConfigSpec SPEC;
    private static Map<Item, Integer> lightItemsCache;
    private static long lastConfigLoadTime;

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
    }

    public static Map<Item, Integer> getLightItems() {
        if (lightItemsCache == null || System.currentTimeMillis() - lastConfigLoadTime > 5000L) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
        return lightItemsCache;
    }

    private static void rebuildLightItemsCache() {
        HashMap<Item, Integer> newCache = new HashMap<Item, Integer>();
        for (String entry : (List)CUSTOM_LIGHT_ITEMS.get()) {
            try {
                String[] parts = entry.split("=", 2);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0]));
                if (item == null) continue;
                newCache.put(item, Integer.parseInt(parts[1]));
            }
            catch (Exception exception) {}
        }
        lightItemsCache = Collections.unmodifiableMap(newCache);
        lastConfigLoadTime = System.currentTimeMillis();
    }

    public static int getUpdateFrequency() {
        return (Integer)UPDATE_FREQUENCY.get();
    }

    public static int getCleanupDelay() {
        return (Integer)CLEANUP_DELAY.get();
    }

    public static boolean playerLightingEnabled() {
        return (Boolean)ENABLE_PLAYER_LIGHTING.get();
    }

    public static int getDroppedItemRadius() {
        return (Integer)DROPPED_ITEM_SCAN_RADIUS.get();
    }

    public static double getDroppedItemMultiplier() {
        return (Double)DROPPED_ITEM_MULTIPLIER.get();
    }

    static {
        DEFAULT_LIGHT_ITEMS = Map.ofEntries(Map.entry("minecraft:torch", 14), Map.entry("minecraft:lantern", 15), Map.entry("minecraft:glowstone", 15), Map.entry("minecraft:sea_lantern", 15), Map.entry("minecraft:shroomlight", 15), Map.entry("minecraft:glow_ink_sac", 7), Map.entry("minecraft:campfire", 15), Map.entry("minecraft:soul_campfire", 10), Map.entry("minecraft:soul_lantern", 10), Map.entry("minecraft:redstone_torch", 7), Map.entry("minecraft:jack_o_lantern", 15), Map.entry("minecraft:beacon", 15), Map.entry("minecraft:end_rod", 14));
        BUILDER.comment("General Settings").push("general");
        UPDATE_FREQUENCY = BUILDER.comment(new String[]{"How often lighting updates occur (in ticks)", "Lower values = smoother but more resource intensive"}).defineInRange("updateFrequency", 2, 1, 20);
        CLEANUP_DELAY = BUILDER.comment("How long lights persist after source is gone (in ticks)").defineInRange("cleanupDelay", 5, 1, 100);
        ENABLE_PLAYER_LIGHTING = BUILDER.comment("Enable dynamic lighting for player-held items").define("enablePlayerLighting", true);
        BUILDER.pop().push("items");
        DROPPED_ITEM_SCAN_RADIUS = BUILDER.comment("Radius to scan for dropped light-emitting items (in blocks)").defineInRange("droppedItemRadius", 16, 4, 64);
        DROPPED_ITEM_MULTIPLIER = BUILDER.comment("Brightness multiplier for dropped items (0.1-1.0)").defineInRange("droppedItemMultiplier", 0.7, 0.1, 1.0);
        CUSTOM_LIGHT_ITEMS = BUILDER.comment(new String[]{"Custom light-emitting items (format: modid:item=level)", "Example: minecraft:blaze_rod=10"}).defineList("customLightItems", DEFAULT_LIGHT_ITEMS.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.toList()), entry -> entry instanceof String && ((String)entry).matches(".+=.+"));
        BUILDER.pop();
        SPEC = BUILDER.build();
        lastConfigLoadTime = 0L;
    }
}

