/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightaura")
public class DynamicLightingMod {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_LIGHT_LEVEL = 15;

    public DynamicLightingMod() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        LOGGER.info("Dynamic Lighting (client) initialized for 1.18.2");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientEventHandler {
        private final Map<BlockPos, LightSource> activeLights = new HashMap<BlockPos, LightSource>();
        private final Map<Entity, BlockPos> entityLights = new HashMap<Entity, BlockPos>();
        private final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
        private final Set<BlockPos> playerLightPositions = new HashSet<BlockPos>();
        private final Map<BlockPos, Integer> transitioningLights = new HashMap<BlockPos, Integer>();
        private final Map<BlockPos, BlockState> originalBlockStates = new HashMap<BlockPos, BlockState>();
        private final Set<BlockPos> preservedPlantPositions = new HashSet<BlockPos>();
        private final Set<BlockPos> tallGrassLightPositions = new HashSet<BlockPos>();
        private final Set<Entity> pendingPickupEntities = new HashSet<Entity>();
        private BlockPos lastPlayerPos;
        private BlockPos lastPlayerHeadPos;
        private int playerLightLevel = 0;
        private int mainHandLightLevel = 0;
        private int offHandLightLevel = 0;
        private boolean isPlayerDigging = false;
        private long lastDiggingTime = 0L;
        private final Set<BlockPos> offhandLightPositions = new HashSet<BlockPos>();
        private final Set<BlockPos> mainhandLightPositions = new HashSet<BlockPos>();
        private boolean isAscending = false;
        private long lastVerticalMoveTime = 0L;
        private int verticalMoveCooldown = 0;
        private int updateInterval = 1;
        private int cleanupDelay = 3;
        private int scanRadius = 16;
        private int transitionLightDuration = 5;
        private int maxTrackedEntities = 50;
        private int lightUpdateDistance = 32;
        private boolean enableSmoothTransitions = true;
        private boolean enhancedOffhandLighting = true;
        private boolean enhancedMainhandLighting = true;
        private boolean optimizeLightUpdates = true;
        private boolean enablePlayerLightingOffsets = true;
        private double droppedItemLightMultiplier = 1.0;
        private static Map<Item, Integer> LIGHT_ITEMS = new HashMap<Item, Integer>();

        private ClientEventHandler() {
        }

        @SubscribeEvent
        public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            this.cleanupAllLights();
        }

        @SubscribeEvent
        public void onItemPickup(EntityItemPickupEvent event) {
            if (event.getEntity().f_19853_.f_46443_) {
                ItemEntity itemEntity = event.getItem();
                this.pendingPickupEntities.add((Entity)itemEntity);
                if (this.entityLights.containsKey(itemEntity)) {
                    BlockPos lightPos = this.entityLights.get(itemEntity);
                    this.removeLight(itemEntity.f_19853_, lightPos, true);
                    this.entityLights.remove(itemEntity);
                }
            }
        }

        private void cleanupAllLights() {
            this.activeLights.clear();
            this.entityLights.clear();
            this.pendingUpdates.clear();
            this.playerLightPositions.clear();
            this.offhandLightPositions.clear();
            this.mainhandLightPositions.clear();
            this.transitioningLights.clear();
            this.originalBlockStates.clear();
            this.preservedPlantPositions.clear();
            this.tallGrassLightPositions.clear();
            this.pendingPickupEntities.clear();
            this.lastPlayerPos = null;
            this.lastPlayerHeadPos = null;
            this.isPlayerDigging = false;
            this.lastDiggingTime = 0L;
            this.isAscending = false;
            this.lastVerticalMoveTime = 0L;
            this.verticalMoveCooldown = 0;
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            boolean shouldProcess;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ClientLevel level = mc.f_91073_;
            if (player == null || level == null) {
                return;
            }
            this.loadConfigValues();
            boolean bl = shouldProcess = level.m_46467_() % (long)this.updateInterval == 0L;
            if (this.isAscending || this.verticalMoveCooldown > 0) {
                shouldProcess = true;
                if (this.verticalMoveCooldown > 0) {
                    --this.verticalMoveCooldown;
                }
            }
            if (!shouldProcess) {
                return;
            }
            BlockPos currentPos = player.m_142538_();
            this.detectVerticalMovement((Player)player, currentPos);
            this.detectPlayerDigging(mc, (Player)player);
            this.updatePlayerLightLevels((Player)player);
            this.handlePlayerLighting((Level)level, (Player)player, currentPos);
            if (level.m_46467_() % (long)(this.updateInterval * 2) == 0L) {
                this.handleDroppedItemLighting((Level)level, (Player)player);
            }
            if (this.enableSmoothTransitions) {
                this.processTransitioningLights((Level)level);
            }
            this.cleanupLights((Level)level, currentPos, this.isAscending);
            this.applyLightUpdates((Level)level);
            this.lastPlayerPos = currentPos;
            this.lastPlayerHeadPos = new BlockPos(player.m_146892_());
        }

        private void detectVerticalMovement(Player player, BlockPos currentPos) {
            if (this.lastPlayerPos != null) {
                boolean movingUpward;
                boolean movingVertically = currentPos.m_123342_() != this.lastPlayerPos.m_123342_();
                boolean bl = movingUpward = this.lastPlayerPos != null && currentPos.m_123342_() > this.lastPlayerPos.m_123342_();
                if (movingVertically) {
                    this.lastVerticalMoveTime = player.f_19853_.m_46467_();
                    if (movingUpward) {
                        this.isAscending = true;
                        this.verticalMoveCooldown = 5;
                    }
                } else {
                    long timeSinceVerticalMove = player.f_19853_.m_46467_() - this.lastVerticalMoveTime;
                    if (timeSinceVerticalMove > 3L) {
                        this.isAscending = false;
                    }
                }
            }
        }

        private void loadConfigValues() {
            this.updateInterval = 1;
            this.cleanupDelay = 3;
            this.scanRadius = 16;
            this.enableSmoothTransitions = true;
            this.enhancedOffhandLighting = true;
            this.enhancedMainhandLighting = true;
            this.optimizeLightUpdates = true;
            this.enablePlayerLightingOffsets = true;
            this.maxTrackedEntities = 50;
            this.lightUpdateDistance = 32;
            this.droppedItemLightMultiplier = 1.0;
            this.transitionLightDuration = 5;
        }

        private void detectPlayerDigging(Minecraft mc, Player player) {
            boolean digging;
            boolean bl = digging = mc.f_91072_ != null && mc.f_91072_.m_105296_();
            if (digging && !this.isPlayerDigging) {
                this.lastDiggingTime = mc.f_91073_.m_46467_();
            }
            this.isPlayerDigging = digging;
        }

        private void updatePlayerLightLevels(Player player) {
            this.playerLightLevel = 0;
            this.mainHandLightLevel = 0;
            this.offHandLightLevel = 0;
            this.mainHandLightLevel = this.getLightLevel(player.m_21205_());
            this.playerLightLevel = Math.max(this.playerLightLevel, this.mainHandLightLevel);
            this.offHandLightLevel = this.getLightLevel(player.m_21206_());
            this.playerLightLevel = Math.max(this.playerLightLevel, this.offHandLightLevel);
            for (ItemStack armor : player.m_6168_()) {
                int armorLight = this.getLightLevel(armor);
                this.playerLightLevel = Math.max(this.playerLightLevel, armorLight);
            }
            this.playerLightLevel = this.clampLightLevel(this.playerLightLevel);
            this.mainHandLightLevel = this.clampLightLevel(this.mainHandLightLevel);
            this.offHandLightLevel = this.clampLightLevel(this.offHandLightLevel);
        }

        private int getLightLevel(ItemStack stack) {
            if (stack.m_41619_()) {
                return 0;
            }
            int level = LIGHT_ITEMS.getOrDefault(stack.m_41720_(), 0);
            return this.clampLightLevel(level);
        }

        private int clampLightLevel(int level) {
            return Math.max(0, Math.min(15, level));
        }

        private boolean isPlayerInTallGrass(Level level, Player player, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            BlockState aboveState = level.m_8055_(pos.m_7494_());
            BlockState belowState = level.m_8055_(pos.m_7495_());
            boolean inPlant = this.isPlantBlock(state) || this.isPlantBlock(aboveState);
            boolean onPlant = this.isPlantBlock(belowState) || belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_152481_);
            return inPlant || onPlant;
        }

        private boolean isSpecialBlock(Level level, BlockPos pos) {
            BlockState belowState = level.m_8055_(pos.m_7495_());
            return !belowState.m_60795_() && !belowState.m_60713_(Blocks.f_152480_) && (belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_50195_) || belowState.m_60713_(Blocks.f_50093_) || belowState.m_60713_(Blocks.f_152481_) || belowState.m_60713_(Blocks.f_50156_) || belowState.m_60713_(Blocks.f_50030_) || belowState.m_60713_(Blocks.f_50031_) || belowState.m_60713_(Blocks.f_50285_) || belowState.m_60713_(Blocks.f_50125_) || belowState.m_60713_(Blocks.f_50127_) || this.isPlantBlock(belowState));
        }

        private void addTallGrassLightPositions(Level level, Player player, BlockPos currentPos, Set<BlockPos> targetSet) {
            targetSet.add(currentPos);
            targetSet.add(currentPos.m_7494_());
            targetSet.add(currentPos.m_7495_());
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offsetPos = currentPos.m_142082_(x, 0, z);
                    targetSet.add(offsetPos);
                    if (!this.isPlantBlock(level.m_8055_(offsetPos)) && !this.isPlantBlock(level.m_8055_(offsetPos.m_7494_())) && !this.isPlantBlock(level.m_8055_(offsetPos.m_7495_()))) continue;
                    targetSet.add(offsetPos.m_7494_());
                    targetSet.add(offsetPos.m_7495_());
                }
            }
        }

        private void handlePlayerLighting(Level level, Player player, BlockPos currentPos) {
            BlockPos offsetPos;
            int z;
            BlockPos frontPos;
            HashSet<BlockPos> currentLightPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentMainhandPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentOffhandPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentTallGrassPositions = new HashSet<BlockPos>();
            boolean inTallGrass = this.isPlayerInTallGrass(level, player, currentPos);
            boolean onSpecialBlock = this.isSpecialBlock(level, currentPos);
            if (this.playerLightLevel > 0) {
                currentLightPositions.add(currentPos);
                if (this.enablePlayerLightingOffsets) {
                    BlockPos headPos = new BlockPos(player.m_146892_());
                    currentLightPositions.add(headPos);
                    if (this.isAscending) {
                        currentLightPositions.add(headPos.m_7494_());
                    }
                }
                if (this.lastPlayerPos != null && this.lastPlayerPos.m_123342_() != currentPos.m_123342_()) {
                    currentLightPositions.add(this.lastPlayerPos);
                    if (currentPos.m_123342_() > this.lastPlayerPos.m_123342_()) {
                        currentLightPositions.add(currentPos.m_7494_());
                    }
                    if (currentPos.m_123342_() < this.lastPlayerPos.m_123342_()) {
                        currentLightPositions.add(currentPos.m_7495_());
                    }
                }
                if (onSpecialBlock) {
                    currentLightPositions.add(currentPos.m_7494_());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                }
            }
            if (this.mainHandLightLevel > 0 && this.enhancedMainhandLighting) {
                currentMainhandPositions.add(currentPos);
                if (this.isPlayerDigging || level.m_46467_() - this.lastDiggingTime < (long)(this.cleanupDelay * 3)) {
                    currentMainhandPositions.add(currentPos.m_7495_());
                    Vec3 lookVec = player.m_20154_();
                    frontPos = currentPos.m_142082_((int)Math.round(lookVec.f_82479_), (int)Math.round(lookVec.f_82480_), (int)Math.round(lookVec.f_82481_));
                    currentMainhandPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    currentMainhandPositions.add(currentPos.m_7494_());
                    currentMainhandPositions.add(currentPos.m_7494_().m_7494_());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                    currentMainhandPositions.add(currentPos);
                    currentMainhandPositions.add(currentPos.m_7494_());
                    currentMainhandPositions.add(currentPos.m_7495_());
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (z = -1; z <= 1; ++z) {
                                if (x == 0 && y == 0 && z == 0 || !this.isPlantBlock(level.m_8055_(offsetPos = currentPos.m_142082_(x, y, z)))) continue;
                                currentMainhandPositions.add(offsetPos);
                            }
                        }
                    }
                }
            }
            if (this.offHandLightLevel > 0 && this.enhancedOffhandLighting) {
                currentOffhandPositions.add(currentPos);
                if (this.isPlayerDigging || level.m_46467_() - this.lastDiggingTime < (long)(this.cleanupDelay * 3)) {
                    currentOffhandPositions.add(currentPos.m_7495_());
                    Vec3 lookVec = player.m_20154_();
                    frontPos = currentPos.m_142082_((int)Math.round(lookVec.f_82479_), (int)Math.round(lookVec.f_82480_), (int)Math.round(lookVec.f_82481_));
                    currentOffhandPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    currentOffhandPositions.add(currentPos.m_7494_());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                    currentOffhandPositions.add(currentPos);
                    currentOffhandPositions.add(currentPos.m_7494_());
                    currentOffhandPositions.add(currentPos.m_7495_());
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (z = -1; z <= 1; ++z) {
                                if (x == 0 && y == 0 && z == 0 || !this.isPlantBlock(level.m_8055_(offsetPos = currentPos.m_142082_(x, y, z)))) continue;
                                currentOffhandPositions.add(offsetPos);
                            }
                        }
                    }
                }
            }
            for (BlockPos pos : currentLightPositions) {
                this.placeLight(level, pos, this.playerLightLevel, true);
            }
            for (BlockPos pos : currentMainhandPositions) {
                this.placeLight(level, pos, this.mainHandLightLevel, true, null, false, true);
            }
            for (BlockPos pos : currentOffhandPositions) {
                this.placeLight(level, pos, this.offHandLightLevel, true, null, true, false);
            }
            for (BlockPos pos : currentTallGrassPositions) {
                this.placeLightForTallGrass(level, pos, this.playerLightLevel);
            }
            boolean forceCleanup = this.isAscending;
            this.removeOldLightPositions(level, this.playerLightPositions, currentLightPositions, forceCleanup);
            this.playerLightPositions.clear();
            this.playerLightPositions.addAll(currentLightPositions);
            this.removeOldLightPositions(level, this.mainhandLightPositions, currentMainhandPositions, forceCleanup);
            this.mainhandLightPositions.clear();
            this.mainhandLightPositions.addAll(currentMainhandPositions);
            this.removeOldLightPositions(level, this.offhandLightPositions, currentOffhandPositions, forceCleanup);
            this.offhandLightPositions.clear();
            this.offhandLightPositions.addAll(currentOffhandPositions);
            this.removeOldLightPositions(level, this.tallGrassLightPositions, currentTallGrassPositions, forceCleanup);
            this.tallGrassLightPositions.clear();
            this.tallGrassLightPositions.addAll(currentTallGrassPositions);
        }

        private void removeOldLightPositions(Level level, Set<BlockPos> oldPositions, Set<BlockPos> currentPositions, boolean forceCleanup) {
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos oldPos : oldPositions) {
                if (currentPositions.contains(oldPos)) continue;
                this.removeLight(level, oldPos, forceCleanup);
                toRemove.add(oldPos);
            }
            oldPositions.removeAll(toRemove);
        }

        private void placeLightForTallGrass(Level level, BlockPos pos, int lightLevel) {
            this.placeLight(level, pos, lightLevel, true, null, false, false);
        }

        private void handleDroppedItemLighting(Level level, Player player) {
            BlockPos playerPos = player.m_142538_();
            List items = level.m_6443_(ItemEntity.class, player.m_142469_().m_82400_((double)this.scanRadius), entity -> entity != null && entity.m_6084_());
            if (items.size() > this.maxTrackedEntities) {
                items = items.subList(0, this.maxTrackedEntities);
            }
            HashSet<Entity> itemsToRemove = new HashSet<Entity>();
            for (Entity entity2 : this.entityLights.keySet()) {
                ItemEntity itemEntity;
                double distSq;
                if (!entity2.m_6084_() || this.pendingPickupEntities.contains(entity2)) {
                    BlockPos lightPos = this.entityLights.get(entity2);
                    this.removeLight(level, lightPos, true);
                    itemsToRemove.add(entity2);
                    continue;
                }
                if (!(entity2 instanceof ItemEntity) || !((distSq = entity2.m_20280_((Entity)player)) < 1.0) || (itemEntity = (ItemEntity)entity2).m_32055_().m_41613_() >= itemEntity.m_32055_().m_41741_()) continue;
                BlockPos lightPos = this.entityLights.get(entity2);
                this.removeLight(level, lightPos, true);
                itemsToRemove.add(entity2);
            }
            for (Entity entity2 : itemsToRemove) {
                this.entityLights.remove(entity2);
            }
            this.pendingPickupEntities.clear();
            for (ItemEntity item : items) {
                int light;
                if (this.entityLights.containsKey(item) || (light = this.getLightLevel(item.m_32055_())) <= 0) continue;
                light = this.clampLightLevel((int)Math.max(1.0, (double)light * this.droppedItemLightMultiplier));
                BlockPos pos = item.m_142538_();
                this.placeLight(level, pos, light, false, (Entity)item);
                this.entityLights.put((Entity)item, pos);
            }
            HashMap<Entity, BlockPos> entityLightsCopy = new HashMap<Entity, BlockPos>(this.entityLights);
            for (Map.Entry entry : entityLightsCopy.entrySet()) {
                ItemEntity itemEntity;
                int light;
                BlockPos newPos;
                Entity entity3 = (Entity)entry.getKey();
                BlockPos pos = (BlockPos)entry.getValue();
                if (!entity3.m_6084_() || this.pendingPickupEntities.contains(entity3) || (newPos = entity3.m_142538_()).equals((Object)pos)) continue;
                this.removeLight(level, pos, true);
                if (!(entity3 instanceof ItemEntity) || (light = this.getLightLevel((itemEntity = (ItemEntity)entity3).m_32055_())) <= 0) continue;
                int finalLight = this.clampLightLevel((int)Math.max(1.0, (double)light * this.droppedItemLightMultiplier));
                this.placeLight(level, newPos, finalLight, false, entity3);
                this.entityLights.put(entity3, newPos);
            }
        }

        private void processTransitioningLights(Level level) {
            long now = level.m_46467_();
            Iterator<Map.Entry<BlockPos, Integer>> it = this.transitioningLights.entrySet().iterator();
            while (it.hasNext()) {
                int transitionDuration;
                Map.Entry<BlockPos, Integer> entry = it.next();
                BlockPos pos = entry.getKey();
                int targetLevel = this.clampLightLevel(entry.getValue());
                LightSource source = this.activeLights.get(pos);
                if (source == null) {
                    it.remove();
                    continue;
                }
                long elapsed = now - source.lastUpdate;
                int n = transitionDuration = this.isAscending ? Math.max(1, this.transitionLightDuration / 2) : this.transitionLightDuration;
                if (elapsed >= (long)transitionDuration) {
                    if (targetLevel > 0) {
                        this.setLightBlock(level, pos, targetLevel);
                    } else {
                        this.removeLight(level, pos);
                    }
                    it.remove();
                    continue;
                }
                if (elapsed % 2L != 0L) continue;
                float progress = (float)elapsed / (float)transitionDuration;
                int currentLevel = source.lightLevel;
                int newLevel = targetLevel > currentLevel ? currentLevel + (int)(progress * (float)(targetLevel - currentLevel)) : currentLevel - (int)(progress * (float)(currentLevel - targetLevel));
                newLevel = this.clampLightLevel(newLevel);
                if (newLevel == currentLevel || newLevel <= 0) continue;
                this.setLightBlock(level, pos, newLevel);
                this.pendingUpdates.add(pos);
            }
        }

        private void cleanupLights(Level level, BlockPos playerPos, boolean forceCleanup) {
            long now = level.m_46467_();
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            HashMap<BlockPos, LightSource> activeLightsCopy = new HashMap<BlockPos, LightSource>(this.activeLights);
            for (Map.Entry entry : activeLightsCopy.entrySet()) {
                boolean shouldRemove;
                BlockPos pos = (BlockPos)entry.getKey();
                LightSource src = (LightSource)entry.getValue();
                if (this.playerLightPositions.contains(pos) || this.offhandLightPositions.contains(pos) || this.mainhandLightPositions.contains(pos) || this.tallGrassLightPositions.contains(pos) || src.trackedEntity != null && src.trackedEntity.m_6084_() && !this.pendingPickupEntities.contains(src.trackedEntity) || !forceCleanup && this.transitioningLights.containsKey(pos)) continue;
                if (this.optimizeLightUpdates && playerPos.m_123331_((Vec3i)pos) > (double)(this.lightUpdateDistance * this.lightUpdateDistance)) {
                    toRemove.add(pos);
                    continue;
                }
                boolean bl = !src.isActive || now - src.lastUpdate > (long)(src.isPlayerLight ? this.cleanupDelay : this.transitionLightDuration) ? true : (shouldRemove = false);
                if (forceCleanup && pos.m_123342_() >= playerPos.m_123342_()) {
                    shouldRemove = true;
                }
                if (src.trackedEntity != null && this.pendingPickupEntities.contains(src.trackedEntity)) {
                    shouldRemove = true;
                    forceCleanup = true;
                }
                if (!shouldRemove) continue;
                if (this.enableSmoothTransitions && !forceCleanup && src.lightLevel > 0) {
                    this.transitioningLights.put(pos, 0);
                    src.isActive = false;
                    this.activeLights.put(pos, src);
                    continue;
                }
                toRemove.add(pos);
            }
            for (BlockPos pos : toRemove) {
                this.removeLight(level, pos, forceCleanup);
            }
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, null);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, entity, false, false);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, entity, isOffhandLight, false);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight, boolean isMainhandLight) {
            boolean canPlaceLight;
            if ((lightLevel = this.clampLightLevel(lightLevel)) <= 0 || pos == null) {
                return;
            }
            if (entity != null && this.pendingPickupEntities.contains(entity)) {
                return;
            }
            BlockState state = level.m_8055_(pos);
            boolean isPlantBlock = this.isPlantBlock(state);
            boolean bl = canPlaceLight = state.m_60795_() || state.m_60713_(Blocks.f_152480_);
            if (isPlantBlock) {
                this.preservedPlantPositions.add(pos);
                canPlaceLight = true;
            }
            if (!canPlaceLight) {
                return;
            }
            LightSource existing = this.activeLights.get(pos);
            if ((isOffhandLight || isMainhandLight) && existing != null && !existing.isOffhandLight && !existing.isMainhandLight) {
                existing = null;
            }
            if (existing == null || existing.lightLevel <= lightLevel) {
                boolean shouldUpdateBlock = existing == null || existing.lightLevel < lightLevel;
                this.activeLights.put(pos, new LightSource(lightLevel, level.m_46467_(), isPlayerLight, entity, isOffhandLight, isMainhandLight));
                if (shouldUpdateBlock) {
                    if (this.enableSmoothTransitions && existing != null && !this.isAscending) {
                        this.transitioningLights.put(pos, lightLevel);
                    } else {
                        if (!this.originalBlockStates.containsKey(pos)) {
                            this.originalBlockStates.put(pos, state);
                        }
                        if (!this.preservedPlantPositions.contains(pos)) {
                            this.setLightBlock(level, pos, lightLevel);
                        } else {
                            this.updateLightLevelWithoutReplacing(level, pos, lightLevel);
                        }
                    }
                }
                this.pendingUpdates.add(pos);
            }
        }

        private boolean isPlantBlock(BlockState state) {
            return state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_) || state.m_60713_(Blocks.f_50111_) || state.m_60713_(Blocks.f_50112_) || state.m_60713_(Blocks.f_50113_) || state.m_60713_(Blocks.f_50114_) || state.m_60713_(Blocks.f_50115_) || state.m_60713_(Blocks.f_50116_) || state.m_60713_(Blocks.f_50117_) || state.m_60713_(Blocks.f_50118_) || state.m_60713_(Blocks.f_50119_) || state.m_60713_(Blocks.f_50120_) || state.m_60713_(Blocks.f_50121_) || state.m_60713_(Blocks.f_50071_) || state.m_60713_(Blocks.f_50092_) || state.m_60713_(Blocks.f_50249_) || state.m_60713_(Blocks.f_50250_) || state.m_60713_(Blocks.f_50444_) || state.m_60713_(Blocks.f_50130_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50571_) || state.m_60713_(Blocks.f_50570_) || state.m_60713_(Blocks.f_50685_) || state.m_60713_(Blocks.f_152538_) || state.m_60713_(Blocks.f_152539_) || state.m_60713_(Blocks.f_152475_) || state.m_60713_(Blocks.f_152543_) || state.m_60713_(Blocks.f_50156_) || state.m_60713_(Blocks.f_50030_) || state.m_60713_(Blocks.f_50031_) || state.m_60713_(Blocks.f_50285_) || state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_);
        }

        private void updateLightLevelWithoutReplacing(Level level, BlockPos pos, int lightLevel) {
            lightLevel = this.clampLightLevel(lightLevel);
            if (level.f_46443_) {
                level.m_5518_().m_142202_(pos);
                this.pendingUpdates.add(pos);
            }
        }

        private void removeLight(Level level, BlockPos pos) {
            this.removeLight(level, pos, false);
        }

        private void removeLight(Level level, BlockPos pos, boolean forceImmediate) {
            LightSource source = this.activeLights.remove(pos);
            if (source != null) {
                if (this.enableSmoothTransitions && !forceImmediate && source.lightLevel > 0) {
                    this.transitioningLights.put(pos, 0);
                    source.isActive = false;
                    this.activeLights.put(pos, source);
                } else if (!this.preservedPlantPositions.contains(pos)) {
                    this.setLightBlock(level, pos, 0);
                } else {
                    this.preservedPlantPositions.remove(pos);
                    if (this.originalBlockStates.containsKey(pos)) {
                        level.m_7731_(pos, this.originalBlockStates.get(pos), 3);
                        this.originalBlockStates.remove(pos);
                    }
                }
                this.pendingUpdates.add(pos);
            }
        }

        private void setLightBlock(Level level, BlockPos pos, int lightLevel) {
            lightLevel = this.clampLightLevel(lightLevel);
            if (level.f_46443_) {
                if (this.preservedPlantPositions.contains(pos)) {
                    return;
                }
                BlockState current = level.m_8055_(pos);
                if (lightLevel > 0) {
                    if (!this.originalBlockStates.containsKey(pos)) {
                        this.originalBlockStates.put(pos, current);
                    }
                    level.m_7731_(pos, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(lightLevel)), 3);
                } else if (lightLevel == 0 && current.m_60713_(Blocks.f_152480_)) {
                    if (this.originalBlockStates.containsKey(pos)) {
                        level.m_7731_(pos, this.originalBlockStates.get(pos), 3);
                        this.originalBlockStates.remove(pos);
                    } else {
                        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }

        private void applyLightUpdates(Level level) {
            if (!this.pendingUpdates.isEmpty() && level.f_46443_) {
                if (this.isAscending && this.lastPlayerPos != null) {
                    for (BlockPos pos : this.pendingUpdates) {
                        if (pos.m_123342_() < this.lastPlayerPos.m_123342_()) continue;
                        level.m_5518_().m_142202_(pos);
                    }
                    for (BlockPos pos : this.pendingUpdates) {
                        if (pos.m_123342_() >= this.lastPlayerPos.m_123342_()) continue;
                        level.m_5518_().m_142202_(pos);
                    }
                } else {
                    for (BlockPos pos : this.pendingUpdates) {
                        level.m_5518_().m_142202_(pos);
                    }
                }
                this.pendingUpdates.clear();
            }
        }

        static {
            LIGHT_ITEMS.put(Items.f_42000_, 14);
            LIGHT_ITEMS.put(Items.f_42053_, 10);
            LIGHT_ITEMS.put(Items.f_42778_, 15);
            LIGHT_ITEMS.put(Items.f_42779_, 10);
            LIGHT_ITEMS.put(Items.f_42054_, 15);
            LIGHT_ITEMS.put(Items.f_42251_, 15);
            LIGHT_ITEMS.put(Items.f_42055_, 15);
            LIGHT_ITEMS.put(Items.f_42448_, 15);
            LIGHT_ITEMS.put(Items.f_151079_, 8);
            LIGHT_ITEMS.put(Items.f_151056_, 10);
            LIGHT_ITEMS.put(Items.f_42585_, 10);
            LIGHT_ITEMS.put(Items.f_42258_, 13);
            LIGHT_ITEMS.put(Items.f_42783_, 15);
            LIGHT_ITEMS.put(Items.f_42001_, 14);
            LIGHT_ITEMS.put(Items.f_41978_, 7);
        }

        private static class LightSource {
            final int lightLevel;
            final long lastUpdate;
            final boolean isPlayerLight;
            final Entity trackedEntity;
            final boolean isOffhandLight;
            final boolean isMainhandLight;
            boolean isActive = true;

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity) {
                this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, false, false);
            }

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight) {
                this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, isOffhandLight, false);
            }

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight, boolean isMainhandLight) {
                this.lightLevel = Math.max(0, Math.min(15, lightLevel));
                this.lastUpdate = lastUpdate;
                this.isPlayerLight = isPlayerLight;
                this.trackedEntity = trackedEntity;
                this.isOffhandLight = isOffhandLight;
                this.isMainhandLight = isMainhandLight;
            }
        }
    }
}

