/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private final Screen parentScreen;
    private int updateFrequency;
    private int cleanupDelay;
    private boolean enablePlayerLighting;
    private boolean enableSmoothTransitions;
    private boolean enhancedMainhandLighting;
    private boolean enhancedOffhandLighting;
    private int droppedItemRadius;
    private double droppedItemMultiplier;
    private int maxTrackedEntities;
    private int lightUpdateDistance;
    private boolean optimizeLightUpdates;
    private int transitionLightDuration;

    public ConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"LightAura Configuration"));
        this.parentScreen = parentScreen;
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        this.updateFrequency = DynamicLightingConfig.getUpdateFrequency();
        this.cleanupDelay = DynamicLightingConfig.getCleanupDelay();
        this.enablePlayerLighting = DynamicLightingConfig.playerLightingEnabled();
        this.enableSmoothTransitions = DynamicLightingConfig.smoothTransitionsEnabled();
        this.enhancedMainhandLighting = DynamicLightingConfig.enhancedMainhandLightingEnabled();
        this.enhancedOffhandLighting = DynamicLightingConfig.enhancedOffhandLightingEnabled();
        this.droppedItemRadius = DynamicLightingConfig.getDroppedItemRadius();
        this.droppedItemMultiplier = DynamicLightingConfig.getDroppedItemMultiplier();
        this.maxTrackedEntities = DynamicLightingConfig.getMaxTrackedEntities();
        this.lightUpdateDistance = DynamicLightingConfig.getLightUpdateDistance();
        this.optimizeLightUpdates = DynamicLightingConfig.optimizeLightUpdatesEnabled();
        this.transitionLightDuration = DynamicLightingConfig.getTransitionLightDuration();
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int leftColumn = 30;
        int rightColumn = centerX + 10;
        int buttonWidth = 160;
        int buttonHeight = 18;
        int spacing = 22;
        int currentY = 50;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Update Freq: " + this.updateFrequency + " ticks")), button -> {
            this.updateFrequency = this.updateFrequency >= 20 ? 1 : this.updateFrequency + 1;
            button.m_93666_((Component)Component.m_237113_((String)("Update Freq: " + this.updateFrequency + " ticks")));
        }).m_252987_(leftColumn, currentY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Cleanup: " + this.cleanupDelay + " ticks")), button -> {
            this.cleanupDelay = this.cleanupDelay >= 100 ? 1 : this.cleanupDelay + 1;
            button.m_93666_((Component)Component.m_237113_((String)("Cleanup: " + this.cleanupDelay + " ticks")));
        }).m_252987_(leftColumn, currentY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.enablePlayerLighting).m_168936_(leftColumn, currentY + spacing * 2, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Player Lighting"), (button, value) -> {
            this.enablePlayerLighting = value;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.enableSmoothTransitions).m_168936_(leftColumn, currentY + spacing * 3, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Smooth Transitions"), (button, value) -> {
            this.enableSmoothTransitions = value;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.enhancedMainhandLighting).m_168936_(leftColumn, currentY + spacing * 4, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Enhanced Mainhand"), (button, value) -> {
            this.enhancedMainhandLighting = value;
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.enhancedOffhandLighting).m_168936_(leftColumn, currentY + spacing * 5, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Enhanced Offhand"), (button, value) -> {
            this.enhancedOffhandLighting = value;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Item Radius: " + this.droppedItemRadius + " blocks")), button -> {
            this.droppedItemRadius = this.droppedItemRadius >= 64 ? 4 : this.droppedItemRadius + 2;
            button.m_93666_((Component)Component.m_237113_((String)("Item Radius: " + this.droppedItemRadius + " blocks")));
        }).m_252987_(rightColumn, currentY, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Item Brightness: " + String.format("%.1f", this.droppedItemMultiplier))), button -> {
            this.droppedItemMultiplier = this.droppedItemMultiplier >= 1.0 ? 0.1 : (double)Math.round((this.droppedItemMultiplier + 0.1) * 10.0) / 10.0;
            button.m_93666_((Component)Component.m_237113_((String)("Item Brightness: " + String.format("%.1f", this.droppedItemMultiplier))));
        }).m_252987_(rightColumn, currentY + spacing, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Max Entities: " + this.maxTrackedEntities)), button -> {
            this.maxTrackedEntities = this.maxTrackedEntities >= 200 ? 10 : this.maxTrackedEntities + 10;
            button.m_93666_((Component)Component.m_237113_((String)("Max Entities: " + this.maxTrackedEntities)));
        }).m_252987_(rightColumn, currentY + spacing * 2, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Update Distance: " + this.lightUpdateDistance)), button -> {
            this.lightUpdateDistance = this.lightUpdateDistance >= 128 ? 16 : this.lightUpdateDistance + 8;
            button.m_93666_((Component)Component.m_237113_((String)("Update Distance: " + this.lightUpdateDistance)));
        }).m_252987_(rightColumn, currentY + spacing * 3, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.optimizeLightUpdates).m_168936_(rightColumn, currentY + spacing * 4, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)"Optimize Updates"), (button, value) -> {
            this.optimizeLightUpdates = value;
        }));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)("Transition: " + this.transitionLightDuration + " ticks")), button -> {
            this.transitionLightDuration = this.transitionLightDuration >= 20 ? 1 : this.transitionLightDuration + 1;
            button.m_93666_((Component)Component.m_237113_((String)("Transition: " + this.transitionLightDuration + " ticks")));
        }).m_252987_(rightColumn, currentY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        int bottomY = this.f_96544_ - 35;
        int bottomButtonWidth = 85;
        int totalWidth = bottomButtonWidth * 3 + 40;
        int startX = (this.f_96543_ - totalWidth) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save & Close"), button -> {
            this.saveConfigValues();
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252987_(startX, bottomY, bottomButtonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(startX + bottomButtonWidth + 20, bottomY, bottomButtonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset to Default"), button -> {
            this.resetToDefaults();
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }).m_252987_(startX + bottomButtonWidth * 2 + 40, bottomY, bottomButtonWidth + 10, 20).m_253136_());
    }

    private void saveConfigValues() {
        block3: {
            try {
                DynamicLightingConfig.UPDATE_FREQUENCY.set((Object)this.updateFrequency);
                DynamicLightingConfig.CLEANUP_DELAY.set((Object)this.cleanupDelay);
                DynamicLightingConfig.ENABLE_PLAYER_LIGHTING.set((Object)this.enablePlayerLighting);
                DynamicLightingConfig.ENABLE_SMOOTH_TRANSITIONS.set((Object)this.enableSmoothTransitions);
                DynamicLightingConfig.ENHANCED_MAINHAND_LIGHTING.set((Object)this.enhancedMainhandLighting);
                DynamicLightingConfig.ENHANCED_OFFHAND_LIGHTING.set((Object)this.enhancedOffhandLighting);
                DynamicLightingConfig.DROPPED_ITEM_SCAN_RADIUS.set((Object)this.droppedItemRadius);
                DynamicLightingConfig.DROPPED_ITEM_MULTIPLIER.set((Object)this.droppedItemMultiplier);
                DynamicLightingConfig.MAX_TRACKED_ENTITIES.set((Object)this.maxTrackedEntities);
                DynamicLightingConfig.LIGHT_UPDATE_DISTANCE.set((Object)this.lightUpdateDistance);
                DynamicLightingConfig.OPTIMIZE_LIGHT_UPDATES.set((Object)this.optimizeLightUpdates);
                DynamicLightingConfig.TRANSITION_LIGHT_DURATION.set((Object)this.transitionLightDuration);
                DynamicLightingConfig.SPEC.save();
                DynamicLightingConfig.rebuildLightItemsCache();
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7aLightAura settings saved successfully!"), true);
                }
            }
            catch (Exception e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block3;
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a7cError saving LightAura settings: " + e.getMessage())), true);
            }
        }
    }

    private void resetToDefaults() {
        this.updateFrequency = 1;
        this.cleanupDelay = 3;
        this.enablePlayerLighting = true;
        this.enableSmoothTransitions = false;
        this.enhancedMainhandLighting = true;
        this.enhancedOffhandLighting = true;
        this.droppedItemRadius = 16;
        this.droppedItemMultiplier = 0.7;
        this.maxTrackedEntities = 50;
        this.lightUpdateDistance = 32;
        this.optimizeLightUpdates = true;
        this.transitionLightDuration = 5;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        int leftColumn = 30;
        int rightColumn = this.f_96543_ / 2 + 10;
        guiGraphics.m_280488_(this.f_96547_, "\u00a76General Settings", leftColumn, 35, 16766720);
        guiGraphics.m_280488_(this.f_96547_, "\u00a76Item & Performance", rightColumn, 35, 16766720);
        guiGraphics.m_280137_(this.f_96547_, "\u00a77Press 'P' to open this menu \u2022 Changes take effect immediately", this.f_96543_ / 2, this.f_96544_ - 15, 0x808080);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }
}

