/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import com.example.lightaura.LightManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DroppedItemLightingHandler {
    private static final int MAX_LIGHT_LEVEL = 15;
    private final Map<Entity, Vec3> lastEntityPositions = new HashMap<Entity, Vec3>();
    private final Map<Entity, Integer> entityMotionLightCounter = new HashMap<Entity, Integer>();

    public void handleDroppedItemLighting(Level level, Player player, LightManager lightManager, int scanRadius, int maxTrackedEntities, double droppedItemLightMultiplier) {
        BlockPos playerPos = player.m_20183_();
        List items = level.m_6443_(ItemEntity.class, new AABB(playerPos).m_82400_((double)scanRadius), entity -> entity != null && entity.m_6084_());
        if (items.size() > maxTrackedEntities) {
            items = items.subList(0, maxTrackedEntities);
        }
        HashSet<Entity> itemsToRemove = new HashSet<Entity>();
        for (Map.Entry<Entity, BlockPos> entry : lightManager.getEntityLights().entrySet()) {
            Entity entity2 = entry.getKey();
            if (entity2.m_6084_() && !lightManager.getPendingPickupEntities().contains(entity2)) continue;
            itemsToRemove.add(entity2);
        }
        for (Entity entity3 : itemsToRemove) {
            lightManager.removeEntityLight(entity3);
        }
        lightManager.clearPendingPickupEntities();
        for (ItemEntity item : items) {
            int light;
            if (lightManager.getEntityLights().containsKey(item) || (light = this.getLightLevel(item.m_32055_())) <= 0) continue;
            light = this.clampLightLevel((int)Math.max(1.0, (double)light * droppedItemLightMultiplier));
            BlockPos pos = item.m_20183_();
            this.placeDroppedItemLights(level, lightManager, item, pos, light);
            this.lastEntityPositions.put((Entity)item, item.m_20182_());
        }
        HashMap<Entity, BlockPos> entityLightsCopy = new HashMap<Entity, BlockPos>(lightManager.getEntityLights());
        for (Map.Entry entry : entityLightsCopy.entrySet()) {
            Entity entity4 = (Entity)entry.getKey();
            BlockPos pos = (BlockPos)entry.getValue();
            if (entity4.m_6084_() && !lightManager.getPendingPickupEntities().contains(entity4)) {
                ItemEntity itemEntity;
                int light;
                BlockPos newPos = entity4.m_20183_();
                Vec3 currentPosition = entity4.m_20182_();
                Vec3 lastPosition = this.lastEntityPositions.get(entity4);
                boolean isMoving = false;
                if (lastPosition != null) {
                    ItemEntity itemEntity2;
                    int light2;
                    double motionMagnitude = currentPosition.m_82554_(lastPosition);
                    boolean bl = isMoving = motionMagnitude > 0.1;
                    if (isMoving && entity4 instanceof ItemEntity && (light2 = this.getLightLevel((itemEntity2 = (ItemEntity)entity4).m_32055_())) > 0) {
                        this.createMotionTrail(level, lightManager, itemEntity2, lastPosition, currentPosition, light2, droppedItemLightMultiplier);
                    }
                }
                this.lastEntityPositions.put(entity4, currentPosition);
                if (newPos.equals((Object)pos.m_7495_())) continue;
                lightManager.removeLight(level, pos, true);
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        lightManager.removeLight(level, pos.m_7918_(x, 0, z), true);
                    }
                }
                if (!(entity4 instanceof ItemEntity) || (light = this.getLightLevel((itemEntity = (ItemEntity)entity4).m_32055_())) <= 0) continue;
                int finalLight = this.clampLightLevel((int)Math.max(1.0, (double)light * droppedItemLightMultiplier));
                this.placeDroppedItemLights(level, lightManager, itemEntity, newPos, finalLight);
                continue;
            }
            this.lastEntityPositions.remove(entity4);
            this.entityMotionLightCounter.remove(entity4);
        }
    }

    private int getLightLevel(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Map<Item, Integer> lightItems = DynamicLightingConfig.getLightItems();
        int level = lightItems.getOrDefault(stack.m_41720_(), 0);
        return this.clampLightLevel(level);
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }

    private void placeDroppedItemLights(Level level, LightManager lightManager, ItemEntity item, BlockPos pos, int lightLevel) {
        BlockPos abovePos;
        BlockPos mainLightPos = pos.m_7494_();
        lightManager.placeLight(level, mainLightPos, lightLevel, false, (Entity)item, false, false);
        lightManager.putEntityLight((Entity)item, mainLightPos);
        if (lightLevel >= 10) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos surroundPos;
                    if (x == 0 && z == 0 || !level.m_8055_(surroundPos = pos.m_7918_(x, 0, z)).m_60795_()) continue;
                    int surroundLight = Math.max(1, lightLevel - 2);
                    lightManager.placeLight(level, surroundPos, surroundLight, false, (Entity)item, false, false);
                }
            }
            if (level.m_8055_(pos).m_60795_()) {
                lightManager.placeLight(level, pos, lightLevel, false, (Entity)item, false, false);
            }
        }
        if (lightLevel >= 14 && level.m_8055_(abovePos = pos.m_6630_(2)).m_60795_()) {
            lightManager.placeLight(level, abovePos, Math.max(1, lightLevel - 3), false, (Entity)item, false, false);
        }
    }

    private void createMotionTrail(Level level, LightManager lightManager, ItemEntity item, Vec3 lastPos, Vec3 currentPos, int lightLevel, double multiplier) {
        Vec3 motion = currentPos.m_82546_(lastPos);
        double speed = motion.m_82553_();
        if (speed > 0.3) {
            int motionCounter = this.entityMotionLightCounter.getOrDefault(item, 0);
            if (motionCounter % 2 == 0) {
                int trailPoints = Math.min(3, (int)(speed * 3.0));
                for (int i = 1; i <= trailPoints; ++i) {
                    double ratio = (double)i / (double)(trailPoints + 1);
                    Vec3 trailPos = lastPos.m_82549_(motion.m_82490_(ratio));
                    BlockPos trailBlockPos = BlockPos.m_274446_((Position)trailPos);
                    int trailLight = this.clampLightLevel((int)((double)lightLevel * multiplier * 0.6));
                    if (trailLight <= 0 || !level.m_8055_(trailBlockPos).m_60795_()) continue;
                    lightManager.placeLight(level, trailBlockPos, trailLight, false, (Entity)item, false, false);
                    BlockPos aboveTrail = trailBlockPos.m_7494_();
                    if (!level.m_8055_(aboveTrail).m_60795_()) continue;
                    lightManager.placeLight(level, aboveTrail, trailLight, false, (Entity)item, false, false);
                }
            }
            this.entityMotionLightCounter.put((Entity)item, motionCounter + 1);
        } else {
            this.entityMotionLightCounter.put((Entity)item, 0);
        }
    }
}

