/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightaura", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue UPDATE_FREQUENCY;
    public static final ForgeConfigSpec.IntValue CLEANUP_DELAY;
    public static final ForgeConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SMOOTH_TRANSITIONS;
    public static final ForgeConfigSpec.BooleanValue ENHANCED_MAINHAND_LIGHTING;
    public static final ForgeConfigSpec.BooleanValue ENHANCED_OFFHAND_LIGHTING;
    public static final ForgeConfigSpec.IntValue DROPPED_ITEM_SCAN_RADIUS;
    public static final ForgeConfigSpec.DoubleValue DROPPED_ITEM_MULTIPLIER;
    public static final ForgeConfigSpec.IntValue MAX_TRACKED_ENTITIES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CUSTOM_LIGHT_ITEMS;
    public static final ForgeConfigSpec.IntValue LIGHT_UPDATE_DISTANCE;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_LIGHT_UPDATES;
    public static final ForgeConfigSpec.IntValue TRANSITION_LIGHT_DURATION;
    private static final Map<String, Integer> DEFAULT_LIGHT_ITEMS;
    public static final ForgeConfigSpec SPEC;
    private static Map<Item, Integer> lightItemsCache;
    private static long lastConfigLoadTime;

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
    }

    public static Map<Item, Integer> getLightItems() {
        if (lightItemsCache == null || System.currentTimeMillis() - lastConfigLoadTime > 5000L) {
            DynamicLightingConfig.rebuildLightItemsCache();
        }
        return lightItemsCache;
    }

    public static void rebuildLightItemsCache() {
        HashMap<Item, Integer> newCache = new HashMap<Item, Integer>();
        try {
            for (String entry : (List)CUSTOM_LIGHT_ITEMS.get()) {
                try {
                    String[] parts = entry.split("=", 2);
                    if (parts.length != 2) continue;
                    ResourceLocation itemId = new ResourceLocation(parts[0]);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                    int lightLevel = Integer.parseInt(parts[1]);
                    if (item == null || lightLevel < 1 || lightLevel > 15) continue;
                    newCache.put(item, lightLevel);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lightItemsCache = Collections.unmodifiableMap(newCache);
        lastConfigLoadTime = System.currentTimeMillis();
    }

    public static int getUpdateFrequency() {
        return (Integer)UPDATE_FREQUENCY.get();
    }

    public static int getCleanupDelay() {
        return (Integer)CLEANUP_DELAY.get();
    }

    public static boolean playerLightingEnabled() {
        return (Boolean)ENABLE_PLAYER_LIGHTING.get();
    }

    public static boolean smoothTransitionsEnabled() {
        return (Boolean)ENABLE_SMOOTH_TRANSITIONS.get();
    }

    public static boolean enhancedMainhandLightingEnabled() {
        return (Boolean)ENHANCED_MAINHAND_LIGHTING.get();
    }

    public static boolean enhancedOffhandLightingEnabled() {
        return (Boolean)ENHANCED_OFFHAND_LIGHTING.get();
    }

    public static int getDroppedItemRadius() {
        return (Integer)DROPPED_ITEM_SCAN_RADIUS.get();
    }

    public static double getDroppedItemMultiplier() {
        return (Double)DROPPED_ITEM_MULTIPLIER.get();
    }

    public static int getMaxTrackedEntities() {
        return (Integer)MAX_TRACKED_ENTITIES.get();
    }

    public static int getLightUpdateDistance() {
        return (Integer)LIGHT_UPDATE_DISTANCE.get();
    }

    public static boolean optimizeLightUpdatesEnabled() {
        return (Boolean)OPTIMIZE_LIGHT_UPDATES.get();
    }

    public static int getTransitionLightDuration() {
        return (Integer)TRANSITION_LIGHT_DURATION.get();
    }

    static {
        DEFAULT_LIGHT_ITEMS = Map.ofEntries(Map.entry("minecraft:torch", 14), Map.entry("minecraft:lantern", 15), Map.entry("minecraft:soul_lantern", 10), Map.entry("minecraft:soul_torch", 10), Map.entry("minecraft:glowstone", 15), Map.entry("minecraft:sea_lantern", 15), Map.entry("minecraft:shroomlight", 15), Map.entry("minecraft:glow_ink_sac", 7), Map.entry("minecraft:campfire", 15), Map.entry("minecraft:soul_campfire", 10), Map.entry("minecraft:redstone_torch", 7), Map.entry("minecraft:jack_o_lantern", 15), Map.entry("minecraft:beacon", 15), Map.entry("minecraft:end_rod", 14), Map.entry("minecraft:lava_bucket", 15), Map.entry("minecraft:glow_berries", 8), Map.entry("minecraft:blaze_rod", 10), Map.entry("minecraft:magma_block", 13), Map.entry("minecraft:ochre_froglight", 15), Map.entry("minecraft:verdant_froglight", 15), Map.entry("minecraft:pearlescent_froglight", 15));
        BUILDER.comment(new String[]{"=== Light Aura Configuration ===", "Configure various lighting behaviors below"}).push("general");
        UPDATE_FREQUENCY = BUILDER.comment(new String[]{"How often lighting updates occur (in ticks)", "Lower values = smoother but more resource intensive", "Default: 1 (every tick)"}).defineInRange("updateFrequency", 1, 1, 20);
        CLEANUP_DELAY = BUILDER.comment(new String[]{"How long lights persist after source is gone (in ticks)", "Higher values = longer fade time", "Default: 3"}).defineInRange("cleanupDelay", 3, 1, 100);
        ENABLE_PLAYER_LIGHTING = BUILDER.comment(new String[]{"Enable dynamic lighting for player-held items", "Set to false to disable all player lighting", "Default: true"}).define("enablePlayerLighting", true);
        ENABLE_SMOOTH_TRANSITIONS = BUILDER.comment(new String[]{"Enable smooth lighting transitions", "Lights will fade in/out gradually instead of appearing instantly", "Default: false (disabled for better performance)"}).define("enableSmoothTransitions", false);
        ENHANCED_MAINHAND_LIGHTING = BUILDER.comment(new String[]{"Enhanced lighting for mainhand items", "Provides additional light coverage when holding items in main hand", "Default: true"}).define("enhancedMainhandLighting", true);
        ENHANCED_OFFHAND_LIGHTING = BUILDER.comment(new String[]{"Enhanced lighting for offhand items", "Provides additional light coverage when holding items in off hand", "Default: true"}).define("enhancedOffhandLighting", true);
        BUILDER.pop().push("items");
        DROPPED_ITEM_SCAN_RADIUS = BUILDER.comment(new String[]{"Radius to scan for dropped light-emitting items (in blocks)", "Larger values may impact performance", "Default: 16"}).defineInRange("droppedItemRadius", 16, 4, 64);
        DROPPED_ITEM_MULTIPLIER = BUILDER.comment(new String[]{"Brightness multiplier for dropped items (0.1-1.0)", "Dropped items will be this percentage of their normal brightness", "Default: 0.7 (70% brightness)"}).defineInRange("droppedItemMultiplier", 0.7, 0.1, 1.0);
        MAX_TRACKED_ENTITIES = BUILDER.comment(new String[]{"Maximum number of dropped items to track for lighting", "Higher values may impact performance", "Default: 50"}).defineInRange("maxTrackedEntities", 50, 10, 200);
        CUSTOM_LIGHT_ITEMS = BUILDER.comment(new String[]{"Custom light-emitting items (format: modid:item=level)", "Add or modify items that emit light when held or dropped", "Light level must be between 1-15", "Example: minecraft:blaze_rod=10"}).defineList("customLightItems", DEFAULT_LIGHT_ITEMS.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.toList()), entry -> entry instanceof String && ((String)entry).matches("^[a-z0-9_]+:[a-z0-9_/]+=([1-9]|1[0-5])$"));
        BUILDER.pop().push("performance");
        LIGHT_UPDATE_DISTANCE = BUILDER.comment(new String[]{"Maximum distance for light updates (in blocks)", "Lights beyond this distance won't be processed", "Default: 32"}).defineInRange("lightUpdateDistance", 32, 16, 128);
        OPTIMIZE_LIGHT_UPDATES = BUILDER.comment(new String[]{"Enable light update optimizations", "May improve performance at the cost of some lighting accuracy", "Default: true"}).define("optimizeLightUpdates", true);
        TRANSITION_LIGHT_DURATION = BUILDER.comment(new String[]{"Duration of smooth light transitions (in ticks)", "Only used when smooth transitions are enabled", "Default: 5"}).defineInRange("transitionLightDuration", 5, 1, 20);
        BUILDER.pop();
        SPEC = BUILDER.build();
        lastConfigLoadTime = 0L;
    }
}

