/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.LightSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightManager {
    private final Map<BlockPos, LightSource> activeLights = new HashMap<BlockPos, LightSource>();
    private final Map<Entity, BlockPos> entityLights = new HashMap<Entity, BlockPos>();
    private final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
    private final Map<BlockPos, Integer> transitioningLights = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, BlockState> originalBlockStates = new HashMap<BlockPos, BlockState>();
    private final Set<BlockPos> preservedPlantPositions = new HashSet<BlockPos>();
    private final Set<Entity> pendingPickupEntities = new HashSet<Entity>();
    private boolean enableSmoothTransitions = true;
    private static final int MAX_LIGHT_LEVEL = 15;

    public void cleanupAllLights() {
        this.activeLights.clear();
        this.entityLights.clear();
        this.pendingUpdates.clear();
        this.transitioningLights.clear();
        this.originalBlockStates.clear();
        this.preservedPlantPositions.clear();
        this.pendingPickupEntities.clear();
    }

    public void cleanupAllPlayerLights(Level level) {
        HashSet<BlockPos> playerLightPositions = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, LightSource> entry : this.activeLights.entrySet()) {
            if (!entry.getValue().isPlayerLight()) continue;
            playerLightPositions.add(entry.getKey());
        }
        for (BlockPos pos : playerLightPositions) {
            this.removeLight(level, pos, true);
        }
    }

    public void addPendingPickupEntity(Entity entity) {
        this.pendingPickupEntities.add(entity);
    }

    public void removeEntityLight(Entity entity) {
        if (this.entityLights.containsKey(entity)) {
            BlockPos lightPos = this.entityLights.get(entity);
            this.removeLight(entity.m_9236_(), lightPos, true);
            this.entityLights.remove(entity);
        }
    }

    public void processTransitioningLights(Level level, boolean enableSmoothTransitions, int transitionLightDuration, boolean isAscending) {
        long now = level.m_46467_();
        Iterator<Map.Entry<BlockPos, Integer>> it = this.transitioningLights.entrySet().iterator();
        while (it.hasNext()) {
            int transitionDuration;
            Map.Entry<BlockPos, Integer> entry = it.next();
            BlockPos pos = entry.getKey();
            int targetLevel = this.clampLightLevel(entry.getValue());
            LightSource source = this.activeLights.get(pos);
            if (source == null) {
                it.remove();
                continue;
            }
            long elapsed = now - source.getLastUpdate();
            int n = transitionDuration = isAscending ? Math.max(1, transitionLightDuration / 2) : transitionLightDuration;
            if (elapsed >= (long)transitionDuration) {
                if (targetLevel > 0) {
                    this.setLightBlock(level, pos, targetLevel);
                } else {
                    this.removeLight(level, pos);
                }
                it.remove();
                continue;
            }
            if (elapsed % 2L != 0L) continue;
            float progress = (float)elapsed / (float)transitionDuration;
            int currentLevel = source.getLightLevel();
            int newLevel = targetLevel > currentLevel ? currentLevel + (int)(progress * (float)(targetLevel - currentLevel)) : currentLevel - (int)(progress * (float)(currentLevel - targetLevel));
            newLevel = this.clampLightLevel(newLevel);
            if (newLevel == currentLevel || newLevel <= 0) continue;
            this.setLightBlock(level, pos, newLevel);
            this.pendingUpdates.add(pos);
        }
    }

    public void setEnableSmoothTransitions(boolean enable) {
        this.enableSmoothTransitions = enable;
    }

    public void cleanupLights(Level level, BlockPos playerPos, boolean forceCleanup, Set<BlockPos> playerLightPositions, Set<BlockPos> offhandLightPositions, Set<BlockPos> mainhandLightPositions, Set<BlockPos> tallGrassLightPositions, int cleanupDelay, int transitionLightDuration, int lightUpdateDistance, boolean optimizeLightUpdates, boolean enableSmoothTransitions) {
        long now = level.m_46467_();
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        HashMap<BlockPos, LightSource> activeLightsCopy = new HashMap<BlockPos, LightSource>(this.activeLights);
        for (Map.Entry entry : activeLightsCopy.entrySet()) {
            boolean shouldRemove;
            boolean stillInUse;
            BlockPos pos = (BlockPos)entry.getKey();
            LightSource src = (LightSource)entry.getValue();
            boolean bl = stillInUse = playerLightPositions.contains(pos) || offhandLightPositions.contains(pos) || mainhandLightPositions.contains(pos) || tallGrassLightPositions.contains(pos);
            if (stillInUse) {
                src.setActive(true);
                continue;
            }
            if (src.getTrackedEntity() != null && src.getTrackedEntity().m_6084_() && !this.pendingPickupEntities.contains(src.getTrackedEntity()) || !forceCleanup && this.transitioningLights.containsKey(pos)) continue;
            if (optimizeLightUpdates && playerPos.m_123331_((Vec3i)pos) > (double)(lightUpdateDistance * lightUpdateDistance)) {
                toRemove.add(pos);
                continue;
            }
            int effectiveCleanupDelay = src.isPlayerLight() ? Math.max(1, cleanupDelay / 2) : cleanupDelay;
            boolean bl2 = shouldRemove = !src.isActive() || now - src.getLastUpdate() > (long)effectiveCleanupDelay;
            if (forceCleanup && pos.m_123342_() >= playerPos.m_123342_()) {
                shouldRemove = true;
            }
            if (src.getTrackedEntity() != null && this.pendingPickupEntities.contains(src.getTrackedEntity())) {
                shouldRemove = true;
                forceCleanup = true;
            }
            if (src.isPlayerLight() && !stillInUse) {
                shouldRemove = true;
                forceCleanup = true;
            }
            if (!shouldRemove) continue;
            if (enableSmoothTransitions && !forceCleanup && src.getLightLevel() > 0 && !src.isPlayerLight()) {
                this.transitioningLights.put(pos, 0);
                src.setActive(false);
                this.activeLights.put(pos, src);
                continue;
            }
            toRemove.add(pos);
        }
        for (BlockPos pos : toRemove) {
            this.removeLight(level, pos, forceCleanup || this.activeLights.get(pos).isPlayerLight());
        }
    }

    public void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight, boolean isMainhandLight) {
        LightSource existing;
        if ((lightLevel = this.clampLightLevel(lightLevel)) <= 0 || pos == null) {
            return;
        }
        if (entity != null && this.pendingPickupEntities.contains(entity)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        boolean isPlantBlock = this.isPlantBlock(state);
        BlockPos lightPos = pos;
        if (isPlantBlock) {
            lightPos = this.findNearbyAirBlock(level, pos);
            if (lightPos == null && !level.m_8055_(lightPos = pos.m_7494_()).m_60795_() && !level.m_8055_(lightPos).m_60713_(Blocks.f_152480_)) {
                return;
            }
        } else {
            boolean canPlaceLight;
            boolean bl = canPlaceLight = state.m_60795_() || state.m_60713_(Blocks.f_152480_);
            if (!canPlaceLight) {
                return;
            }
        }
        if ((existing = this.activeLights.get(lightPos)) != null && existing.isPlayerLight() && (isOffhandLight || isMainhandLight) ? lightLevel <= existing.getLightLevel() : (!(existing == null || !existing.isOffhandLight() && !existing.isMainhandLight() || !isOffhandLight && !isMainhandLight) ? lightLevel <= existing.getLightLevel() : existing != null && lightLevel <= existing.getLightLevel())) {
            return;
        }
        this.setLightBlock(level, lightPos, lightLevel);
        this.activeLights.put(lightPos, new LightSource(lightLevel, level.m_46467_(), isPlayerLight, entity, isOffhandLight, isMainhandLight));
        this.pendingUpdates.add(lightPos);
    }

    private BlockPos findNearbyAirBlock(Level level, BlockPos center) {
        BlockPos[] offsets;
        for (BlockPos testPos : offsets = new BlockPos[]{center.m_7494_(), center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_(), center.m_7494_().m_122012_(), center.m_7494_().m_122019_(), center.m_7494_().m_122029_(), center.m_7494_().m_122024_()}) {
            BlockState testState = level.m_8055_(testPos);
            if (!testState.m_60795_() && !testState.m_60713_(Blocks.f_152480_)) continue;
            return testPos;
        }
        return null;
    }

    public void removeLight(Level level, BlockPos pos) {
        this.removeLight(level, pos, false);
    }

    public void removeLight(Level level, BlockPos pos, boolean forceImmediate) {
        LightSource source = this.activeLights.remove(pos);
        if (source != null) {
            boolean useTransition;
            boolean bl = useTransition = this.enableSmoothTransitions && !forceImmediate && source.getLightLevel() > 0 && !source.isPlayerLight();
            if (useTransition) {
                this.transitioningLights.put(pos, 0);
                source.setActive(false);
                this.activeLights.put(pos, source);
            } else {
                this.transitioningLights.remove(pos);
                BlockState current = level.m_8055_(pos);
                if (current.m_60713_(Blocks.f_152480_)) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
            this.pendingUpdates.add(pos);
        }
    }

    public void setLightBlock(Level level, BlockPos pos, int lightLevel) {
        lightLevel = this.clampLightLevel(lightLevel);
        if (level.f_46443_) {
            BlockState current = level.m_8055_(pos);
            if (lightLevel > 0) {
                if (!(!current.m_60795_() && !current.m_60713_(Blocks.f_152480_) || current.m_60713_(Blocks.f_152480_) && (Integer)current.m_61143_((Property)LightBlock.f_153657_) == lightLevel)) {
                    level.m_7731_(pos, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(lightLevel)), 3);
                }
            } else if (lightLevel == 0 && current.m_60713_(Blocks.f_152480_)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public void applyLightUpdates(Level level, BlockPos lastPlayerPos, boolean isAscending) {
        if (!this.pendingUpdates.isEmpty() && level.f_46443_) {
            if (isAscending && lastPlayerPos != null) {
                for (BlockPos pos : this.pendingUpdates) {
                    if (pos.m_123342_() < lastPlayerPos.m_123342_()) continue;
                    level.m_5518_().m_7174_(pos);
                }
                for (BlockPos pos : this.pendingUpdates) {
                    if (pos.m_123342_() >= lastPlayerPos.m_123342_()) continue;
                    level.m_5518_().m_7174_(pos);
                }
            } else {
                for (BlockPos pos : this.pendingUpdates) {
                    level.m_5518_().m_7174_(pos);
                }
            }
            this.pendingUpdates.clear();
        }
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }

    private boolean isPlantBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_) || state.m_60713_(Blocks.f_50130_) || state.m_60713_(Blocks.f_50092_) || state.m_60713_(Blocks.f_50249_) || state.m_60713_(Blocks.f_50250_) || state.m_60713_(Blocks.f_50444_) || state.m_60713_(Blocks.f_50189_) || state.m_60713_(Blocks.f_50190_) || state.m_60713_(Blocks.f_50191_) || state.m_60713_(Blocks.f_50196_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50571_) || state.m_60713_(Blocks.f_50570_) || state.m_60713_(Blocks.f_50128_) || state.m_60713_(Blocks.f_50036_) || state.m_60713_(Blocks.f_50111_) || state.m_60713_(Blocks.f_50112_) || state.m_60713_(Blocks.f_50113_) || state.m_60713_(Blocks.f_50114_) || state.m_60713_(Blocks.f_50115_) || state.m_60713_(Blocks.f_50116_) || state.m_60713_(Blocks.f_50117_) || state.m_60713_(Blocks.f_50118_) || state.m_60713_(Blocks.f_50119_) || state.m_60713_(Blocks.f_50120_) || state.m_60713_(Blocks.f_50121_) || state.m_60713_(Blocks.f_50071_) || state.m_60713_(Blocks.f_50070_) || state.m_60713_(Blocks.f_50355_) || state.m_60713_(Blocks.f_50356_) || state.m_60713_(Blocks.f_50357_) || state.m_60713_(Blocks.f_50358_) || state.m_60713_(Blocks.f_50654_) || state.m_60713_(Blocks.f_50693_) || state.m_60713_(Blocks.f_50694_) || state.m_60713_(Blocks.f_50702_) || state.m_60713_(Blocks.f_50704_) || state.m_60713_(Blocks.f_152475_);
    }

    public Map<Entity, BlockPos> getEntityLights() {
        return this.entityLights;
    }

    public Set<Entity> getPendingPickupEntities() {
        return this.pendingPickupEntities;
    }

    public void clearPendingPickupEntities() {
        this.pendingPickupEntities.clear();
    }

    public void putEntityLight(Entity entity, BlockPos pos) {
        this.entityLights.put(entity, pos);
    }

    public Map<BlockPos, LightSource> getActiveLights() {
        return this.activeLights;
    }

    public Set<BlockPos> getPreservedPlantPositions() {
        return this.preservedPlantPositions;
    }

    public Map<BlockPos, BlockState> getOriginalBlockStates() {
        return this.originalBlockStates;
    }

    public Map<BlockPos, Integer> getTransitioningLights() {
        return this.transitioningLights;
    }

    public void removeOldLightPositions(Level level, Set<BlockPos> playerLightPositions, Set<BlockPos> playerLightPositions1, boolean isAscending) {
    }
}

