/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import net.minecraft.world.entity.Entity;

public class LightSource {
    final int lightLevel;
    final long lastUpdate;
    final boolean isPlayerLight;
    final Entity trackedEntity;
    final boolean isOffhandLight;
    final boolean isMainhandLight;
    boolean isActive = true;
    private static final int MAX_LIGHT_LEVEL = 15;

    public LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity) {
        this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, false, false);
    }

    public LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight) {
        this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, isOffhandLight, false);
    }

    public LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight, boolean isMainhandLight) {
        this.lightLevel = Math.max(0, Math.min(15, lightLevel));
        this.lastUpdate = lastUpdate;
        this.isPlayerLight = isPlayerLight;
        this.trackedEntity = trackedEntity;
        this.isOffhandLight = isOffhandLight;
        this.isMainhandLight = isMainhandLight;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isPlayerLight() {
        return this.isPlayerLight;
    }

    public Entity getTrackedEntity() {
        return this.trackedEntity;
    }

    public boolean isOffhandLight() {
        return this.isOffhandLight;
    }

    public boolean isMainhandLight() {
        return this.isMainhandLight;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }
}

