/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DroppedItemLight;
import com.example.lightaura.LightAuraConfig;
import com.example.lightaura.LightAuraMod;
import com.example.lightaura.LightSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_6089;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class ClientEventHandler {
    private final Map<class_2338, LightSource> activeLights = new ConcurrentHashMap<class_2338, LightSource>();
    private final Map<class_1297, DroppedItemLight> droppedItemLights = new ConcurrentHashMap<class_1297, DroppedItemLight>();
    private final Set<class_2338> pendingUpdates = ConcurrentHashMap.newKeySet();
    private final Set<class_2338> playerLightPositions = ConcurrentHashMap.newKeySet();
    private final Map<class_2338, class_2680> originalBlockStates = new ConcurrentHashMap<class_2338, class_2680>();
    private final Map<class_2338, Double> lightTransitions = new ConcurrentHashMap<class_2338, Double>();
    private class_2338 lastPlayerPos;
    private int playerLightLevel = 0;
    private final Map<class_1792, Integer> lightItems = new HashMap<class_1792, Integer>();
    private long lastPerformanceLog = 0L;
    private int lightUpdateCount = 0;
    private int lightRemovalCount = 0;

    public ClientEventHandler() {
        this.updateLightItems();
        LightAuraMod.LOGGER.info("LightAura Client Event Handler initialized with {} light-emitting items", (Object)this.lightItems.size());
    }

    private void updateLightItems() {
        this.lightItems.clear();
        this.lightItems.putAll(LightAuraConfig.getLightItems());
    }

    public void onClientTick(class_310 client) {
        double distance;
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (player == null || world == null) {
            return;
        }
        if (LightAuraConfig.Performance.ENABLE_PERFORMANCE_MODE && (distance = new class_243(player.method_23317(), player.method_23318(), player.method_23321()).method_1022(class_243.method_24953((class_2382)player.method_24515()))) > (double)LightAuraConfig.Performance.PERFORMANCE_MODE_RADIUS) {
            return;
        }
        int updateFreq = LightAuraConfig.Performance.UPDATE_FREQUENCY;
        if (LightAuraConfig.PlayerLighting.ENABLE_ANIMATION_LIGHTING && player.method_6115()) {
            updateFreq = Math.max(1, (int)((double)updateFreq * LightAuraConfig.PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER));
        }
        if (world.method_8510() % (long)updateFreq != 0L) {
            return;
        }
        if (this.activeLights.size() > LightAuraConfig.Performance.MAX_LIGHT_SOURCES) {
            this.cleanupExcessLights((class_1937)world);
        }
        class_2338 currentPos = player.method_24515();
        if (LightAuraConfig.PlayerLighting.ENABLE_PLAYER_LIGHTING) {
            this.updatePlayerLightLevel((class_1657)player);
            this.handlePlayerLighting((class_1937)world, (class_1657)player, currentPos);
        }
        if (LightAuraConfig.DroppedItemLighting.ENABLE_DROPPED_ITEM_LIGHTING) {
            this.handleDroppedItemLighting((class_1937)world, (class_1657)player);
        }
        if (LightAuraConfig.Visual.ENABLE_SMOOTH_TRANSITIONS) {
            this.handleSmoothTransitions((class_1937)world);
        }
        this.cleanupLights((class_1937)world);
        this.applyLightUpdates((class_1937)world);
        if (LightAuraConfig.Debug.ENABLE_PERFORMANCE_METRICS) {
            this.logPerformanceMetrics((class_1937)world);
        }
        this.lastPlayerPos = currentPos;
    }

    private void cleanupExcessLights(class_1937 world) {
        ArrayList<Map.Entry<class_2338, LightSource>> sortedLights = new ArrayList<Map.Entry<class_2338, LightSource>>(this.activeLights.entrySet());
        sortedLights.sort((a, b) -> Long.compare(((LightSource)a.getValue()).lastUpdate, ((LightSource)b.getValue()).lastUpdate));
        int toRemove = this.activeLights.size() - LightAuraConfig.Performance.MAX_LIGHT_SOURCES;
        for (int i = 0; i < toRemove; ++i) {
            class_2338 pos = (class_2338)((Map.Entry)sortedLights.get(i)).getKey();
            if (this.playerLightPositions.contains(pos)) continue;
            this.removeLight(world, pos);
        }
    }

    private void updatePlayerLightLevel(class_1657 player) {
        int newLevel = 0;
        if (LightAuraConfig.PlayerLighting.ENABLE_HAND_POSITION_LIGHTING) {
            newLevel = Math.max(newLevel, this.getLightLevel(player.method_6047()));
            newLevel = Math.max(newLevel, this.getLightLevel(player.method_6079()));
        }
        if (LightAuraConfig.PlayerLighting.ENABLE_ANIMATION_LIGHTING && player.method_6115()) {
            newLevel = (int)((double)newLevel * LightAuraConfig.PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER);
        }
        this.playerLightLevel = Math.min(15, newLevel);
    }

    private int getLightLevel(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        return this.lightItems.getOrDefault(stack.method_7909(), 0);
    }

    private void handlePlayerLighting(class_1937 world, class_1657 player, class_2338 currentPos) {
        HashSet<class_2338> currentLights = new HashSet<class_2338>();
        if (this.playerLightLevel > 0) {
            this.addLightPosition(currentLights, world, currentPos);
            if (LightAuraConfig.PlayerLighting.ENABLE_OFFSETS && LightAuraConfig.PlayerLighting.ENABLE_EYE_POSITION_LIGHTING) {
                this.addLightPosition(currentLights, world, class_2338.method_49638((class_2374)player.method_33571()));
            }
            if (LightAuraConfig.PlayerLighting.ENABLE_SURROUNDING_POSITIONS && this.isInNonSolidBlock(world, currentPos)) {
                this.addLightPosition(currentLights, world, currentPos.method_10084());
                this.addLightPosition(currentLights, world, currentPos.method_10095());
                this.addLightPosition(currentLights, world, currentPos.method_10072());
                this.addLightPosition(currentLights, world, currentPos.method_10078());
                this.addLightPosition(currentLights, world, currentPos.method_10067());
            }
            if (LightAuraConfig.PlayerLighting.ENABLE_ANIMATION_LIGHTING && player.method_6115()) {
                class_2338 handPos = class_2338.method_49637((double)player.method_23317(), (double)(player.method_23318() + 1.0), (double)player.method_23321());
                this.addLightPosition(currentLights, world, handPos);
            }
        }
        currentLights.forEach(pos -> {
            int lightLevel = this.playerLightLevel;
            if (LightAuraConfig.Visual.ENABLE_FLICKER_EFFECT) {
                lightLevel = this.applyFlickerEffect(lightLevel, world.method_8510());
            }
            this.placeLight(world, (class_2338)pos, lightLevel, true);
        });
        this.playerLightPositions.removeIf(pos -> !currentLights.contains(pos) && this.removeLight(world, (class_2338)pos));
        this.playerLightPositions.addAll(currentLights);
    }

    private int applyFlickerEffect(int lightLevel, long worldTime) {
        if (LightAuraConfig.Visual.FLICKER_INTENSITY <= 0.0) {
            return lightLevel;
        }
        double flicker = Math.sin((double)worldTime * 0.1) * LightAuraConfig.Visual.FLICKER_INTENSITY;
        return Math.max(1, (int)((double)lightLevel + flicker));
    }

    private void addLightPosition(Set<class_2338> positions, class_1937 world, class_2338 pos) {
        if (LightAuraConfig.WorldInteraction.PRESERVE_BLOCKS && !this.isAirOrLightBlock(world, pos)) {
            for (class_2338 adjacent : this.getAdjacentPositions(pos)) {
                if (!this.isAirOrLightBlock(world, adjacent)) continue;
                positions.add(adjacent);
                return;
            }
            if (!this.isPlantBlock(world, pos) && !this.isBlacklistedBlock(world, pos)) {
                positions.add(pos);
            }
        } else if (!this.isBlacklistedBlock(world, pos)) {
            positions.add(pos);
        }
    }

    private boolean isBlacklistedBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        String blockId = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        return LightAuraConfig.isBlacklistedBlock(blockId);
    }

    private List<class_2338> getAdjacentPositions(class_2338 pos) {
        ArrayList<class_2338> adjacent = new ArrayList<class_2338>();
        adjacent.add(pos.method_10084());
        adjacent.add(pos.method_10095());
        adjacent.add(pos.method_10072());
        adjacent.add(pos.method_10078());
        adjacent.add(pos.method_10067());
        adjacent.add(pos.method_10074());
        return adjacent;
    }

    private boolean isAirOrLightBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        boolean isAir = state.method_26215();
        boolean isLight = state.method_27852(class_2246.field_31037);
        boolean isWater = LightAuraConfig.WorldInteraction.ENABLE_WATER_LIGHTING && state.method_27852(class_2246.field_10382);
        boolean isLava = LightAuraConfig.WorldInteraction.ENABLE_LAVA_LIGHTING && state.method_27852(class_2246.field_10164);
        return isAir || isLight || isWater || isLava;
    }

    private boolean isPlantBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26204() instanceof class_2261;
    }

    private boolean isInNonSolidBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_26215() && (!state.method_51367() || state.method_26204() instanceof class_2261);
    }

    private void handleDroppedItemLighting(class_1937 world, class_1657 player) {
        int scanRadius = LightAuraConfig.DroppedItemLighting.SCAN_RADIUS;
        double multiplier = LightAuraConfig.DroppedItemLighting.LIGHT_MULTIPLIER;
        boolean allowStacking = LightAuraConfig.DroppedItemLighting.ENABLE_STACKING;
        int maxLights = LightAuraConfig.DroppedItemLighting.MAX_LIGHTS;
        this.droppedItemLights.entrySet().removeIf(entry -> {
            class_1297 entity = (class_1297)entry.getKey();
            DroppedItemLight light = (DroppedItemLight)entry.getValue();
            if (!entity.method_5805() || entity.method_31481()) {
                this.removeLight(world, light.position);
                return true;
            }
            class_2338 newPos = entity.method_24515();
            if (!newPos.equals((Object)light.position)) {
                this.removeLight(world, light.position);
                light.position = newPos;
                class_2338 lightPos = this.findSuitableLightPosition(world, newPos);
                int lightLevel = light.lightLevel;
                if (LightAuraConfig.DroppedItemLighting.ENABLE_DISTANCE_SCALING) {
                    double distance = new class_243(player.method_23317(), player.method_23318(), player.method_23321()).method_1022(new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321()));
                    double scale = Math.max(LightAuraConfig.DroppedItemLighting.MIN_DISTANCE_MULTIPLIER, 1.0 - distance / (double)scanRadius);
                    lightLevel = (int)((double)lightLevel * scale);
                }
                this.placeLight(world, lightPos, lightLevel, false, entity);
            }
            return false;
        });
        if (this.droppedItemLights.size() >= maxLights) {
            return;
        }
        List nearbyItems = world.method_8390(class_1542.class, player.method_5829().method_1014((double)scanRadius), entity -> entity.method_5805() && !entity.method_31481());
        nearbyItems.sort((a, b) -> Double.compare(new class_243(a.method_23317(), a.method_23318(), a.method_23321()).method_1022(new class_243(player.method_23317(), player.method_23318(), player.method_23321())), new class_243(b.method_23317(), b.method_23318(), b.method_23321()).method_1022(new class_243(player.method_23317(), player.method_23318(), player.method_23321()))));
        for (class_1542 itemEntity : nearbyItems) {
            if (this.droppedItemLights.containsKey(itemEntity)) continue;
            if (this.droppedItemLights.size() >= maxLights) break;
            class_1799 stack = itemEntity.method_6983();
            int baseLightLevel = this.getLightLevel(stack);
            if (baseLightLevel <= 0) continue;
            int finalLightLevel = (int)Math.max(1.0, (double)baseLightLevel * multiplier);
            if (LightAuraConfig.DroppedItemLighting.ENABLE_DISTANCE_SCALING) {
                double distance = new class_243(player.method_23317(), player.method_23318(), player.method_23321()).method_1022(new class_243(itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321()));
                double scale = Math.max(LightAuraConfig.DroppedItemLighting.MIN_DISTANCE_MULTIPLIER, 1.0 - distance / (double)scanRadius);
                finalLightLevel = (int)((double)finalLightLevel * scale);
            }
            if (allowStacking) {
                finalLightLevel = this.calculateStackedLightLevel(world, itemEntity.method_24515(), finalLightLevel);
            }
            finalLightLevel = Math.min(15, Math.max(1, finalLightLevel));
            class_2338 itemPos = itemEntity.method_24515();
            class_2338 lightPos = this.findSuitableLightPosition(world, itemPos);
            if (!this.placeLight(world, lightPos, finalLightLevel, false, (class_1297)itemEntity)) continue;
            this.droppedItemLights.put((class_1297)itemEntity, new DroppedItemLight(lightPos, finalLightLevel, stack.method_7909()));
            if (!LightAuraConfig.Debug.ENABLE_DEBUG_LOGGING || world.method_8510() % (long)LightAuraConfig.Debug.LOG_FREQUENCY != 0L) continue;
            LightAuraMod.LOGGER.debug("Dropped {} at {} now glowing with light level {}", new Object[]{stack.method_7909().toString(), lightPos, finalLightLevel});
        }
    }

    private class_2338 findSuitableLightPosition(class_1937 world, class_2338 pos) {
        if (LightAuraConfig.WorldInteraction.PRESERVE_BLOCKS && !this.isAirOrLightBlock(world, pos)) {
            for (class_2338 adjacent : this.getAdjacentPositions(pos)) {
                if (!this.isAirOrLightBlock(world, adjacent) || this.isBlacklistedBlock(world, adjacent)) continue;
                return adjacent;
            }
        }
        return pos;
    }

    private int calculateStackedLightLevel(class_1937 world, class_2338 pos, int newLightLevel) {
        List itemsAtPos = world.method_8390(class_1542.class, class_238.method_30048((class_243)class_243.method_24954((class_2382)pos), (double)1.0, (double)1.0, (double)1.0), entity -> entity.method_24515().equals((Object)pos) && entity.method_5805());
        int totalLight = newLightLevel;
        for (class_1542 item : itemsAtPos) {
            if (this.droppedItemLights.containsKey(item)) continue;
            int itemLight = (int)((double)this.getLightLevel(item.method_6983()) * LightAuraConfig.DroppedItemLighting.LIGHT_MULTIPLIER);
            totalLight += itemLight / 2;
        }
        return Math.min(15, totalLight);
    }

    private void handleSmoothTransitions(class_1937 world) {
        this.lightTransitions.entrySet().removeIf(entry -> {
            block4: {
                class_2338 pos = (class_2338)entry.getKey();
                double currentTransition = (Double)entry.getValue();
                LightSource source = this.activeLights.get(pos);
                if (source == null) {
                    return true;
                }
                double targetLight = source.lightLevel;
                double newTransition = currentTransition + (targetLight - currentTransition) * LightAuraConfig.Visual.TRANSITION_SPEED;
                if (Math.abs(newTransition - targetLight) < 0.1) {
                    return true;
                }
                entry.setValue(newTransition);
                try {
                    world.method_8652(pos, (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf((int)newTransition)), 3);
                }
                catch (Exception e) {
                    if (!LightAuraConfig.Debug.ENABLE_DEBUG_LOGGING) break block4;
                    LightAuraMod.LOGGER.debug("Failed to update transition at {}: {}", (Object)pos, (Object)e.getMessage());
                }
            }
            return false;
        });
    }

    private void cleanupLights(class_1937 world) {
        long now = world.method_8510();
        int cleanupDelay = LightAuraConfig.Performance.CLEANUP_DELAY;
        this.activeLights.entrySet().removeIf(entry -> {
            class_2338 pos = (class_2338)entry.getKey();
            LightSource src = (LightSource)entry.getValue();
            if (this.playerLightPositions.contains(pos)) {
                return false;
            }
            if (src.trackedEntity != null && src.trackedEntity.method_5805() && !src.trackedEntity.method_31481()) {
                return false;
            }
            if (now - src.lastUpdate <= (long)cleanupDelay) {
                return false;
            }
            this.removeLight(world, pos);
            return true;
        });
    }

    private boolean placeLight(class_1937 world, class_2338 pos, int lightLevel, boolean isPlayerLight) {
        return this.placeLight(world, pos, lightLevel, isPlayerLight, null);
    }

    private boolean placeLight(class_1937 world, class_2338 pos, int lightLevel, boolean isPlayerLight, class_1297 entity) {
        if (lightLevel <= 0 || lightLevel > 15) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        boolean canPlaceLight = this.isAirOrLightBlock(world, pos);
        if (!canPlaceLight && LightAuraConfig.WorldInteraction.ENABLE_ENHANCED_PLANT_LIGHTING && !LightAuraConfig.WorldInteraction.PRESERVE_BLOCKS) {
            boolean bl = canPlaceLight = !state.method_51367() || state.method_26204() instanceof class_2261;
        }
        if (!canPlaceLight || this.isBlacklistedBlock(world, pos)) {
            return false;
        }
        LightSource existing = this.activeLights.get(pos);
        if (existing == null || existing.lightLevel < lightLevel || existing.lightLevel == lightLevel && existing.trackedEntity == null && entity != null) {
            this.activeLights.put(pos, new LightSource(lightLevel, world.method_8510(), isPlayerLight, entity));
            if (world.method_8608()) {
                try {
                    if (LightAuraConfig.WorldInteraction.PRESERVE_BLOCKS && !this.originalBlockStates.containsKey(pos) && !state.method_27852(class_2246.field_31037)) {
                        this.originalBlockStates.put(pos, state);
                    }
                    if (LightAuraConfig.Visual.ENABLE_SMOOTH_TRANSITIONS) {
                        this.lightTransitions.put(pos, Double.valueOf(lightLevel));
                    }
                    world.method_8652(pos, (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(lightLevel)), 3);
                    this.pendingUpdates.add(pos);
                    ++this.lightUpdateCount;
                    return true;
                }
                catch (Exception e) {
                    if (LightAuraConfig.Debug.ENABLE_DEBUG_LOGGING) {
                        LightAuraMod.LOGGER.warn("Failed to place light block at {}: {}", (Object)pos, (Object)e.getMessage());
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private boolean removeLight(class_1937 world, class_2338 pos) {
        if (this.activeLights.remove(pos) != null) {
            this.lightTransitions.remove(pos);
            if (world.method_8608() && world.method_8320(pos).method_27852(class_2246.field_31037)) {
                try {
                    if (LightAuraConfig.WorldInteraction.PRESERVE_BLOCKS && this.originalBlockStates.containsKey(pos)) {
                        world.method_8652(pos, this.originalBlockStates.remove(pos), 3);
                    } else {
                        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    }
                    this.pendingUpdates.add(pos);
                    ++this.lightRemovalCount;
                    return true;
                }
                catch (Exception e) {
                    if (LightAuraConfig.Debug.ENABLE_DEBUG_LOGGING) {
                        LightAuraMod.LOGGER.warn("Failed to remove light block at {}: {}", (Object)pos, (Object)e.getMessage());
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private void applyLightUpdates(class_1937 world) {
        if (!this.pendingUpdates.isEmpty() && world.method_8608()) {
            this.pendingUpdates.forEach(pos -> {
                block2: {
                    try {
                        world.method_22336().method_15513(pos);
                    }
                    catch (Exception e) {
                        if (!LightAuraConfig.Debug.ENABLE_DEBUG_LOGGING) break block2;
                        LightAuraMod.LOGGER.warn("Failed to update lighting at {}: {}", pos, (Object)e.getMessage());
                    }
                }
            });
            this.pendingUpdates.clear();
        }
    }

    private void logPerformanceMetrics(class_1937 world) {
        long currentTime = world.method_8510();
        if (currentTime - this.lastPerformanceLog >= (long)LightAuraConfig.Debug.LOG_FREQUENCY) {
            LightAuraMod.LOGGER.info("Performance Metrics - Active Lights: {}, Updates: {}, Removals: {}, Transitions: {}", new Object[]{this.activeLights.size(), this.lightUpdateCount, this.lightRemovalCount, this.lightTransitions.size()});
            this.lastPerformanceLog = currentTime;
            this.lightUpdateCount = 0;
            this.lightRemovalCount = 0;
        }
    }

    public void reloadConfig() {
        this.updateLightItems();
        LightAuraMod.LOGGER.info("ClientEventHandler reloaded with {} light items", (Object)this.lightItems.size());
    }

    public int getActiveLightCount() {
        return this.activeLights.size();
    }

    public int getDroppedItemLightCount() {
        return this.droppedItemLights.size();
    }
}

