/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightaura")
public class DynamicLightingMod {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<BlockPos, LightSource> lightBlocks = new ConcurrentHashMap<BlockPos, LightSource>();
    private static final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
    private static final Map<Item, Integer> lightItems = new HashMap<Item, Integer>();
    private static int updateFrequency = 2;
    private static int cleanupDelay = 5;
    private static int currentPlayerLightLevel = 0;
    private static BlockPos lastPlayerPos = null;

    public DynamicLightingMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightingConfig.CLIENT_CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupLightItems();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Dynamic Lighting Mod initialized");
        updateFrequency = (Integer)DynamicLightingConfig.UPDATE_FREQUENCY.get();
        cleanupDelay = (Integer)DynamicLightingConfig.CLEANUP_DELAY.get();
    }

    private void setupLightItems() {
        lightItems.put(Items.f_42000_, 14);
        lightItems.put(Items.f_42053_, 10);
        lightItems.put(Items.f_42778_, 15);
        lightItems.put(Items.f_42779_, 10);
        lightItems.put(Items.f_42054_, 15);
        lightItems.put(Items.f_42251_, 15);
        lightItems.put(Items.f_42055_, 15);
        lightItems.put(Items.f_42448_, 15);
        lightItems.put(Items.f_151079_, 8);
        lightItems.put(Items.f_151056_, 10);
        lightItems.put(Items.f_42585_, 10);
        lightItems.put(Items.f_42258_, 13);
        lightItems.put(Items.f_42783_, 15);
        lightItems.put(Items.f_42001_, 14);
        lightItems.put(Items.f_41978_, 7);
        DynamicLightingConfig.getLightItemsFromConfig().forEach(lightItems::put);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ClientLevel level = minecraft.f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (minecraft.f_91073_.m_46467_() % (long)updateFrequency != 0L) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        int lightLevel = 0;
        if (lightItems.containsKey(mainHandItem.m_41720_())) {
            lightLevel = Math.max(lightLevel, lightItems.get(mainHandItem.m_41720_()));
        }
        if (lightItems.containsKey(offHandItem.m_41720_())) {
            lightLevel = Math.max(lightLevel, lightItems.get(offHandItem.m_41720_()));
        }
        currentPlayerLightLevel = lightLevel;
        BlockPos playerPos = player.m_20183_();
        if (lightLevel > 0) {
            this.placeLightSource((Player)player, (Level)level, lightLevel);
        } else {
            this.removeLightAtPosition((Level)level, playerPos);
        }
        this.cleanupLightSources((Level)level, minecraft.f_91073_.m_46467_(), playerPos);
        this.applyLightUpdates((Level)level);
        lastPlayerPos = playerPos;
    }

    private void placeLightSource(Player player, Level level, int lightLevel) {
        boolean shouldUpdateLight;
        BlockPos playerPos = player.m_20183_();
        LightSource existingLight = lightBlocks.get(playerPos);
        boolean bl = shouldUpdateLight = existingLight == null || existingLight.lightLevel < lightLevel || !existingLight.isActive;
        if (shouldUpdateLight) {
            if (existingLight == null) {
                lightBlocks.put(playerPos, new LightSource(lightLevel, level.m_46467_()));
            } else {
                existingLight.lightLevel = lightLevel;
                existingLight.lastUpdate = level.m_46467_();
                existingLight.isActive = true;
            }
            if (!pendingUpdates.contains(playerPos)) {
                pendingUpdates.add(playerPos);
                this.updateLightAt(level, playerPos, lightLevel);
            }
        }
    }

    private void removeLightAtPosition(Level level, BlockPos pos) {
        if (lightBlocks.containsKey(pos)) {
            DynamicLightingMod.lightBlocks.get((Object)pos).isActive = false;
            DynamicLightingMod.lightBlocks.get((Object)pos).lastUpdate = level.m_46467_() - (long)cleanupDelay;
            if (!pendingUpdates.contains(pos)) {
                pendingUpdates.add(pos);
                this.updateLightAt(level, pos, 0);
            }
            lightBlocks.remove(pos);
        }
    }

    private void cleanupLightSources(Level level, long currentTime, BlockPos currentPlayerPos) {
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, LightSource> entry : lightBlocks.entrySet()) {
            BlockPos pos = entry.getKey();
            LightSource lightSource = entry.getValue();
            if (pos.equals((Object)currentPlayerPos) || lightSource.isActive && currentTime - lightSource.lastUpdate <= (long)cleanupDelay) continue;
            toRemove.add(pos);
            if (pendingUpdates.contains(pos)) continue;
            pendingUpdates.add(pos);
            this.updateLightAt(level, pos, 0);
        }
        for (BlockPos pos : toRemove) {
            lightBlocks.remove(pos);
        }
    }

    private void updateLightAt(Level level, BlockPos pos, int lightLevel) {
        try {
            if (lightLevel > 0) {
                LOGGER.debug("Setting light level {} at {}", (Object)lightLevel, (Object)pos);
                BlockState currentState = level.m_8055_(pos);
                if (currentState.m_60795_() || currentState.m_60713_(Blocks.f_152480_)) {
                    level.m_46745_(pos).m_6978_(pos, Blocks.f_152480_.m_49966_(), false);
                }
            } else {
                LOGGER.debug("Removing light at {}", (Object)pos);
                BlockState currentState = level.m_8055_(pos);
                if (currentState.m_60713_(Blocks.f_152480_)) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error updating light at " + pos, (Throwable)e);
        }
    }

    private void applyLightUpdates(Level level) {
        if (!pendingUpdates.isEmpty()) {
            LevelLightEngine lightEngine = level.m_5518_();
            for (BlockPos pos : pendingUpdates) {
                lightEngine.m_7174_(pos);
            }
            pendingUpdates.clear();
        }
    }

    private static class LightSource {
        public int lightLevel;
        public long lastUpdate;
        public boolean isActive;

        public LightSource(int lightLevel, long lastUpdate) {
            this.lightLevel = lightLevel;
            this.lastUpdate = lastUpdate;
            this.isActive = true;
        }
    }
}

