/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightaura")
public class DynamicLightingMod {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_LIGHT_LEVEL = 15;

    public DynamicLightingMod(ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightingConfig.CLIENT_CONFIG);
        container.getEventBus().addListener(this::clientSetup);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEventHandler());
        LOGGER.info("Dynamic Lighting (client) initialized for 1.21.9");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientEventHandler {
        private final Map<BlockPos, LightSource> activeLights = new HashMap<BlockPos, LightSource>();
        private final Map<Entity, BlockPos> entityLights = new HashMap<Entity, BlockPos>();
        private final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
        private final Set<BlockPos> playerLightPositions = new HashSet<BlockPos>();
        private final Map<BlockPos, Integer> transitioningLights = new HashMap<BlockPos, Integer>();
        private final Map<BlockPos, BlockState> originalBlockStates = new HashMap<BlockPos, BlockState>();
        private final Set<BlockPos> preservedPlantPositions = new HashSet<BlockPos>();
        private final Set<BlockPos> tallGrassLightPositions = new HashSet<BlockPos>();
        private final Map<Entity, Integer> entityHealthTracker = new HashMap<Entity, Integer>();
        private final Map<Entity, BlockPos> entityPositionTracker = new HashMap<Entity, BlockPos>();
        private BlockPos lastPlayerPos;
        private BlockPos lastPlayerHeadPos;
        private int playerLightLevel = 0;
        private int mainHandLightLevel = 0;
        private int offHandLightLevel = 0;
        private boolean isPlayerDigging = false;
        private long lastDiggingTime = 0L;
        private final Set<BlockPos> offhandLightPositions = new HashSet<BlockPos>();
        private final Set<BlockPos> mainhandLightPositions = new HashSet<BlockPos>();
        private boolean isAscending = false;
        private long lastVerticalMoveTime = 0L;
        private int verticalMoveCooldown = 0;
        private int updateInterval = 1;
        private int cleanupDelay = 3;
        private int scanRadius = 16;
        private int transitionLightDuration = 5;
        private int maxTrackedEntities = 50;
        private int lightUpdateDistance = 32;
        private boolean enableSmoothTransitions = true;
        private boolean enhancedOffhandLighting = true;
        private boolean enhancedMainhandLighting = true;
        private boolean optimizeLightUpdates = true;
        private boolean enablePlayerLightingOffsets = true;
        private double droppedItemLightMultiplier = 1.0;
        private boolean configLoaded = false;
        private static Map<Item, Integer> LIGHT_ITEMS = new HashMap<Item, Integer>();

        private ClientEventHandler() {
        }

        @SubscribeEvent
        public void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
            this.cleanupAllLights();
        }

        private void trackNewItemEntities(Level level, Player player) {
            List allItems = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)(this.scanRadius * 2)), entity -> entity != null && entity.isAlive());
            for (ItemEntity item : allItems) {
                if (this.entityHealthTracker.containsKey(item)) continue;
                this.entityHealthTracker.put((Entity)item, item.getItem().getCount());
                this.entityPositionTracker.put((Entity)item, item.blockPosition());
            }
        }

        private void cleanupAllLights() {
            this.activeLights.clear();
            this.entityLights.clear();
            this.pendingUpdates.clear();
            this.playerLightPositions.clear();
            this.offhandLightPositions.clear();
            this.mainhandLightPositions.clear();
            this.transitioningLights.clear();
            this.originalBlockStates.clear();
            this.preservedPlantPositions.clear();
            this.tallGrassLightPositions.clear();
            this.entityHealthTracker.clear();
            this.entityPositionTracker.clear();
            this.lastPlayerPos = null;
            this.lastPlayerHeadPos = null;
            this.isPlayerDigging = false;
            this.lastDiggingTime = 0L;
            this.isAscending = false;
            this.lastVerticalMoveTime = 0L;
            this.verticalMoveCooldown = 0;
        }

        @SubscribeEvent
        public void onPlayerTick(PlayerTickEvent.Post event) {
            boolean shouldProcess;
            if (!event.getEntity().level().isClientSide()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            ClientLevel level = mc.level;
            if (player == null || level == null || player != event.getEntity()) {
                return;
            }
            this.loadConfigValues();
            boolean bl = shouldProcess = level.getGameTime() % (long)this.updateInterval == 0L;
            if (this.isAscending || this.verticalMoveCooldown > 0) {
                shouldProcess = true;
                if (this.verticalMoveCooldown > 0) {
                    --this.verticalMoveCooldown;
                }
            }
            if (!shouldProcess) {
                return;
            }
            BlockPos currentPos = player.blockPosition();
            this.detectVerticalMovement((Player)player, currentPos);
            this.detectPlayerDigging(mc, (Player)player);
            this.updatePlayerLightLevels((Player)player);
            this.handlePlayerLighting((Level)level, (Player)player, currentPos);
            if (level.getGameTime() % (long)(this.updateInterval * 2) == 0L) {
                this.trackNewItemEntities((Level)level, (Player)player);
                this.handleDroppedItemLighting((Level)level, (Player)player);
            }
            if (this.enableSmoothTransitions) {
                this.processTransitioningLights((Level)level);
            }
            this.cleanupLights((Level)level, currentPos, this.isAscending);
            this.applyLightUpdates((Level)level);
            this.lastPlayerPos = currentPos;
            this.lastPlayerHeadPos = BlockPos.containing((Position)player.getEyePosition());
        }

        private void detectVerticalMovement(Player player, BlockPos currentPos) {
            if (this.lastPlayerPos != null) {
                boolean movingUpward;
                boolean movingVertically = currentPos.getY() != this.lastPlayerPos.getY();
                boolean bl = movingUpward = currentPos.getY() > this.lastPlayerPos.getY();
                if (movingVertically) {
                    this.lastVerticalMoveTime = player.level().getGameTime();
                    if (movingUpward) {
                        this.isAscending = true;
                        this.verticalMoveCooldown = 5;
                    }
                } else {
                    long timeSinceVerticalMove = player.level().getGameTime() - this.lastVerticalMoveTime;
                    if (timeSinceVerticalMove > 3L) {
                        this.isAscending = false;
                    }
                }
            }
        }

        private void loadConfigValues() {
            try {
                if (!this.configLoaded && DynamicLightingConfig.CLIENT_CONFIG != null && DynamicLightingConfig.CLIENT_CONFIG.isLoaded()) {
                    this.updateInterval = (Integer)DynamicLightingConfig.UPDATE_FREQUENCY.get();
                    this.cleanupDelay = (Integer)DynamicLightingConfig.CLEANUP_DELAY.get();
                    this.scanRadius = (Integer)DynamicLightingConfig.DROPPED_ITEM_SCAN_RADIUS.get();
                    this.enableSmoothTransitions = (Boolean)DynamicLightingConfig.ENABLE_SMOOTH_TRANSITIONS.get();
                    this.enhancedOffhandLighting = (Boolean)DynamicLightingConfig.ENHANCED_OFFHAND_LIGHTING.get();
                    this.enhancedMainhandLighting = true;
                    this.optimizeLightUpdates = (Boolean)DynamicLightingConfig.OPTIMIZE_LIGHT_UPDATES.get();
                    this.enablePlayerLightingOffsets = (Boolean)DynamicLightingConfig.ENABLE_PLAYER_LIGHTING_OFFSETS.get();
                    this.maxTrackedEntities = (Integer)DynamicLightingConfig.MAX_TRACKED_ENTITIES.get();
                    this.lightUpdateDistance = (Integer)DynamicLightingConfig.LIGHT_UPDATE_DISTANCE_CHECK.get();
                    this.droppedItemLightMultiplier = (Double)DynamicLightingConfig.DROPPED_ITEM_LIGHT_MULTIPLIER.get();
                    this.transitionLightDuration = (Integer)DynamicLightingConfig.PERSISTENT_LIGHT_DURATION_MULTIPLIER.get() * 5;
                    if (LIGHT_ITEMS.size() <= 20) {
                        Map<Item, Integer> configItems = DynamicLightingConfig.getLightItemsFromConfig();
                        LIGHT_ITEMS.putAll(configItems);
                    }
                    this.configLoaded = true;
                    LOGGER.info("Configuration loaded successfully");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load config values, using defaults: " + e.getMessage());
                this.configLoaded = false;
            }
        }

        private void detectPlayerDigging(Minecraft mc, Player player) {
            boolean digging;
            boolean bl = digging = mc.gameMode != null && mc.gameMode.isDestroying();
            if (digging && !this.isPlayerDigging) {
                this.lastDiggingTime = mc.level.getGameTime();
            }
            this.isPlayerDigging = digging;
        }

        private void updatePlayerLightLevels(Player player) {
            this.playerLightLevel = 0;
            this.mainHandLightLevel = 0;
            this.offHandLightLevel = 0;
            this.mainHandLightLevel = this.getLightLevel(player.getMainHandItem());
            this.playerLightLevel = Math.max(this.playerLightLevel, this.mainHandLightLevel);
            this.offHandLightLevel = this.getLightLevel(player.getOffhandItem());
            this.playerLightLevel = Math.max(this.playerLightLevel, this.offHandLightLevel);
            this.playerLightLevel = this.clampLightLevel(this.playerLightLevel);
            this.mainHandLightLevel = this.clampLightLevel(this.mainHandLightLevel);
            this.offHandLightLevel = this.clampLightLevel(this.offHandLightLevel);
        }

        private int getLightLevel(ItemStack stack) {
            if (stack.isEmpty()) {
                return 0;
            }
            int level = LIGHT_ITEMS.getOrDefault(stack.getItem(), 0);
            return this.clampLightLevel(level);
        }

        private int clampLightLevel(int level) {
            return Math.max(0, Math.min(15, level));
        }

        private boolean isPlayerInTallGrass(Level level, Player player, BlockPos pos) {
            BlockState state = level.getBlockState(pos);
            BlockState aboveState = level.getBlockState(pos.above());
            BlockState belowState = level.getBlockState(pos.below());
            boolean inPlant = this.isPlantBlock(state) || this.isPlantBlock(aboveState);
            boolean onPlant = this.isPlantBlock(belowState) || belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.DIRT_PATH);
            return inPlant || onPlant;
        }

        private boolean isSpecialBlock(Level level, BlockPos pos) {
            BlockState belowState = level.getBlockState(pos.below());
            return !belowState.isAir() && !belowState.is(Blocks.LIGHT) && (belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.DIRT) || belowState.is(Blocks.PODZOL) || belowState.is(Blocks.MYCELIUM) || belowState.is(Blocks.FARMLAND) || belowState.is(Blocks.DIRT_PATH) || belowState.is(Blocks.RAIL) || belowState.is(Blocks.POWERED_RAIL) || belowState.is(Blocks.DETECTOR_RAIL) || belowState.is(Blocks.ACTIVATOR_RAIL) || belowState.is(Blocks.SNOW) || belowState.is(Blocks.SNOW_BLOCK) || this.isPlantBlock(belowState));
        }

        private void addTallGrassLightPositions(Level level, Player player, BlockPos currentPos, Set<BlockPos> targetSet) {
            targetSet.add(currentPos);
            targetSet.add(currentPos.above());
            targetSet.add(currentPos.below());
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offsetPos = currentPos.offset(x, 0, z);
                    targetSet.add(offsetPos);
                    if (!this.isPlantBlock(level.getBlockState(offsetPos)) && !this.isPlantBlock(level.getBlockState(offsetPos.above())) && !this.isPlantBlock(level.getBlockState(offsetPos.below()))) continue;
                    targetSet.add(offsetPos.above());
                    targetSet.add(offsetPos.below());
                }
            }
        }

        private void handlePlayerLighting(Level level, Player player, BlockPos currentPos) {
            BlockPos offsetPos;
            int z;
            BlockPos frontPos;
            HashSet<BlockPos> currentLightPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentMainhandPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentOffhandPositions = new HashSet<BlockPos>();
            HashSet<BlockPos> currentTallGrassPositions = new HashSet<BlockPos>();
            boolean inTallGrass = this.isPlayerInTallGrass(level, player, currentPos);
            boolean onSpecialBlock = this.isSpecialBlock(level, currentPos);
            if (this.playerLightLevel > 0) {
                currentLightPositions.add(currentPos);
                if (this.enablePlayerLightingOffsets) {
                    BlockPos headPos = BlockPos.containing((Position)player.getEyePosition());
                    currentLightPositions.add(headPos);
                    if (this.isAscending) {
                        currentLightPositions.add(headPos.above());
                    }
                }
                if (this.lastPlayerPos != null && this.lastPlayerPos.getY() != currentPos.getY()) {
                    currentLightPositions.add(this.lastPlayerPos);
                    if (currentPos.getY() > this.lastPlayerPos.getY()) {
                        currentLightPositions.add(currentPos.above());
                    }
                    if (currentPos.getY() < this.lastPlayerPos.getY()) {
                        currentLightPositions.add(currentPos.below());
                    }
                }
                if (onSpecialBlock) {
                    currentLightPositions.add(currentPos.above());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                }
            }
            if (this.mainHandLightLevel > 0 && this.enhancedMainhandLighting) {
                currentMainhandPositions.add(currentPos);
                if (this.isPlayerDigging || level.getGameTime() - this.lastDiggingTime < (long)(this.cleanupDelay * 3)) {
                    currentMainhandPositions.add(currentPos.below());
                    Vec3 lookVec = player.getLookAngle();
                    frontPos = currentPos.offset((int)Math.round(lookVec.x), (int)Math.round(lookVec.y), (int)Math.round(lookVec.z));
                    currentMainhandPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    currentMainhandPositions.add(currentPos.above());
                    currentMainhandPositions.add(currentPos.above().above());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                    currentMainhandPositions.add(currentPos);
                    currentMainhandPositions.add(currentPos.above());
                    currentMainhandPositions.add(currentPos.below());
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (z = -1; z <= 1; ++z) {
                                if (x == 0 && y == 0 && z == 0 || !this.isPlantBlock(level.getBlockState(offsetPos = currentPos.offset(x, y, z)))) continue;
                                currentMainhandPositions.add(offsetPos);
                            }
                        }
                    }
                }
            }
            if (this.offHandLightLevel > 0 && this.enhancedOffhandLighting) {
                currentOffhandPositions.add(currentPos);
                if (this.isPlayerDigging || level.getGameTime() - this.lastDiggingTime < (long)(this.cleanupDelay * 3)) {
                    currentOffhandPositions.add(currentPos.below());
                    Vec3 lookVec = player.getLookAngle();
                    frontPos = currentPos.offset((int)Math.round(lookVec.x), (int)Math.round(lookVec.y), (int)Math.round(lookVec.z));
                    currentOffhandPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    currentOffhandPositions.add(currentPos.above());
                }
                if (inTallGrass) {
                    this.addTallGrassLightPositions(level, player, currentPos, currentTallGrassPositions);
                    currentOffhandPositions.add(currentPos);
                    currentOffhandPositions.add(currentPos.above());
                    currentOffhandPositions.add(currentPos.below());
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            for (z = -1; z <= 1; ++z) {
                                if (x == 0 && y == 0 && z == 0 || !this.isPlantBlock(level.getBlockState(offsetPos = currentPos.offset(x, y, z)))) continue;
                                currentOffhandPositions.add(offsetPos);
                            }
                        }
                    }
                }
            }
            for (BlockPos pos : currentLightPositions) {
                this.placeLight(level, pos, this.playerLightLevel, true);
            }
            for (BlockPos pos : currentMainhandPositions) {
                this.placeLight(level, pos, this.mainHandLightLevel, true, null, false, true);
            }
            for (BlockPos pos : currentOffhandPositions) {
                this.placeLight(level, pos, this.offHandLightLevel, true, null, true, false);
            }
            for (BlockPos pos : currentTallGrassPositions) {
                this.placeLightForTallGrass(level, pos, this.playerLightLevel);
            }
            boolean forceCleanup = this.isAscending;
            this.removeOldLightPositions(level, this.playerLightPositions, currentLightPositions, forceCleanup);
            this.playerLightPositions.clear();
            this.playerLightPositions.addAll(currentLightPositions);
            this.removeOldLightPositions(level, this.mainhandLightPositions, currentMainhandPositions, forceCleanup);
            this.mainhandLightPositions.clear();
            this.mainhandLightPositions.addAll(currentMainhandPositions);
            this.removeOldLightPositions(level, this.offhandLightPositions, currentOffhandPositions, forceCleanup);
            this.offhandLightPositions.clear();
            this.offhandLightPositions.addAll(currentOffhandPositions);
            this.removeOldLightPositions(level, this.tallGrassLightPositions, currentTallGrassPositions, forceCleanup);
            this.tallGrassLightPositions.clear();
            this.tallGrassLightPositions.addAll(currentTallGrassPositions);
        }

        private void removeOldLightPositions(Level level, Set<BlockPos> oldPositions, Set<BlockPos> currentPositions, boolean forceCleanup) {
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (BlockPos oldPos : oldPositions) {
                if (currentPositions.contains(oldPos)) continue;
                this.removeLight(level, oldPos, forceCleanup);
                toRemove.add(oldPos);
            }
            oldPositions.removeAll(toRemove);
        }

        private void placeLightForTallGrass(Level level, BlockPos pos, int lightLevel) {
            this.placeLight(level, pos, lightLevel, true, null, false, false);
        }

        private void handleDroppedItemLighting(Level level, Player player) {
            BlockPos playerPos = player.blockPosition();
            List items = level.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)this.scanRadius), entity -> entity != null && entity.isAlive());
            if (items.size() > this.maxTrackedEntities) {
                items = items.subList(0, this.maxTrackedEntities);
            }
            HashSet<Entity> itemsToRemove = new HashSet<Entity>();
            for (Entity entity2 : new HashSet<Entity>(this.entityLights.keySet())) {
                BlockPos lightPos;
                if (!entity2.isAlive()) {
                    BlockPos lightPos2 = this.entityLights.get(entity2);
                    this.removeLight(level, lightPos2, true);
                    itemsToRemove.add(entity2);
                    continue;
                }
                if (!(entity2 instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity2;
                Integer lastCount = this.entityHealthTracker.get(entity2);
                int currentCount = itemEntity.getItem().getCount();
                if (lastCount == null) {
                    this.entityHealthTracker.put(entity2, currentCount);
                    lastCount = currentCount;
                }
                if (currentCount < lastCount || currentCount == 0 || itemEntity.getItem().isEmpty()) {
                    BlockPos lightPos3 = this.entityLights.get(entity2);
                    this.removeLight(level, lightPos3, true);
                    itemsToRemove.add(entity2);
                } else {
                    this.entityHealthTracker.put(entity2, currentCount);
                }
                double distSq = entity2.distanceToSqr((Entity)player);
                if (distSq < 1.5) {
                    lightPos = this.entityLights.get(entity2);
                    this.removeLight(level, lightPos, true);
                    itemsToRemove.add(entity2);
                }
                if (itemEntity.getAge() > 5800) {
                    lightPos = this.entityLights.get(entity2);
                    this.removeLight(level, lightPos, true);
                    itemsToRemove.add(entity2);
                }
                BlockPos currentPos = entity2.blockPosition();
                this.entityPositionTracker.put(entity2, currentPos);
            }
            for (Entity entity2 : itemsToRemove) {
                this.entityLights.remove(entity2);
                this.entityHealthTracker.remove(entity2);
                this.entityPositionTracker.remove(entity2);
            }
            for (ItemEntity item : items) {
                int light;
                if (this.entityLights.containsKey(item) || (light = this.getLightLevel(item.getItem())) <= 0) continue;
                light = this.clampLightLevel((int)Math.max(1.0, (double)light * this.droppedItemLightMultiplier));
                BlockPos pos = item.blockPosition();
                this.placeLight(level, pos, light, false, (Entity)item);
                this.entityLights.put((Entity)item, pos);
                this.entityHealthTracker.put((Entity)item, item.getItem().getCount());
                this.entityPositionTracker.put((Entity)item, pos);
            }
            HashMap<Entity, BlockPos> entityLightsCopy = new HashMap<Entity, BlockPos>(this.entityLights);
            for (Map.Entry entry : entityLightsCopy.entrySet()) {
                ItemEntity itemEntity;
                int light;
                BlockPos newPos;
                Entity entity3 = (Entity)entry.getKey();
                BlockPos pos = (BlockPos)entry.getValue();
                if (!entity3.isAlive() || itemsToRemove.contains(entity3) || (newPos = entity3.blockPosition()).equals((Object)pos)) continue;
                this.removeLight(level, pos, true);
                if (!(entity3 instanceof ItemEntity) || (light = this.getLightLevel((itemEntity = (ItemEntity)entity3).getItem())) <= 0) continue;
                int finalLight = this.clampLightLevel((int)Math.max(1.0, (double)light * this.droppedItemLightMultiplier));
                this.placeLight(level, newPos, finalLight, false, entity3);
                this.entityLights.put(entity3, newPos);
                this.entityPositionTracker.put(entity3, newPos);
            }
        }

        private void processTransitioningLights(Level level) {
            long now = level.getGameTime();
            Iterator<Map.Entry<BlockPos, Integer>> it = this.transitioningLights.entrySet().iterator();
            while (it.hasNext()) {
                int transitionDuration;
                Map.Entry<BlockPos, Integer> entry = it.next();
                BlockPos pos = entry.getKey();
                int targetLevel = this.clampLightLevel(entry.getValue());
                LightSource source = this.activeLights.get(pos);
                if (source == null) {
                    it.remove();
                    continue;
                }
                long elapsed = now - source.lastUpdate;
                int n = transitionDuration = this.isAscending ? Math.max(1, this.transitionLightDuration / 2) : this.transitionLightDuration;
                if (elapsed >= (long)transitionDuration) {
                    if (targetLevel > 0) {
                        this.setLightBlock(level, pos, targetLevel);
                    } else {
                        this.removeLight(level, pos);
                    }
                    it.remove();
                    continue;
                }
                if (elapsed % 2L != 0L) continue;
                float progress = (float)elapsed / (float)transitionDuration;
                int currentLevel = source.lightLevel;
                int newLevel = targetLevel > currentLevel ? currentLevel + (int)(progress * (float)(targetLevel - currentLevel)) : currentLevel - (int)(progress * (float)(currentLevel - targetLevel));
                newLevel = this.clampLightLevel(newLevel);
                if (newLevel == currentLevel || newLevel <= 0) continue;
                this.setLightBlock(level, pos, newLevel);
                this.pendingUpdates.add(pos);
            }
        }

        private void cleanupLights(Level level, BlockPos playerPos, boolean forceCleanup) {
            long now = level.getGameTime();
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            HashMap<BlockPos, LightSource> activeLightsCopy = new HashMap<BlockPos, LightSource>(this.activeLights);
            for (Map.Entry entry : activeLightsCopy.entrySet()) {
                boolean shouldRemove;
                BlockPos pos = (BlockPos)entry.getKey();
                LightSource src = (LightSource)entry.getValue();
                if (this.playerLightPositions.contains(pos) || this.offhandLightPositions.contains(pos) || this.mainhandLightPositions.contains(pos) || this.tallGrassLightPositions.contains(pos) || src.trackedEntity != null && src.trackedEntity.isAlive() && this.entityLights.containsKey(src.trackedEntity) || !forceCleanup && this.transitioningLights.containsKey(pos)) continue;
                if (this.optimizeLightUpdates && playerPos.distSqr((Vec3i)pos) > (double)(this.lightUpdateDistance * this.lightUpdateDistance)) {
                    toRemove.add(pos);
                    continue;
                }
                boolean bl = !src.isActive || now - src.lastUpdate > (long)(src.isPlayerLight ? this.cleanupDelay : this.transitionLightDuration) ? true : (shouldRemove = false);
                if (forceCleanup && pos.getY() >= playerPos.getY()) {
                    shouldRemove = true;
                }
                if (src.trackedEntity != null && !this.entityLights.containsKey(src.trackedEntity)) {
                    shouldRemove = true;
                    forceCleanup = true;
                }
                if (!shouldRemove) continue;
                if (this.enableSmoothTransitions && !forceCleanup && src.lightLevel > 0) {
                    this.transitioningLights.put(pos, 0);
                    src.isActive = false;
                    this.activeLights.put(pos, src);
                    continue;
                }
                toRemove.add(pos);
            }
            for (BlockPos pos : toRemove) {
                this.removeLight(level, pos, forceCleanup);
            }
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, null);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, entity, false, false);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight) {
            this.placeLight(level, pos, lightLevel, isPlayerLight, entity, isOffhandLight, false);
        }

        private void placeLight(Level level, BlockPos pos, int lightLevel, boolean isPlayerLight, Entity entity, boolean isOffhandLight, boolean isMainhandLight) {
            boolean canPlaceLight;
            if ((lightLevel = this.clampLightLevel(lightLevel)) <= 0 || pos == null) {
                return;
            }
            if (entity != null && this.entityHealthTracker.containsKey(entity) && entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                Integer lastCount = this.entityHealthTracker.get(entity);
                int currentCount = itemEntity.getItem().getCount();
                if (lastCount != null && (currentCount < lastCount || currentCount == 0 || itemEntity.getItem().isEmpty())) {
                    return;
                }
                if (level.isClientSide()) {
                    Minecraft mc = Minecraft.getInstance();
                    if (mc.player != null && entity.distanceToSqr((Entity)mc.player) < 1.5) {
                        return;
                    }
                }
            }
            BlockState state = level.getBlockState(pos);
            boolean isPlantBlock = this.isPlantBlock(state);
            boolean bl = canPlaceLight = state.isAir() || state.is(Blocks.LIGHT);
            if (isPlantBlock) {
                this.preservedPlantPositions.add(pos);
                canPlaceLight = true;
            }
            if (!canPlaceLight) {
                return;
            }
            LightSource existing = this.activeLights.get(pos);
            if ((isOffhandLight || isMainhandLight) && existing != null && !existing.isOffhandLight && !existing.isMainhandLight) {
                existing = null;
            }
            if (existing == null || existing.lightLevel <= lightLevel) {
                boolean shouldUpdateBlock = existing == null || existing.lightLevel < lightLevel;
                this.activeLights.put(pos, new LightSource(lightLevel, level.getGameTime(), isPlayerLight, entity, isOffhandLight, isMainhandLight));
                if (shouldUpdateBlock) {
                    if (this.enableSmoothTransitions && existing != null && !this.isAscending) {
                        this.transitioningLights.put(pos, lightLevel);
                    } else {
                        if (!this.originalBlockStates.containsKey(pos)) {
                            this.originalBlockStates.put(pos, state);
                        }
                        if (!this.preservedPlantPositions.contains(pos)) {
                            this.setLightBlock(level, pos, lightLevel);
                        } else {
                            this.updateLightLevelWithoutReplacing(level, pos, lightLevel);
                        }
                    }
                }
                this.pendingUpdates.add(pos);
            }
        }

        private boolean isPlantBlock(BlockState state) {
            return state.is(Blocks.TALL_GRASS) || state.is(Blocks.FERN) || state.is(Blocks.LARGE_FERN) || state.is(Blocks.SEAGRASS) || state.is(Blocks.TALL_SEAGRASS) || state.is(Blocks.DANDELION) || state.is(Blocks.POPPY) || state.is(Blocks.BLUE_ORCHID) || state.is(Blocks.ALLIUM) || state.is(Blocks.AZURE_BLUET) || state.is(Blocks.RED_TULIP) || state.is(Blocks.ORANGE_TULIP) || state.is(Blocks.WHITE_TULIP) || state.is(Blocks.PINK_TULIP) || state.is(Blocks.OXEYE_DAISY) || state.is(Blocks.CORNFLOWER) || state.is(Blocks.LILY_OF_THE_VALLEY) || state.is(Blocks.WHEAT) || state.is(Blocks.CARROTS) || state.is(Blocks.POTATOES) || state.is(Blocks.BEETROOTS) || state.is(Blocks.SUGAR_CANE) || state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT) || state.is(Blocks.BAMBOO) || state.is(Blocks.BAMBOO_SAPLING) || state.is(Blocks.SWEET_BERRY_BUSH) || state.is(Blocks.CAVE_VINES) || state.is(Blocks.CAVE_VINES_PLANT) || state.is(Blocks.GLOW_LICHEN) || state.is(Blocks.MOSS_CARPET) || state.is(Blocks.RAIL) || state.is(Blocks.POWERED_RAIL) || state.is(Blocks.DETECTOR_RAIL) || state.is(Blocks.ACTIVATOR_RAIL) || state.is(Blocks.SNOW) || state.is(Blocks.SNOW_BLOCK);
        }

        private void updateLightLevelWithoutReplacing(Level level, BlockPos pos, int lightLevel) {
            lightLevel = this.clampLightLevel(lightLevel);
            if (level.isClientSide()) {
                level.getLightEngine().checkBlock(pos);
                this.pendingUpdates.add(pos);
            }
        }

        private void removeLight(Level level, BlockPos pos) {
            this.removeLight(level, pos, false);
        }

        private void removeLight(Level level, BlockPos pos, boolean forceImmediate) {
            LightSource source = this.activeLights.remove(pos);
            if (source != null) {
                if (this.enableSmoothTransitions && !forceImmediate && source.lightLevel > 0) {
                    this.transitioningLights.put(pos, 0);
                    source.isActive = false;
                    this.activeLights.put(pos, source);
                } else if (!this.preservedPlantPositions.contains(pos)) {
                    this.setLightBlock(level, pos, 0);
                } else {
                    this.preservedPlantPositions.remove(pos);
                    if (this.originalBlockStates.containsKey(pos)) {
                        level.setBlock(pos, this.originalBlockStates.get(pos), 3);
                        this.originalBlockStates.remove(pos);
                    }
                }
                this.pendingUpdates.add(pos);
            }
        }

        private void setLightBlock(Level level, BlockPos pos, int lightLevel) {
            lightLevel = this.clampLightLevel(lightLevel);
            if (level.isClientSide()) {
                if (this.preservedPlantPositions.contains(pos)) {
                    return;
                }
                BlockState current = level.getBlockState(pos);
                if (lightLevel > 0) {
                    if (!this.originalBlockStates.containsKey(pos)) {
                        this.originalBlockStates.put(pos, current);
                    }
                    level.setBlock(pos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(lightLevel)), 3);
                } else if (lightLevel == 0 && current.is(Blocks.LIGHT)) {
                    if (this.originalBlockStates.containsKey(pos)) {
                        level.setBlock(pos, this.originalBlockStates.get(pos), 3);
                        this.originalBlockStates.remove(pos);
                    } else {
                        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                    }
                }
            }
        }

        private void applyLightUpdates(Level level) {
            if (!this.pendingUpdates.isEmpty() && level.isClientSide()) {
                if (this.isAscending && this.lastPlayerPos != null) {
                    for (BlockPos pos : this.pendingUpdates) {
                        if (pos.getY() < this.lastPlayerPos.getY()) continue;
                        level.getLightEngine().checkBlock(pos);
                    }
                    for (BlockPos pos : this.pendingUpdates) {
                        if (pos.getY() >= this.lastPlayerPos.getY()) continue;
                        level.getLightEngine().checkBlock(pos);
                    }
                } else {
                    for (BlockPos pos : this.pendingUpdates) {
                        level.getLightEngine().checkBlock(pos);
                    }
                }
                this.pendingUpdates.clear();
            }
        }

        static {
            LIGHT_ITEMS.put(Items.TORCH, 14);
            LIGHT_ITEMS.put(Items.SOUL_TORCH, 10);
            LIGHT_ITEMS.put(Items.LANTERN, 15);
            LIGHT_ITEMS.put(Items.SOUL_LANTERN, 10);
            LIGHT_ITEMS.put(Items.GLOWSTONE, 15);
            LIGHT_ITEMS.put(Items.SEA_LANTERN, 15);
            LIGHT_ITEMS.put(Items.JACK_O_LANTERN, 15);
            LIGHT_ITEMS.put(Items.LAVA_BUCKET, 15);
            LIGHT_ITEMS.put(Items.GLOW_BERRIES, 8);
            LIGHT_ITEMS.put(Items.GLOW_INK_SAC, 10);
            LIGHT_ITEMS.put(Items.BLAZE_ROD, 10);
            LIGHT_ITEMS.put(Items.MAGMA_BLOCK, 13);
            LIGHT_ITEMS.put(Items.SHROOMLIGHT, 15);
            LIGHT_ITEMS.put(Items.END_ROD, 14);
            LIGHT_ITEMS.put(Items.REDSTONE_TORCH, 7);
            LIGHT_ITEMS.put(Items.OCHRE_FROGLIGHT, 15);
            LIGHT_ITEMS.put(Items.VERDANT_FROGLIGHT, 15);
            LIGHT_ITEMS.put(Items.PEARLESCENT_FROGLIGHT, 15);
            LIGHT_ITEMS.put(Items.COPPER_TORCH, 14);
            LIGHT_ITEMS.put(Items.VERDANT_FROGLIGHT, 15);
            LIGHT_ITEMS.put(Items.PEARLESCENT_FROGLIGHT, 15);
            LIGHT_ITEMS.put(Items.COPPER_LANTERN.unaffected(), 15);
            LIGHT_ITEMS.put(Items.COPPER_LANTERN.exposed(), 13);
            LIGHT_ITEMS.put(Items.COPPER_LANTERN.weathered(), 11);
            LIGHT_ITEMS.put(Items.COPPER_LANTERN.oxidized(), 9);
            BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"waxed_copper_lantern")).ifPresent(ref -> LIGHT_ITEMS.put((Item)ref.value(), 15));
            BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"waxed_exposed_copper_lantern")).ifPresent(ref -> LIGHT_ITEMS.put((Item)ref.value(), 13));
            BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"waxed_weathered_copper_lantern")).ifPresent(ref -> LIGHT_ITEMS.put((Item)ref.value(), 11));
            BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"waxed_oxidized_copper_lantern")).ifPresent(ref -> LIGHT_ITEMS.put((Item)ref.value(), 9));
        }

        private static class LightSource {
            final int lightLevel;
            final long lastUpdate;
            final boolean isPlayerLight;
            final Entity trackedEntity;
            final boolean isOffhandLight;
            final boolean isMainhandLight;
            boolean isActive = true;

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity) {
                this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, false, false);
            }

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight) {
                this(lightLevel, lastUpdate, isPlayerLight, trackedEntity, isOffhandLight, false);
            }

            LightSource(int lightLevel, long lastUpdate, boolean isPlayerLight, Entity trackedEntity, boolean isOffhandLight, boolean isMainhandLight) {
                this.lightLevel = Math.max(0, Math.min(15, lightLevel));
                this.lastUpdate = lastUpdate;
                this.isPlayerLight = isPlayerLight;
                this.trackedEntity = trackedEntity;
                this.isOffhandLight = isOffhandLight;
                this.isMainhandLight = isMainhandLight;
            }
        }
    }
}

