/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightAuraConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"lightaura");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("lightaura.properties");
    private static final String CONFIG_VERSION = "2.0";
    private static Map<String, Integer> lightItemsMap = new HashMap<String, Integer>();
    private static Map<class_1792, Integer> compiledLightItems = new HashMap<class_1792, Integer>();

    public static void init() {
        LightAuraConfig.loadConfig();
        LightAuraConfig.compileLightItems();
        LightAuraConfig.validateConfig();
        LOGGER.info("LightAura configuration loaded successfully!");
        if (Debug.ENABLE_DEBUG_LOGGING) {
            LightAuraConfig.logConfigSummary();
        }
    }

    private static void loadConfig() {
        Properties props = new Properties();
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (InputStream input = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                props.load(input);
                LightAuraConfig.loadFromProperties(props);
                String version = props.getProperty("configVersion", "1.0");
                if (!CONFIG_VERSION.equals(version)) {
                    LOGGER.info("Config version mismatch. Updating config from {} to {}", (Object)version, (Object)CONFIG_VERSION);
                    LightAuraConfig.saveConfig();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load config, using defaults: {}", (Object)e.getMessage());
                LightAuraConfig.setDefaults();
                LightAuraConfig.saveConfig();
            }
        } else {
            LOGGER.info("Config file not found, creating with defaults");
            LightAuraConfig.setDefaults();
            LightAuraConfig.saveConfig();
        }
    }

    private static void loadFromProperties(Properties props) {
        Performance.UPDATE_FREQUENCY = LightAuraConfig.getIntProperty(props, "performance.updateFrequency", Performance.UPDATE_FREQUENCY);
        Performance.CLEANUP_DELAY = LightAuraConfig.getIntProperty(props, "performance.cleanupDelay", Performance.CLEANUP_DELAY);
        Performance.MAX_LIGHT_SOURCES = LightAuraConfig.getIntProperty(props, "performance.maxLightSources", Performance.MAX_LIGHT_SOURCES);
        Performance.ENABLE_PERFORMANCE_MODE = LightAuraConfig.getBooleanProperty(props, "performance.enablePerformanceMode", Performance.ENABLE_PERFORMANCE_MODE);
        Performance.PERFORMANCE_MODE_RADIUS = LightAuraConfig.getIntProperty(props, "performance.performanceModeRadius", Performance.PERFORMANCE_MODE_RADIUS);
        PlayerLighting.ENABLE_PLAYER_LIGHTING = LightAuraConfig.getBooleanProperty(props, "player.enablePlayerLighting", PlayerLighting.ENABLE_PLAYER_LIGHTING);
        PlayerLighting.ENABLE_OFFSETS = LightAuraConfig.getBooleanProperty(props, "player.enableOffsets", PlayerLighting.ENABLE_OFFSETS);
        PlayerLighting.ENABLE_SURROUNDING_POSITIONS = LightAuraConfig.getBooleanProperty(props, "player.enableSurroundingPositions", PlayerLighting.ENABLE_SURROUNDING_POSITIONS);
        PlayerLighting.ENABLE_ANIMATION_LIGHTING = LightAuraConfig.getBooleanProperty(props, "player.enableAnimationLighting", PlayerLighting.ENABLE_ANIMATION_LIGHTING);
        PlayerLighting.ENABLE_HAND_POSITION_LIGHTING = LightAuraConfig.getBooleanProperty(props, "player.enableHandPositionLighting", PlayerLighting.ENABLE_HAND_POSITION_LIGHTING);
        PlayerLighting.ENABLE_EYE_POSITION_LIGHTING = LightAuraConfig.getBooleanProperty(props, "player.enableEyePositionLighting", PlayerLighting.ENABLE_EYE_POSITION_LIGHTING);
        PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER = LightAuraConfig.getDoubleProperty(props, "player.animationBrightnessMultiplier", PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER);
        DroppedItemLighting.ENABLE_DROPPED_ITEM_LIGHTING = LightAuraConfig.getBooleanProperty(props, "droppedItems.enableDroppedItemLighting", DroppedItemLighting.ENABLE_DROPPED_ITEM_LIGHTING);
        DroppedItemLighting.SCAN_RADIUS = LightAuraConfig.getIntProperty(props, "droppedItems.scanRadius", DroppedItemLighting.SCAN_RADIUS);
        DroppedItemLighting.LIGHT_MULTIPLIER = LightAuraConfig.getDoubleProperty(props, "droppedItems.lightMultiplier", DroppedItemLighting.LIGHT_MULTIPLIER);
        DroppedItemLighting.ENABLE_STACKING = LightAuraConfig.getBooleanProperty(props, "droppedItems.enableStacking", DroppedItemLighting.ENABLE_STACKING);
        DroppedItemLighting.MAX_LIGHTS = LightAuraConfig.getIntProperty(props, "droppedItems.maxLights", DroppedItemLighting.MAX_LIGHTS);
        DroppedItemLighting.ENABLE_DISTANCE_SCALING = LightAuraConfig.getBooleanProperty(props, "droppedItems.enableDistanceScaling", DroppedItemLighting.ENABLE_DISTANCE_SCALING);
        DroppedItemLighting.MIN_DISTANCE_MULTIPLIER = LightAuraConfig.getDoubleProperty(props, "droppedItems.minDistanceMultiplier", DroppedItemLighting.MIN_DISTANCE_MULTIPLIER);
        DroppedItemLighting.ENABLE_ITEM_BOBBING_SYNC = LightAuraConfig.getBooleanProperty(props, "droppedItems.enableItemBobbingSync", DroppedItemLighting.ENABLE_ITEM_BOBBING_SYNC);
        WorldInteraction.PRESERVE_BLOCKS = LightAuraConfig.getBooleanProperty(props, "world.preserveBlocks", WorldInteraction.PRESERVE_BLOCKS);
        WorldInteraction.ENABLE_ENHANCED_PLANT_LIGHTING = LightAuraConfig.getBooleanProperty(props, "world.enableEnhancedPlantLighting", WorldInteraction.ENABLE_ENHANCED_PLANT_LIGHTING);
        WorldInteraction.ENABLE_WATER_LIGHTING = LightAuraConfig.getBooleanProperty(props, "world.enableWaterLighting", WorldInteraction.ENABLE_WATER_LIGHTING);
        WorldInteraction.ENABLE_LAVA_LIGHTING = LightAuraConfig.getBooleanProperty(props, "world.enableLavaLighting", WorldInteraction.ENABLE_LAVA_LIGHTING);
        WorldInteraction.RESPECT_LIGHT_BLOCKING_BLOCKS = LightAuraConfig.getBooleanProperty(props, "world.respectLightBlockingBlocks", WorldInteraction.RESPECT_LIGHT_BLOCKING_BLOCKS);
        String blacklistedBlocks = props.getProperty("world.blacklistedBlocks", String.join((CharSequence)",", WorldInteraction.BLACKLISTED_BLOCKS));
        WorldInteraction.BLACKLISTED_BLOCKS = Arrays.stream(blacklistedBlocks.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Visual.ENABLE_SMOOTH_TRANSITIONS = LightAuraConfig.getBooleanProperty(props, "visual.enableSmoothTransitions", Visual.ENABLE_SMOOTH_TRANSITIONS);
        Visual.TRANSITION_SPEED = LightAuraConfig.getDoubleProperty(props, "visual.transitionSpeed", Visual.TRANSITION_SPEED);
        Visual.ENABLE_FLICKER_EFFECT = LightAuraConfig.getBooleanProperty(props, "visual.enableFlickerEffect", Visual.ENABLE_FLICKER_EFFECT);
        Visual.FLICKER_INTENSITY = LightAuraConfig.getDoubleProperty(props, "visual.flickerIntensity", Visual.FLICKER_INTENSITY);
        Visual.ENABLE_COLORED_LIGHTING = LightAuraConfig.getBooleanProperty(props, "visual.enableColoredLighting", Visual.ENABLE_COLORED_LIGHTING);
        Debug.ENABLE_DEBUG_LOGGING = LightAuraConfig.getBooleanProperty(props, "debug.enableDebugLogging", Debug.ENABLE_DEBUG_LOGGING);
        Debug.SHOW_LIGHT_POSITIONS = LightAuraConfig.getBooleanProperty(props, "debug.showLightPositions", Debug.SHOW_LIGHT_POSITIONS);
        Debug.ENABLE_PERFORMANCE_METRICS = LightAuraConfig.getBooleanProperty(props, "debug.enablePerformanceMetrics", Debug.ENABLE_PERFORMANCE_METRICS);
        Debug.LOG_FREQUENCY = LightAuraConfig.getIntProperty(props, "debug.logFrequency", Debug.LOG_FREQUENCY);
        LightAuraConfig.loadLightItems(props);
    }

    private static void loadLightItems(Properties props) {
        lightItemsMap.clear();
        LightAuraConfig.getDefaultLightItems().forEach((item, level) -> lightItemsMap.put((String)item, (Integer)level));
        props.entrySet().stream().filter(entry -> entry.getKey().toString().startsWith("lightItems.")).forEach(entry -> {
            String itemId = entry.getKey().toString().substring("lightItems.".length());
            try {
                int level = Integer.parseInt(entry.getValue().toString());
                lightItemsMap.put(itemId, level);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid light level for item {}: {}", (Object)itemId, entry.getValue());
            }
        });
    }

    private static void compileLightItems() {
        compiledLightItems.clear();
        lightItemsMap.forEach((itemId, level) -> {
            try {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId));
                if (item != class_1802.field_8162) {
                    compiledLightItems.put(item, (Integer)level);
                } else {
                    LOGGER.warn("Unknown item: {}", itemId);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error processing light item {}: {}", itemId, (Object)e.getMessage());
            }
        });
        LOGGER.info("Compiled {} light-emitting items", (Object)compiledLightItems.size());
    }

    private static void validateConfig() {
        Performance.UPDATE_FREQUENCY = Math.max(1, Math.min(20, Performance.UPDATE_FREQUENCY));
        Performance.CLEANUP_DELAY = Math.max(1, Performance.CLEANUP_DELAY);
        Performance.MAX_LIGHT_SOURCES = Math.max(10, Math.min(1000, Performance.MAX_LIGHT_SOURCES));
        Performance.PERFORMANCE_MODE_RADIUS = Math.max(8, Math.min(64, Performance.PERFORMANCE_MODE_RADIUS));
        DroppedItemLighting.SCAN_RADIUS = Math.max(4, Math.min(128, DroppedItemLighting.SCAN_RADIUS));
        DroppedItemLighting.LIGHT_MULTIPLIER = Math.max(0.1, Math.min(5.0, DroppedItemLighting.LIGHT_MULTIPLIER));
        DroppedItemLighting.MAX_LIGHTS = Math.max(1, Math.min(500, DroppedItemLighting.MAX_LIGHTS));
        DroppedItemLighting.MIN_DISTANCE_MULTIPLIER = Math.max(0.1, Math.min(1.0, DroppedItemLighting.MIN_DISTANCE_MULTIPLIER));
        PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER = Math.max(0.1, Math.min(3.0, PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER));
        Visual.TRANSITION_SPEED = Math.max(0.01, Math.min(1.0, Visual.TRANSITION_SPEED));
        Visual.FLICKER_INTENSITY = Math.max(0.0, Math.min(1.0, Visual.FLICKER_INTENSITY));
        Debug.LOG_FREQUENCY = Math.max(1, Math.min(100, Debug.LOG_FREQUENCY));
        lightItemsMap.replaceAll((item, level) -> Math.max(0, Math.min(15, level)));
    }

    public static void saveConfig() {
        Properties props = new Properties();
        props.setProperty("configVersion", CONFIG_VERSION);
        props.setProperty("performance.updateFrequency", String.valueOf(Performance.UPDATE_FREQUENCY));
        props.setProperty("performance.cleanupDelay", String.valueOf(Performance.CLEANUP_DELAY));
        props.setProperty("performance.maxLightSources", String.valueOf(Performance.MAX_LIGHT_SOURCES));
        props.setProperty("performance.enablePerformanceMode", String.valueOf(Performance.ENABLE_PERFORMANCE_MODE));
        props.setProperty("performance.performanceModeRadius", String.valueOf(Performance.PERFORMANCE_MODE_RADIUS));
        props.setProperty("player.enablePlayerLighting", String.valueOf(PlayerLighting.ENABLE_PLAYER_LIGHTING));
        props.setProperty("player.enableOffsets", String.valueOf(PlayerLighting.ENABLE_OFFSETS));
        props.setProperty("player.enableSurroundingPositions", String.valueOf(PlayerLighting.ENABLE_SURROUNDING_POSITIONS));
        props.setProperty("player.enableAnimationLighting", String.valueOf(PlayerLighting.ENABLE_ANIMATION_LIGHTING));
        props.setProperty("player.enableHandPositionLighting", String.valueOf(PlayerLighting.ENABLE_HAND_POSITION_LIGHTING));
        props.setProperty("player.enableEyePositionLighting", String.valueOf(PlayerLighting.ENABLE_EYE_POSITION_LIGHTING));
        props.setProperty("player.animationBrightnessMultiplier", String.valueOf(PlayerLighting.ANIMATION_BRIGHTNESS_MULTIPLIER));
        props.setProperty("droppedItems.enableDroppedItemLighting", String.valueOf(DroppedItemLighting.ENABLE_DROPPED_ITEM_LIGHTING));
        props.setProperty("droppedItems.scanRadius", String.valueOf(DroppedItemLighting.SCAN_RADIUS));
        props.setProperty("droppedItems.lightMultiplier", String.valueOf(DroppedItemLighting.LIGHT_MULTIPLIER));
        props.setProperty("droppedItems.enableStacking", String.valueOf(DroppedItemLighting.ENABLE_STACKING));
        props.setProperty("droppedItems.maxLights", String.valueOf(DroppedItemLighting.MAX_LIGHTS));
        props.setProperty("droppedItems.enableDistanceScaling", String.valueOf(DroppedItemLighting.ENABLE_DISTANCE_SCALING));
        props.setProperty("droppedItems.minDistanceMultiplier", String.valueOf(DroppedItemLighting.MIN_DISTANCE_MULTIPLIER));
        props.setProperty("droppedItems.enableItemBobbingSync", String.valueOf(DroppedItemLighting.ENABLE_ITEM_BOBBING_SYNC));
        props.setProperty("world.preserveBlocks", String.valueOf(WorldInteraction.PRESERVE_BLOCKS));
        props.setProperty("world.enableEnhancedPlantLighting", String.valueOf(WorldInteraction.ENABLE_ENHANCED_PLANT_LIGHTING));
        props.setProperty("world.enableWaterLighting", String.valueOf(WorldInteraction.ENABLE_WATER_LIGHTING));
        props.setProperty("world.enableLavaLighting", String.valueOf(WorldInteraction.ENABLE_LAVA_LIGHTING));
        props.setProperty("world.respectLightBlockingBlocks", String.valueOf(WorldInteraction.RESPECT_LIGHT_BLOCKING_BLOCKS));
        props.setProperty("world.blacklistedBlocks", String.join((CharSequence)",", WorldInteraction.BLACKLISTED_BLOCKS));
        props.setProperty("visual.enableSmoothTransitions", String.valueOf(Visual.ENABLE_SMOOTH_TRANSITIONS));
        props.setProperty("visual.transitionSpeed", String.valueOf(Visual.TRANSITION_SPEED));
        props.setProperty("visual.enableFlickerEffect", String.valueOf(Visual.ENABLE_FLICKER_EFFECT));
        props.setProperty("visual.flickerIntensity", String.valueOf(Visual.FLICKER_INTENSITY));
        props.setProperty("visual.enableColoredLighting", String.valueOf(Visual.ENABLE_COLORED_LIGHTING));
        props.setProperty("debug.enableDebugLogging", String.valueOf(Debug.ENABLE_DEBUG_LOGGING));
        props.setProperty("debug.showLightPositions", String.valueOf(Debug.SHOW_LIGHT_POSITIONS));
        props.setProperty("debug.enablePerformanceMetrics", String.valueOf(Debug.ENABLE_PERFORMANCE_METRICS));
        props.setProperty("debug.logFrequency", String.valueOf(Debug.LOG_FREQUENCY));
        lightItemsMap.forEach((item, level) -> props.setProperty("lightItems." + item, String.valueOf(level)));
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(CONFIG_PATH, new OpenOption[0]);){
                props.store(output, LightAuraConfig.generateConfigHeader());
            }
            LOGGER.info("Configuration saved successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private static String generateConfigHeader() {
        return "LightAura Dynamic Lighting Configuration v%s\n\nPerformance Settings:\n- updateFrequency: How often to update lighting (1-20 ticks)\n- cleanupDelay: Delay before cleaning up unused lights (ticks)\n- maxLightSources: Maximum number of light sources allowed\n- enablePerformanceMode: Reduces features for better performance\n- performanceModeRadius: Radius for performance mode (blocks)\n\nPlayer Lighting Settings:\n- enablePlayerLighting: Enable player-held item lighting\n- enableOffsets: Enable additional light positions around player\n- enableSurroundingPositions: Add lights around player in non-solid blocks\n- enableAnimationLighting: Enhanced lighting during item use\n- enableHandPositionLighting: Light at hand position\n- enableEyePositionLighting: Light at eye position\n- animationBrightnessMultiplier: Brightness multiplier during animations\n\nDropped Item Lighting Settings:\n- enableDroppedItemLighting: Enable lighting for dropped items\n- scanRadius: Radius to scan for dropped items (blocks)\n- lightMultiplier: Multiplier for dropped item light levels\n- enableStacking: Allow multiple items to stack light levels\n- maxLights: Maximum number of dropped item lights\n- enableDistanceScaling: Scale light based on distance\n- minDistanceMultiplier: Minimum distance scaling factor\n- enableItemBobbingSync: Sync light with item bobbing animation\n\nWorld Interaction Settings:\n- preserveBlocks: Preserve original blocks when placing lights\n- enableEnhancedPlantLighting: Allow lighting through plants\n- enableWaterLighting: Allow lighting in water\n- enableLavaLighting: Allow lighting in lava\n- respectLightBlockingBlocks: Respect blocks that block light\n- blacklistedBlocks: Blocks that cannot be replaced with light\n\nVisual Settings:\n- enableSmoothTransitions: Smooth light transitions\n- transitionSpeed: Speed of light transitions (0.01-1.0)\n- enableFlickerEffect: Add flickering to lights\n- flickerIntensity: Intensity of flicker effect (0.0-1.0)\n- enableColoredLighting: Enable colored lighting (experimental)\n\nDebug Settings:\n- enableDebugLogging: Enable detailed debug logging\n- showLightPositions: Show light positions in debug\n- enablePerformanceMetrics: Track performance metrics\n- logFrequency: How often to log debug info (ticks)\n\nLight Items:\n- Format: lightItems.minecraft:item_name=light_level (0-15)\n".formatted(CONFIG_VERSION);
    }

    private static void setDefaults() {
        lightItemsMap.clear();
        lightItemsMap.putAll(LightAuraConfig.getDefaultLightItems());
    }

    private static Map<String, Integer> getDefaultLightItems() {
        LinkedHashMap<String, Integer> defaults = new LinkedHashMap<String, Integer>();
        defaults.put("minecraft:torch", 14);
        defaults.put("minecraft:soul_torch", 10);
        defaults.put("minecraft:redstone_torch", 7);
        defaults.put("minecraft:lantern", 15);
        defaults.put("minecraft:soul_lantern", 10);
        defaults.put("minecraft:campfire", 15);
        defaults.put("minecraft:soul_campfire", 10);
        defaults.put("minecraft:jack_o_lantern", 15);
        defaults.put("minecraft:glowstone", 15);
        defaults.put("minecraft:glowstone_dust", 10);
        defaults.put("minecraft:sea_lantern", 15);
        defaults.put("minecraft:shroomlight", 15);
        defaults.put("minecraft:end_rod", 14);
        defaults.put("minecraft:beacon", 15);
        defaults.put("minecraft:conduit", 15);
        defaults.put("minecraft:magma_block", 3);
        defaults.put("minecraft:lava_bucket", 15);
        defaults.put("minecraft:blaze_rod", 10);
        defaults.put("minecraft:blaze_powder", 7);
        defaults.put("minecraft:fire_charge", 12);
        defaults.put("minecraft:crying_obsidian", 10);
        defaults.put("minecraft:respawn_anchor", 15);
        defaults.put("minecraft:amethyst_cluster", 5);
        defaults.put("minecraft:large_amethyst_bud", 4);
        defaults.put("minecraft:medium_amethyst_bud", 2);
        defaults.put("minecraft:small_amethyst_bud", 1);
        defaults.put("minecraft:glow_ink_sac", 7);
        defaults.put("minecraft:glow_item_frame", 7);
        defaults.put("minecraft:glow_berries", 12);
        defaults.put("minecraft:ochre_froglight", 15);
        defaults.put("minecraft:verdant_froglight", 15);
        defaults.put("minecraft:pearlescent_froglight", 15);
        defaults.put("minecraft:sculk_catalyst", 6);
        defaults.put("minecraft:ender_eye", 8);
        defaults.put("minecraft:ender_pearl", 4);
        defaults.put("minecraft:experience_bottle", 6);
        defaults.put("minecraft:nether_star", 12);
        return defaults;
    }

    private static int getIntProperty(Properties props, String key, int defaultValue) {
        try {
            return Integer.parseInt(props.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer value for {}: {}", (Object)key, (Object)props.getProperty(key));
            return defaultValue;
        }
    }

    private static double getDoubleProperty(Properties props, String key, double defaultValue) {
        try {
            return Double.parseDouble(props.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid double value for {}: {}", (Object)key, (Object)props.getProperty(key));
            return defaultValue;
        }
    }

    private static boolean getBooleanProperty(Properties props, String key, boolean defaultValue) {
        return Boolean.parseBoolean(props.getProperty(key, String.valueOf(defaultValue)));
    }

    private static void logConfigSummary() {
        LOGGER.info("=== LightAura Configuration Summary ===");
        LOGGER.info("Performance Mode: {}", (Object)Performance.ENABLE_PERFORMANCE_MODE);
        LOGGER.info("Update Frequency: {} ticks", (Object)Performance.UPDATE_FREQUENCY);
        LOGGER.info("Max Light Sources: {}", (Object)Performance.MAX_LIGHT_SOURCES);
        LOGGER.info("Player Lighting: {}", (Object)PlayerLighting.ENABLE_PLAYER_LIGHTING);
        LOGGER.info("Dropped Item Lighting: {}", (Object)DroppedItemLighting.ENABLE_DROPPED_ITEM_LIGHTING);
        LOGGER.info("Light Items Loaded: {}", (Object)compiledLightItems.size());
        LOGGER.info("=====================================");
    }

    public static Map<class_1792, Integer> getLightItems() {
        return new HashMap<class_1792, Integer>(compiledLightItems);
    }

    public static void reloadConfig() {
        LOGGER.info("Reloading configuration...");
        LightAuraConfig.init();
    }

    public static boolean isBlacklistedBlock(String blockId) {
        return WorldInteraction.BLACKLISTED_BLOCKS.contains(blockId);
    }

    public static void addLightItem(String itemId, int lightLevel) {
        lightItemsMap.put(itemId, Math.max(0, Math.min(15, lightLevel)));
        LightAuraConfig.compileLightItems();
        LightAuraConfig.saveConfig();
    }

    public static void removeLightItem(String itemId) {
        lightItemsMap.remove(itemId);
        LightAuraConfig.compileLightItems();
        LightAuraConfig.saveConfig();
    }

    public static class Debug {
        public static boolean ENABLE_DEBUG_LOGGING = false;
        public static boolean SHOW_LIGHT_POSITIONS = false;
        public static boolean ENABLE_PERFORMANCE_METRICS = false;
        public static int LOG_FREQUENCY = 20;
    }

    public static class Performance {
        public static int UPDATE_FREQUENCY = 2;
        public static int CLEANUP_DELAY = 5;
        public static int MAX_LIGHT_SOURCES = 200;
        public static boolean ENABLE_PERFORMANCE_MODE = false;
        public static int PERFORMANCE_MODE_RADIUS = 16;
    }

    public static class PlayerLighting {
        public static boolean ENABLE_PLAYER_LIGHTING = true;
        public static boolean ENABLE_OFFSETS = true;
        public static boolean ENABLE_SURROUNDING_POSITIONS = true;
        public static boolean ENABLE_ANIMATION_LIGHTING = true;
        public static boolean ENABLE_HAND_POSITION_LIGHTING = true;
        public static boolean ENABLE_EYE_POSITION_LIGHTING = true;
        public static double ANIMATION_BRIGHTNESS_MULTIPLIER = 1.2;
    }

    public static class DroppedItemLighting {
        public static boolean ENABLE_DROPPED_ITEM_LIGHTING = true;
        public static int SCAN_RADIUS = 32;
        public static double LIGHT_MULTIPLIER = 1.0;
        public static boolean ENABLE_STACKING = false;
        public static int MAX_LIGHTS = 50;
        public static boolean ENABLE_DISTANCE_SCALING = true;
        public static double MIN_DISTANCE_MULTIPLIER = 0.5;
        public static boolean ENABLE_ITEM_BOBBING_SYNC = true;
    }

    public static class WorldInteraction {
        public static boolean PRESERVE_BLOCKS = true;
        public static boolean ENABLE_ENHANCED_PLANT_LIGHTING = true;
        public static boolean ENABLE_WATER_LIGHTING = false;
        public static boolean ENABLE_LAVA_LIGHTING = false;
        public static boolean RESPECT_LIGHT_BLOCKING_BLOCKS = true;
        public static Set<String> BLACKLISTED_BLOCKS = new HashSet<String>(Arrays.asList("minecraft:bedrock", "minecraft:barrier", "minecraft:structure_block"));
    }

    public static class Visual {
        public static boolean ENABLE_SMOOTH_TRANSITIONS = true;
        public static double TRANSITION_SPEED = 0.1;
        public static boolean ENABLE_FLICKER_EFFECT = false;
        public static double FLICKER_INTENSITY = 0.1;
        public static boolean ENABLE_COLORED_LIGHTING = false;
        public static Map<String, String> ITEM_COLORS = new HashMap<String, String>();
    }
}

