/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightaura")
public class DynamicLightingMod {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger();

    public DynamicLightingMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightingConfig.CLIENT_CONFIG);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Dynamic Lighting Mod initializing");
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientEventHandler {
        private final Map<BlockPos, LightSource> lightBlocks = new ConcurrentHashMap<BlockPos, LightSource>();
        private final Set<BlockPos> pendingUpdates = new HashSet<BlockPos>();
        private final Map<Item, Integer> lightItems = new HashMap<Item, Integer>();
        private final Map<Entity, BlockPos> entityLightPositions = new ConcurrentHashMap<Entity, BlockPos>();
        private final Map<BlockPos, LightSource> persistentLightPositions = new ConcurrentHashMap<BlockPos, LightSource>();
        private int currentPlayerLightLevel = 0;
        private BlockPos lastPlayerPos = null;
        private BlockPos lastPlayerHeadPos = null;
        private int updateFrequency = 2;
        private int cleanupDelay = 5;
        private int droppedItemScanRadius = 32;
        private int droppedItemKeepAliveRadius = 64;
        private boolean enablePlayerLightingOffsets = true;
        private int cleanupCounter = 0;

        public ClientEventHandler() {
            this.setupLightItems();
            this.updateFrequency = (Integer)DynamicLightingConfig.UPDATE_FREQUENCY.get();
            this.cleanupDelay = (Integer)DynamicLightingConfig.CLEANUP_DELAY.get();
            this.droppedItemScanRadius = (Integer)DynamicLightingConfig.DROPPED_ITEM_SCAN_RADIUS.get() * 2;
            this.droppedItemKeepAliveRadius = this.droppedItemScanRadius * 2;
            this.enablePlayerLightingOffsets = (Boolean)DynamicLightingConfig.ENABLE_PLAYER_LIGHTING_OFFSETS.get();
        }

        private void setupLightItems() {
            this.lightItems.put(Items.f_42000_, 14);
            this.lightItems.put(Items.f_42053_, 10);
            this.lightItems.put(Items.f_42778_, 15);
            this.lightItems.put(Items.f_42779_, 10);
            this.lightItems.put(Items.f_42054_, 15);
            this.lightItems.put(Items.f_42251_, 15);
            this.lightItems.put(Items.f_42055_, 15);
            this.lightItems.put(Items.f_42448_, 15);
            this.lightItems.put(Items.f_151079_, 8);
            this.lightItems.put(Items.f_151056_, 10);
            this.lightItems.put(Items.f_42585_, 10);
            this.lightItems.put(Items.f_42258_, 13);
            this.lightItems.put(Items.f_42783_, 15);
            this.lightItems.put(Items.f_42001_, 14);
            this.lightItems.put(Items.f_41978_, 7);
            DynamicLightingConfig.getLightItemsFromConfig().forEach(this.lightItems::put);
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            ClientLevel level = minecraft.f_91073_;
            if (player == null || level == null) {
                return;
            }
            if (minecraft.f_91073_.m_46467_() % (long)this.updateFrequency != 0L) {
                return;
            }
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            int lightLevel = 0;
            if (this.lightItems.containsKey(mainHandItem.m_41720_())) {
                lightLevel = Math.max(lightLevel, this.lightItems.get(mainHandItem.m_41720_()));
            }
            if (this.lightItems.containsKey(offHandItem.m_41720_())) {
                lightLevel = Math.max(lightLevel, this.lightItems.get(offHandItem.m_41720_()));
            }
            for (ItemStack armorItem : player.m_6168_()) {
                if (!this.lightItems.containsKey(armorItem.m_41720_())) continue;
                lightLevel = Math.max(lightLevel, this.lightItems.get(armorItem.m_41720_()));
            }
            this.currentPlayerLightLevel = lightLevel;
            BlockPos playerPos = player.m_142538_();
            Vec3 eyePos = player.m_146892_();
            BlockPos playerHeadPos = new BlockPos((int)eyePos.f_82479_, (int)eyePos.f_82480_, (int)eyePos.f_82481_);
            if (lightLevel > 0) {
                this.placeLightSource((Level)level, playerPos, lightLevel, true);
                if (this.enablePlayerLightingOffsets && !playerHeadPos.equals((Object)playerPos)) {
                    this.placeLightSource((Level)level, playerHeadPos, lightLevel, true);
                }
            } else {
                this.removeLightAtPosition((Level)level, playerPos);
                if (this.enablePlayerLightingOffsets && !playerHeadPos.equals((Object)playerPos)) {
                    this.removeLightAtPosition((Level)level, playerHeadPos);
                }
                if (this.lastPlayerPos != null && !this.lastPlayerPos.equals((Object)playerPos)) {
                    this.removeLightAtPosition((Level)level, this.lastPlayerPos);
                }
                if (this.lastPlayerHeadPos != null && !this.lastPlayerHeadPos.equals((Object)playerHeadPos)) {
                    this.removeLightAtPosition((Level)level, this.lastPlayerHeadPos);
                }
            }
            if (((Boolean)DynamicLightingConfig.ENABLE_DROPPED_ITEM_LIGHTING.get()).booleanValue()) {
                this.processDroppedItems((Level)level, (Player)player);
            }
            this.cleanupLightSources((Level)level, minecraft.f_91073_.m_46467_(), playerPos);
            ++this.cleanupCounter;
            if (this.cleanupCounter >= 20) {
                this.cleanupCounter = 0;
                this.cleanupPersistentLights((Level)level, (Player)player);
            }
            this.applyLightUpdates((Level)level);
            this.lastPlayerPos = playerPos;
            this.lastPlayerHeadPos = playerHeadPos;
        }

        private void processDroppedItems(Level level, Player player) {
            BlockPos playerPos = player.m_142538_();
            HashSet<Entity> toRemove = new HashSet<Entity>();
            for (Map.Entry<Entity, BlockPos> entry : this.entityLightPositions.entrySet()) {
                Entity entity = entry.getKey();
                BlockPos lightPos = entry.getValue();
                if (!entity.m_6084_()) {
                    this.removeLightAtPosition(level, lightPos);
                    toRemove.add(entity);
                    continue;
                }
                double distanceSq = entity.m_20280_((Entity)player);
                if (distanceSq > (double)(this.droppedItemScanRadius * this.droppedItemScanRadius)) {
                    if (distanceSq > (double)(this.droppedItemKeepAliveRadius * this.droppedItemKeepAliveRadius)) {
                        this.removeLightAtPosition(level, lightPos);
                        toRemove.add(entity);
                        continue;
                    }
                    LightSource light = this.lightBlocks.get(lightPos);
                    if (light != null) {
                        this.persistentLightPositions.put(lightPos, light);
                    }
                    toRemove.add(entity);
                    continue;
                }
                BlockPos newPos = new BlockPos((Vec3i)entity.m_142538_());
                if (newPos.equals((Object)lightPos)) continue;
                this.removeLightAtPosition(level, lightPos);
                Entity entity2 = entity;
                if (!(entity2 instanceof ItemEntity)) continue;
                ItemEntity itemEntity2 = (ItemEntity)entity2;
                ItemStack stack = itemEntity2.m_32055_();
                if (this.lightItems.containsKey(stack.m_41720_())) {
                    int itemLightLevel = this.calculateDroppedItemLightLevel(stack.m_41720_());
                    this.placeLightSource(level, newPos, itemLightLevel, false, entity);
                    this.entityLightPositions.put(entity, newPos);
                    continue;
                }
                toRemove.add(entity);
            }
            for (Entity entity : toRemove) {
                this.entityLightPositions.remove(entity);
            }
            level.m_45976_(ItemEntity.class, player.m_142469_().m_82400_((double)this.droppedItemScanRadius)).forEach(itemEntity -> {
                if (this.entityLightPositions.containsKey(itemEntity)) {
                    return;
                }
                ItemStack stack = itemEntity.m_32055_();
                if (this.lightItems.containsKey(stack.m_41720_())) {
                    BlockPos itemPos = itemEntity.m_142538_();
                    int itemLightLevel = this.calculateDroppedItemLightLevel(stack.m_41720_());
                    this.placeLightSource(level, itemPos, itemLightLevel, true, (Entity)itemEntity);
                    this.entityLightPositions.put((Entity)itemEntity, itemPos);
                }
            });
        }

        private void cleanupPersistentLights(Level level, Player player) {
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (Map.Entry<BlockPos, LightSource> entry : this.persistentLightPositions.entrySet()) {
                BlockPos pos = entry.getKey();
                if (player.m_142538_().m_123331_((Vec3i)pos) <= (double)(this.droppedItemScanRadius * this.droppedItemScanRadius)) continue;
                if (player.m_142538_().m_123331_((Vec3i)pos) > (double)(this.droppedItemKeepAliveRadius * this.droppedItemKeepAliveRadius)) {
                    this.removeLightAtPosition(level, pos);
                    toRemove.add(pos);
                }
                boolean entityFound = false;
                for (Entity entity : level.m_45976_(ItemEntity.class, player.m_142469_().m_82400_((double)this.droppedItemKeepAliveRadius))) {
                    if (!entity.m_142538_().equals((Object)pos)) continue;
                    entityFound = true;
                    break;
                }
                if (entityFound) continue;
                this.removeLightAtPosition(level, pos);
                toRemove.add(pos);
            }
            for (BlockPos pos : toRemove) {
                this.persistentLightPositions.remove(pos);
            }
        }

        private int calculateDroppedItemLightLevel(Item item) {
            if (!this.lightItems.containsKey(item)) {
                return 0;
            }
            double multiplier = (Double)DynamicLightingConfig.DROPPED_ITEM_LIGHT_MULTIPLIER.get();
            int baseLevel = this.lightItems.get(item);
            return Math.max(1, (int)((double)baseLevel * multiplier));
        }

        private boolean placeLightSource(Level level, BlockPos pos, int lightLevel, boolean isPersistent) {
            return this.placeLightSource(level, pos, lightLevel, isPersistent, null);
        }

        private boolean placeLightSource(Level level, BlockPos pos, int lightLevel, boolean isPersistent, Entity trackedEntity) {
            try {
                boolean shouldUpdateLight;
                BlockState currentState = level.m_8055_(pos);
                if (!currentState.m_60795_() && !currentState.m_60713_(Blocks.f_152480_)) {
                    return false;
                }
                LightSource existingLight = this.lightBlocks.get(pos);
                boolean bl = shouldUpdateLight = existingLight == null || existingLight.lightLevel < lightLevel || !existingLight.isActive;
                if (shouldUpdateLight) {
                    LightSource lightSource = new LightSource(lightLevel, level.m_46467_(), isPersistent);
                    if (trackedEntity != null) {
                        lightSource.trackedEntity = trackedEntity;
                    }
                    this.lightBlocks.put(pos, lightSource);
                    if (!this.pendingUpdates.contains(pos)) {
                        this.pendingUpdates.add(pos);
                        return this.updateLightAt(level, pos, lightLevel);
                    }
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error placing light source at " + pos, (Throwable)e);
                return false;
            }
        }

        private void removeLightAtPosition(Level level, BlockPos pos) {
            if (this.lightBlocks.containsKey(pos)) {
                this.lightBlocks.remove(pos);
                this.persistentLightPositions.remove(pos);
                this.updateLightAt(level, pos, 0);
                if (!this.pendingUpdates.contains(pos)) {
                    this.pendingUpdates.add(pos);
                }
            } else {
                BlockState currentState = level.m_8055_(pos);
                if (currentState.m_60713_(Blocks.f_152480_)) {
                    this.updateLightAt(level, pos, 0);
                    if (!this.pendingUpdates.contains(pos)) {
                        this.pendingUpdates.add(pos);
                    }
                }
            }
        }

        private void cleanupLightSources(Level level, long currentTime, BlockPos currentPlayerPos) {
            HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
            for (Map.Entry<BlockPos, LightSource> entry : this.lightBlocks.entrySet()) {
                int effectiveCleanupDelay;
                BlockPos pos = entry.getKey();
                LightSource lightSource = entry.getValue();
                if (pos.equals((Object)currentPlayerPos) || pos.equals((Object)this.lastPlayerHeadPos) || lightSource.trackedEntity != null && lightSource.trackedEntity.m_6084_()) continue;
                int n = effectiveCleanupDelay = lightSource.isPersistent ? this.cleanupDelay * 10 : this.cleanupDelay;
                if (lightSource.isActive && currentTime - lightSource.lastUpdate <= (long)effectiveCleanupDelay) continue;
                if (lightSource.trackedEntity instanceof ItemEntity && lightSource.isPersistent) {
                    if (this.persistentLightPositions.containsKey(pos)) continue;
                    this.persistentLightPositions.put(pos, lightSource);
                    continue;
                }
                toRemove.add(pos);
                if (this.pendingUpdates.contains(pos)) continue;
                this.pendingUpdates.add(pos);
                this.updateLightAt(level, pos, 0);
            }
            for (BlockPos pos : toRemove) {
                this.lightBlocks.remove(pos);
            }
        }

        private boolean updateLightAt(Level level, BlockPos pos, int lightLevel) {
            try {
                BlockState currentState;
                if (lightLevel > 0) {
                    BlockState currentState2;
                    if (level.f_46443_ && ((currentState2 = level.m_8055_(pos)).m_60795_() || currentState2.m_60713_(Blocks.f_152480_))) {
                        level.m_7731_(pos, Blocks.f_152480_.m_49966_(), 3);
                        return true;
                    }
                    return false;
                }
                if (level.f_46443_ && (currentState = level.m_8055_(pos)).m_60713_(Blocks.f_152480_)) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error updating light at " + pos, (Throwable)e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyLightUpdates(Level level) {
            if (!this.pendingUpdates.isEmpty()) {
                try {
                    for (BlockPos pos : this.pendingUpdates) {
                        if (!level.f_46443_) continue;
                        level.m_5518_().m_142202_(pos);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error applying light updates", (Throwable)e);
                }
                finally {
                    this.pendingUpdates.clear();
                }
            }
        }
    }

    private static class LightSource {
        public int lightLevel;
        public long lastUpdate;
        public boolean isActive;
        public Entity trackedEntity;
        public boolean isPersistent;

        public LightSource(int lightLevel, long lastUpdate, boolean isPersistent) {
            this.lightLevel = lightLevel;
            this.lastUpdate = lastUpdate;
            this.isActive = true;
            this.trackedEntity = null;
            this.isPersistent = isPersistent;
        }
    }
}

