/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="lightaura", bus=EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
    public static ModConfigSpec.IntValue UPDATE_FREQUENCY;
    public static ModConfigSpec.IntValue DEFAULT_LIGHT_LEVEL;
    public static ModConfigSpec.IntValue CLEANUP_DELAY;
    public static ModConfigSpec.ConfigValue<List<? extends String>> LIGHT_ITEMS;
    public static ModConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING_OFFSETS;
    public static ModConfigSpec.IntValue PERSISTENT_LIGHT_DURATION_MULTIPLIER;
    public static ModConfigSpec.BooleanValue ENABLE_SMOOTH_TRANSITIONS;
    public static ModConfigSpec.BooleanValue ENHANCED_OFFHAND_LIGHTING;
    public static ModConfigSpec.BooleanValue ENABLE_DROPPED_ITEM_LIGHTING;
    public static ModConfigSpec.IntValue DROPPED_ITEM_SCAN_RADIUS;
    public static ModConfigSpec.DoubleValue DROPPED_ITEM_LIGHT_MULTIPLIER;
    public static ModConfigSpec.IntValue MAX_TRACKED_ENTITIES;
    public static ModConfigSpec.BooleanValue OPTIMIZE_LIGHT_UPDATES;
    public static ModConfigSpec.IntValue LIGHT_UPDATE_DISTANCE_CHECK;
    public static final ModConfigSpec CLIENT_CONFIG;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
    }

    public static Map<Item, Integer> getLightItemsFromConfig() {
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        for (String entry : (List)LIGHT_ITEMS.get()) {
            try {
                Item item;
                String[] parts = entry.split("=");
                if (parts.length != 2) continue;
                String itemName = parts[0].trim();
                int lightLevel = Integer.parseInt(parts[1].trim());
                lightLevel = Math.max(0, Math.min(15, lightLevel));
                ResourceLocation itemId = ResourceLocation.tryParse((String)itemName);
                if (itemId == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == null || !BuiltInRegistries.ITEM.containsKey(itemId)) continue;
                result.put(item, lightLevel);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {}
        }
        return result;
    }

    static {
        CLIENT_BUILDER.comment("Dynamic Lighting Mod Configuration");
        UPDATE_FREQUENCY = CLIENT_BUILDER.comment("How often to update dynamic lighting in ticks (1-20, lower = more frequent)").defineInRange("updateFrequency", 2, 1, 20);
        DEFAULT_LIGHT_LEVEL = CLIENT_BUILDER.comment("Default light level for items not specifically defined").defineInRange("defaultLightLevel", 14, 1, 15);
        CLEANUP_DELAY = CLIENT_BUILDER.comment("How long light persists after the source is removed (in ticks)").defineInRange("cleanupDelay", 5, 1, 100);
        CLIENT_BUILDER.push("playerLighting");
        ENABLE_PLAYER_LIGHTING_OFFSETS = CLIENT_BUILDER.comment("Enable placing light at both player's feet and head for more consistent lighting").define("enablePlayerLightingOffsets", true);
        PERSISTENT_LIGHT_DURATION_MULTIPLIER = CLIENT_BUILDER.comment("Multiplier for how long player lights persist (higher values make light stay longer)").defineInRange("persistentLightDurationMultiplier", 2, 1, 10);
        ENABLE_SMOOTH_TRANSITIONS = CLIENT_BUILDER.comment("Enable smooth transitions between different light levels").define("enableSmoothTransitions", true);
        ENHANCED_OFFHAND_LIGHTING = CLIENT_BUILDER.comment("Enable enhanced lighting for offhand items to prevent light from turning off during actions").define("enhancedOffhandLighting", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("droppedItemLighting");
        ENABLE_DROPPED_ITEM_LIGHTING = CLIENT_BUILDER.comment("Enable dynamic lighting for dropped items").define("enableDroppedItemLighting", true);
        DROPPED_ITEM_SCAN_RADIUS = CLIENT_BUILDER.comment("Radius around player to scan for dropped items that emit light (in blocks)").defineInRange("droppedItemScanRadius", 16, 4, 64);
        DROPPED_ITEM_LIGHT_MULTIPLIER = CLIENT_BUILDER.comment("Multiplier for light level of dropped items (0.5 = half as bright as when held)").defineInRange("droppedItemLightMultiplier", 1.0, 0.1, 1.0);
        MAX_TRACKED_ENTITIES = CLIENT_BUILDER.comment("Maximum number of entities that can emit light at once (to prevent performance issues)").defineInRange("maxTrackedEntities", 50, 10, 200);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("performance");
        OPTIMIZE_LIGHT_UPDATES = CLIENT_BUILDER.comment("Enable optimized light updates to reduce performance impact").define("optimizeLightUpdates", true);
        LIGHT_UPDATE_DISTANCE_CHECK = CLIENT_BUILDER.comment("Only update lights within this distance from the player (in blocks)").defineInRange("lightUpdateDistanceCheck", 32, 8, 128);
        CLIENT_BUILDER.pop();
        LIGHT_ITEMS = CLIENT_BUILDER.comment("Custom items and their light levels (format: 'modid:item_name=level')").defineList("lightItems", new ArrayList(), entry -> entry instanceof String && ((String)entry).contains("="));
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

