/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightaura", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.IntValue UPDATE_FREQUENCY;
    public static ForgeConfigSpec.IntValue DEFAULT_LIGHT_LEVEL;
    public static ForgeConfigSpec.IntValue CLEANUP_DELAY;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> LIGHT_ITEMS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING_OFFSETS;
    public static ForgeConfigSpec.IntValue PERSISTENT_LIGHT_DURATION_MULTIPLIER;
    public static ForgeConfigSpec.BooleanValue ENABLE_SMOOTH_TRANSITIONS;
    public static ForgeConfigSpec.BooleanValue ENHANCED_OFFHAND_LIGHTING;
    public static ForgeConfigSpec.BooleanValue ENABLE_DROPPED_ITEM_LIGHTING;
    public static ForgeConfigSpec.IntValue DROPPED_ITEM_SCAN_RADIUS;
    public static ForgeConfigSpec.DoubleValue DROPPED_ITEM_LIGHT_MULTIPLIER;
    public static ForgeConfigSpec.IntValue MAX_TRACKED_ENTITIES;
    public static ForgeConfigSpec.BooleanValue OPTIMIZE_LIGHT_UPDATES;
    public static ForgeConfigSpec.IntValue LIGHT_UPDATE_DISTANCE_CHECK;
    public static final ForgeConfigSpec CLIENT_CONFIG;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
    }

    public static Map<Item, Integer> getLightItemsFromConfig() {
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        for (String entry : (List)LIGHT_ITEMS.get()) {
            try {
                String[] parts = entry.split("=");
                String itemName = parts[0];
                int lightLevel = Integer.parseInt(parts[1]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.tryParse((String)itemName));
                if (item == null) continue;
                result.put(item, lightLevel);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    static {
        CLIENT_BUILDER.comment("Dynamic Lighting Mod Configuration");
        UPDATE_FREQUENCY = CLIENT_BUILDER.comment("How often to update dynamic lighting in ticks (1-20, lower = more frequent)").defineInRange("updateFrequency", 2, 1, 20);
        DEFAULT_LIGHT_LEVEL = CLIENT_BUILDER.comment("Default light level for items not specifically defined").defineInRange("defaultLightLevel", 14, 1, 15);
        CLEANUP_DELAY = CLIENT_BUILDER.comment("How long light persists after the source is removed (in ticks)").defineInRange("cleanupDelay", 5, 1, 100);
        CLIENT_BUILDER.push("playerLighting");
        ENABLE_PLAYER_LIGHTING_OFFSETS = CLIENT_BUILDER.comment("Enable placing light at both player's feet and head for more consistent lighting").define("enablePlayerLightingOffsets", true);
        PERSISTENT_LIGHT_DURATION_MULTIPLIER = CLIENT_BUILDER.comment("Multiplier for how long player lights persist (higher values make light stay longer)").defineInRange("persistentLightDurationMultiplier", 2, 1, 10);
        ENABLE_SMOOTH_TRANSITIONS = CLIENT_BUILDER.comment("Enable smooth transitions between different light levels").define("enableSmoothTransitions", true);
        ENHANCED_OFFHAND_LIGHTING = CLIENT_BUILDER.comment("Enable enhanced lighting for offhand items to prevent light from turning off during actions").define("enhancedOffhandLighting", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("droppedItemLighting");
        ENABLE_DROPPED_ITEM_LIGHTING = CLIENT_BUILDER.comment("Enable dynamic lighting for dropped items").define("enableDroppedItemLighting", true);
        DROPPED_ITEM_SCAN_RADIUS = CLIENT_BUILDER.comment("Radius around player to scan for dropped items that emit light (in blocks)").defineInRange("droppedItemScanRadius", 16, 4, 64);
        DROPPED_ITEM_LIGHT_MULTIPLIER = CLIENT_BUILDER.comment("Multiplier for light level of dropped items (0.5 = half as bright as when held)").defineInRange("droppedItemLightMultiplier", 1.0, 0.1, 1.0);
        MAX_TRACKED_ENTITIES = CLIENT_BUILDER.comment("Maximum number of entities that can emit light at once (to prevent performance issues)").defineInRange("maxTrackedEntities", 50, 10, 200);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("performance");
        OPTIMIZE_LIGHT_UPDATES = CLIENT_BUILDER.comment("Enable optimized light updates to reduce performance impact").define("optimizeLightUpdates", true);
        LIGHT_UPDATE_DISTANCE_CHECK = CLIENT_BUILDER.comment("Only update lights within this distance from the player (in blocks)").defineInRange("lightUpdateDistanceCheck", 32, 8, 128);
        CLIENT_BUILDER.pop();
        LIGHT_ITEMS = CLIENT_BUILDER.comment("Custom items and their light levels (format: 'modid:item_name=level')").defineList("lightItems", new ArrayList(), entry -> entry instanceof String && ((String)entry).contains("="));
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

