/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightaura", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.IntValue UPDATE_FREQUENCY;
    public static ForgeConfigSpec.IntValue DEFAULT_LIGHT_LEVEL;
    public static ForgeConfigSpec.IntValue CLEANUP_DELAY;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> LIGHT_ITEMS;
    public static ForgeConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING;
    public static ForgeConfigSpec.BooleanValue ENABLE_PLAYER_LIGHTING_OFFSETS;
    public static ForgeConfigSpec.IntValue PERSISTENT_LIGHT_DURATION_MULTIPLIER;
    public static ForgeConfigSpec.BooleanValue ENABLE_SMOOTH_TRANSITIONS;
    public static ForgeConfigSpec.BooleanValue ENHANCED_OFFHAND_LIGHTING;
    public static ForgeConfigSpec.BooleanValue ENHANCED_MAINHAND_LIGHTING;
    public static ForgeConfigSpec.BooleanValue PRESERVE_VEGETATION;
    public static ForgeConfigSpec.BooleanValue ENHANCED_TALL_GRASS_DETECTION;
    public static ForgeConfigSpec.BooleanValue PREVENT_PLANT_DESTRUCTION;
    public static ForgeConfigSpec.BooleanValue ENABLE_DROPPED_ITEM_LIGHTING;
    public static ForgeConfigSpec.IntValue DROPPED_ITEM_SCAN_RADIUS;
    public static ForgeConfigSpec.DoubleValue DROPPED_ITEM_LIGHT_MULTIPLIER;
    public static ForgeConfigSpec.IntValue MAX_TRACKED_ENTITIES;
    public static ForgeConfigSpec.BooleanValue OPTIMIZE_LIGHT_UPDATES;
    public static ForgeConfigSpec.IntValue LIGHT_UPDATE_DISTANCE_CHECK;
    public static final ForgeConfigSpec CLIENT_CONFIG;

    private static boolean validateLightItemEntry(String entry) {
        try {
            String[] parts = entry.split("=");
            if (parts.length != 2) {
                return false;
            }
            String itemName = parts[0].trim();
            int lightLevel = Integer.parseInt(parts[1].trim());
            if (!itemName.contains(":")) {
                return false;
            }
            return lightLevel >= 1 && lightLevel <= 15;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
    }

    public static Map<Item, Integer> getLightItemsFromConfig() {
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        int validEntries = 0;
        int invalidEntries = 0;
        for (String entry : (List)LIGHT_ITEMS.get()) {
            try {
                String[] parts = entry.split("=");
                if (parts.length != 2) {
                    ++invalidEntries;
                    continue;
                }
                String itemName = parts[0].trim();
                int lightLevel = Integer.parseInt(parts[1].trim());
                if (lightLevel < 1 || lightLevel > 15) {
                    System.err.println("Dynamic Lighting: Invalid light level " + lightLevel + " for item " + itemName + ". Must be 1-15.");
                    ++invalidEntries;
                    continue;
                }
                ResourceLocation location = ResourceLocation.tryParse((String)itemName);
                if (location == null) {
                    System.err.println("Dynamic Lighting: Invalid item name format: " + itemName);
                    ++invalidEntries;
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
                if (item != null) {
                    result.put(item, lightLevel);
                    ++validEntries;
                    continue;
                }
                System.err.println("Dynamic Lighting: Unknown item: " + itemName);
                ++invalidEntries;
            }
            catch (NumberFormatException e) {
                System.err.println("Dynamic Lighting: Invalid number format in entry: " + entry);
                ++invalidEntries;
            }
            catch (Exception e) {
                System.err.println("Dynamic Lighting: Error processing config entry '" + entry + "': " + e.getMessage());
                ++invalidEntries;
            }
        }
        if (validEntries > 0) {
            System.out.println("Dynamic Lighting: Loaded " + validEntries + " custom light items.");
        }
        if (invalidEntries > 0) {
            System.err.println("Dynamic Lighting: Skipped " + invalidEntries + " invalid config entries.");
        }
        return result;
    }

    static {
        ENABLE_PLAYER_LIGHTING = CLIENT_BUILDER.define("enablePlayerLighting", true);
        UPDATE_FREQUENCY = CLIENT_BUILDER.defineInRange("updateFrequency", 1, 1, 20);
        DEFAULT_LIGHT_LEVEL = CLIENT_BUILDER.defineInRange("defaultLightLevel", 14, 1, 15);
        CLEANUP_DELAY = CLIENT_BUILDER.defineInRange("cleanupDelay", 3, 1, 100);
        CLIENT_BUILDER.push("vegetationProtection");
        PRESERVE_VEGETATION = CLIENT_BUILDER.define("preserveVegetation", true);
        ENHANCED_TALL_GRASS_DETECTION = CLIENT_BUILDER.define("enhancedTallGrassDetection", true);
        PREVENT_PLANT_DESTRUCTION = CLIENT_BUILDER.define("preventPlantDestruction", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("playerLighting");
        ENABLE_PLAYER_LIGHTING_OFFSETS = CLIENT_BUILDER.define("enablePlayerLightingOffsets", true);
        PERSISTENT_LIGHT_DURATION_MULTIPLIER = CLIENT_BUILDER.defineInRange("persistentLightDurationMultiplier", 2, 1, 10);
        ENABLE_SMOOTH_TRANSITIONS = CLIENT_BUILDER.define("enableSmoothTransitions", true);
        ENHANCED_OFFHAND_LIGHTING = CLIENT_BUILDER.define("enhancedOffhandLighting", true);
        ENHANCED_MAINHAND_LIGHTING = CLIENT_BUILDER.define("enhancedMainhandLighting", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("droppedItemLighting");
        ENABLE_DROPPED_ITEM_LIGHTING = CLIENT_BUILDER.define("enableDroppedItemLighting", true);
        DROPPED_ITEM_SCAN_RADIUS = CLIENT_BUILDER.defineInRange("droppedItemScanRadius", 16, 4, 64);
        DROPPED_ITEM_LIGHT_MULTIPLIER = CLIENT_BUILDER.defineInRange("droppedItemLightMultiplier", 1.0, 0.1, 2.0);
        MAX_TRACKED_ENTITIES = CLIENT_BUILDER.defineInRange("maxTrackedEntities", 50, 10, 200);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("performance");
        OPTIMIZE_LIGHT_UPDATES = CLIENT_BUILDER.define("optimizeLightUpdates", true);
        LIGHT_UPDATE_DISTANCE_CHECK = CLIENT_BUILDER.defineInRange("lightUpdateDistanceCheck", 32, 8, 128);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("customLightItems");
        LIGHT_ITEMS = CLIENT_BUILDER.defineList("lightItems", new ArrayList(), entry -> entry instanceof String && ((String)entry).contains("=") && DynamicLightingConfig.validateLightItemEntry((String)entry));
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

