/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="lightaura", bus=EventBusSubscriber.Bus.GAME)
public class ServerLightHandler {
    private static final ConcurrentMap<BlockPos, Integer> lightBlocks = new ConcurrentHashMap<BlockPos, Integer>();
    private static final ConcurrentMap<BlockPos, ItemEntity> droppedItemLights = new ConcurrentHashMap<BlockPos, ItemEntity>();
    private static final Map<Item, Integer> lightItems = new HashMap<Item, Integer>();
    private static final int PLAYER_LIGHT_RADIUS = 5;
    private static final int DROPPED_ITEM_LIGHT_RADIUS = 32;
    private static final Map<Player, BlockPos> playerLightPositions = new HashMap<Player, BlockPos>();

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level world = event.getLevel();
        if (world.isClientSide()) {
            return;
        }
        for (Player player : world.players()) {
            int lightLevel = Math.max(lightItems.getOrDefault(player.getMainHandItem().getItem(), 0), lightItems.getOrDefault(player.getOffhandItem().getItem(), 0));
            if (lightLevel > 0) {
                BlockPos pos = player.blockPosition();
                ServerLightHandler.updatePlayerLight(world, player, pos, lightLevel);
            } else {
                ServerLightHandler.removePlayerLight(world, player);
            }
            AABB searchBox = player.getBoundingBox().inflate(32.0);
            List items = world.getEntitiesOfClass(ItemEntity.class, searchBox, e -> lightItems.containsKey(e.getItem().getItem()));
            for (ItemEntity item : items) {
                BlockPos pos = item.blockPosition();
                int lvl = lightItems.get(item.getItem().getItem());
                ServerLightHandler.placeLight(world, pos, lvl);
                droppedItemLights.put(pos, item);
            }
        }
        ServerLightHandler.cleanupDroppedItems(world);
    }

    private static void updatePlayerLight(Level world, Player player, BlockPos currentPos, int lightLevel) {
        Integer prevLevel;
        BlockPos previousPos = playerLightPositions.get(player);
        if (previousPos != null && !previousPos.equals((Object)currentPos) && world.getBlockState(previousPos).is(Blocks.LIGHT)) {
            world.setBlock(previousPos, Blocks.AIR.defaultBlockState(), 3);
            lightBlocks.remove(previousPos);
        }
        if ((world.getBlockState(currentPos).isAir() || world.getBlockState(currentPos).is(Blocks.LIGHT)) && ((prevLevel = (Integer)lightBlocks.get(currentPos)) == null || prevLevel < lightLevel)) {
            world.setBlock(currentPos, Blocks.LIGHT.defaultBlockState(), 3);
            lightBlocks.put(currentPos, lightLevel);
        }
        playerLightPositions.put(player, currentPos);
    }

    private static void removePlayerLight(Level world, Player player) {
        BlockPos prevPos = playerLightPositions.remove(player);
        if (prevPos != null && world.getBlockState(prevPos).is(Blocks.LIGHT)) {
            world.setBlock(prevPos, Blocks.AIR.defaultBlockState(), 3);
            lightBlocks.remove(prevPos);
        }
    }

    private static void placeLight(Level world, BlockPos pos, int level) {
        if (!world.getBlockState(pos).isAir() && !world.getBlockState(pos).is(Blocks.LIGHT)) {
            return;
        }
        Integer prev = (Integer)lightBlocks.get(pos);
        if (prev == null || prev < level) {
            world.setBlock(pos, Blocks.LIGHT.defaultBlockState(), 3);
            lightBlocks.put(pos, level);
        }
    }

    private static void cleanupDroppedItems(Level world) {
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        for (Map.Entry entry : droppedItemLights.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            ItemEntity item = (ItemEntity)entry.getValue();
            if (item.isAlive() && lightItems.containsKey(item.getItem().getItem())) continue;
            toRemove.add(pos);
        }
        for (BlockPos pos : toRemove) {
            if (world.getBlockState(pos).is(Blocks.LIGHT)) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
            droppedItemLights.remove(pos);
            lightBlocks.remove(pos);
        }
    }

    static {
        lightItems.put(Items.TORCH, 16);
        lightItems.put(Items.SOUL_TORCH, 12);
        lightItems.put(Items.LANTERN, 18);
        lightItems.put(Items.SOUL_LANTERN, 12);
        lightItems.put(Items.GLOWSTONE, 18);
        lightItems.put(Items.SEA_LANTERN, 18);
        lightItems.put(Items.JACK_O_LANTERN, 18);
        lightItems.put(Items.LAVA_BUCKET, 18);
        lightItems.put(Items.GLOW_BERRIES, 10);
        lightItems.put(Items.END_ROD, 16);
    }
}

