/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LightAuraMod
implements ModInitializer,
ClientModInitializer {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger((String)"lightaura");
    private static final Map<class_2338, LightSource> lightBlocks = new ConcurrentHashMap<class_2338, LightSource>();
    private static final Set<class_2338> pendingUpdates = new HashSet<class_2338>();
    private static final Map<class_1792, Integer> lightItems = new HashMap<class_1792, Integer>();
    private static final Map<class_1297, class_2338> entityLightPositions = new ConcurrentHashMap<class_1297, class_2338>();
    private static int updateFrequency = 2;
    private static int cleanupDelay = 5;
    private static int droppedItemScanRadius = 16;
    private static boolean enablePlayerLightingOffsets = true;
    private static boolean enableDroppedItemLighting = true;
    private static double droppedItemLightMultiplier = 1.0;
    private static int persistentLightDurationMultiplier = 2;
    private static int consecutiveFailedUpdates = 0;
    private static int currentPlayerLightLevel = 0;
    private static class_2338 lastPlayerPos = null;
    private static class_2338 lastPlayerHeadPos = null;

    public void onInitialize() {
        LOGGER.info("LightAura Mod Initialized (Server Side)");
    }

    public void onInitializeClient() {
        LOGGER.info("Initializing LightAura Dynamic Lighting Mod for Fabric");
        this.loadConfig();
        this.setupLightItems();
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void loadConfig() {
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), MOD_ID);
        configDir.mkdirs();
        File configFile = new File(configDir, "config.properties");
        Properties props = new Properties();
        props.setProperty("updateFrequency", "2");
        props.setProperty("cleanupDelay", "5");
        props.setProperty("droppedItemScanRadius", "32");
        props.setProperty("enablePlayerLightingOffsets", "true");
        props.setProperty("enableDroppedItemLighting", "true");
        props.setProperty("droppedItemLightMultiplier", "1.0");
        props.setProperty("persistentLightDurationMultiplier", "2");
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                props.load(reader);
                LOGGER.info("Loaded LightAura config");
            }
            catch (IOException e) {
                LOGGER.error("Error loading config", (Throwable)e);
            }
        } else {
            try (FileWriter writer = new FileWriter(configFile);){
                props.store(writer, "LightAura Dynamic Lighting Mod Configuration");
                LOGGER.info("Created default LightAura config");
            }
            catch (IOException e) {
                LOGGER.error("Error creating default config", (Throwable)e);
            }
        }
        updateFrequency = Integer.parseInt(props.getProperty("updateFrequency"));
        cleanupDelay = Integer.parseInt(props.getProperty("cleanupDelay"));
        droppedItemScanRadius = Integer.parseInt(props.getProperty("droppedItemScanRadius"));
        enablePlayerLightingOffsets = Boolean.parseBoolean(props.getProperty("enablePlayerLightingOffsets"));
        enableDroppedItemLighting = Boolean.parseBoolean(props.getProperty("enableDroppedItemLighting"));
        droppedItemLightMultiplier = Double.parseDouble(props.getProperty("droppedItemLightMultiplier"));
        persistentLightDurationMultiplier = Integer.parseInt(props.getProperty("persistentLightDurationMultiplier"));
    }

    private void setupLightItems() {
        lightItems.put(class_1802.field_8810, 14);
        lightItems.put(class_1802.field_22001, 10);
        lightItems.put(class_1802.field_16539, 15);
        lightItems.put(class_1802.field_22016, 10);
        lightItems.put(class_1802.field_8801, 15);
        lightItems.put(class_1802.field_8305, 15);
        lightItems.put(class_1802.field_8693, 15);
        lightItems.put(class_1802.field_8187, 15);
        lightItems.put(class_1802.field_28659, 8);
        lightItems.put(class_1802.field_28410, 10);
        lightItems.put(class_1802.field_8894, 10);
        lightItems.put(class_1802.field_8354, 13);
        lightItems.put(class_1802.field_22017, 15);
        lightItems.put(class_1802.field_8056, 14);
        lightItems.put(class_1802.field_8530, 7);
    }

    private void onClientTick(class_310 client) {
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        if (player == null || world == null) {
            return;
        }
        if (world.method_8510() % (long)updateFrequency != 0L) {
            return;
        }
        class_1799 mainHandItem = player.method_6047();
        class_1799 offHandItem = player.method_6079();
        int lightLevel = 0;
        if (lightItems.containsKey(mainHandItem.method_7909())) {
            lightLevel = Math.max(lightLevel, lightItems.get(mainHandItem.method_7909()));
        }
        if (lightItems.containsKey(offHandItem.method_7909())) {
            lightLevel = Math.max(lightLevel, lightItems.get(offHandItem.method_7909()));
        }
        for (class_1799 armorItem : player.method_5661()) {
            if (!lightItems.containsKey(armorItem.method_7909())) continue;
            lightLevel = Math.max(lightLevel, lightItems.get(armorItem.method_7909()));
        }
        currentPlayerLightLevel = lightLevel;
        class_2338 playerPos = player.method_24515();
        class_243 eyePos = player.method_33571();
        class_2338 playerHeadPos = new class_2338((int)eyePos.field_1352, (int)eyePos.field_1351, (int)eyePos.field_1350);
        if (lightLevel > 0) {
            boolean placedFeetLight = this.placeLightSource((class_1937)world, playerPos, lightLevel, true);
            boolean placedHeadLight = false;
            if (enablePlayerLightingOffsets && !playerHeadPos.equals((Object)playerPos)) {
                placedHeadLight = this.placeLightSource((class_1937)world, playerHeadPos, lightLevel, true);
            }
            if (!placedFeetLight && !placedHeadLight) {
                if (++consecutiveFailedUpdates >= 3) {
                    LOGGER.debug("Attempting recovery lighting around player");
                    this.placeLightInValidAdjacentBlock((class_1937)world, playerPos, lightLevel);
                    consecutiveFailedUpdates = 0;
                }
            } else {
                consecutiveFailedUpdates = 0;
            }
        } else {
            this.removeLightAtPosition((class_1937)world, playerPos);
            if (!playerHeadPos.equals((Object)playerPos)) {
                this.removeLightAtPosition((class_1937)world, playerHeadPos);
            }
            if (lastPlayerPos != null && !lastPlayerPos.equals((Object)playerPos)) {
                this.removeLightAtPosition((class_1937)world, lastPlayerPos);
            }
            if (lastPlayerHeadPos != null && !lastPlayerHeadPos.equals((Object)playerHeadPos)) {
                this.removeLightAtPosition((class_1937)world, lastPlayerHeadPos);
            }
        }
        if (enableDroppedItemLighting) {
            this.processDroppedItems((class_1937)world, (class_1657)player);
        }
        this.cleanupLightSources((class_1937)world, world.method_8510(), playerPos);
        this.applyLightUpdates((class_1937)world);
        lastPlayerPos = playerPos;
        lastPlayerHeadPos = playerHeadPos;
    }

    private boolean placeLightInValidAdjacentBlock(class_1937 world, class_2338 center, int lightLevel) {
        class_2338[] adjacentPositions;
        for (class_2338 pos : adjacentPositions = new class_2338[]{center.method_10084(), center.method_10074(), center.method_10095(), center.method_10072(), center.method_10078(), center.method_10067(), center.method_10095().method_10078(), center.method_10095().method_10067(), center.method_10072().method_10078(), center.method_10072().method_10067()}) {
            if (!world.method_8320(pos).method_26215() && world.method_8320(pos).method_26204() != class_2246.field_31037 || !this.placeLightSource(world, pos, lightLevel, true)) continue;
            LOGGER.debug("Recovery successful - placed light at adjacent block: {}", (Object)pos);
            return true;
        }
        return false;
    }

    private void processDroppedItems(class_1937 world, class_1657 player) {
        HashSet<class_1297> toRemove = new HashSet<class_1297>();
        for (Map.Entry<class_1297, class_2338> entry : entityLightPositions.entrySet()) {
            class_1297 entity2 = entry.getKey();
            class_2338 lightPos = entry.getValue();
            if (!entity2.method_5805()) {
                this.removeLightAtPosition(world, lightPos);
                toRemove.add(entity2);
                continue;
            }
            class_2338 newPos = entity2.method_24515();
            if (newPos.equals((Object)lightPos)) continue;
            this.removeLightAtPosition(world, lightPos);
            if (!(entity2 instanceof class_1542)) continue;
            class_1542 itemEntity = (class_1542)entity2;
            class_1799 stack = itemEntity.method_6983();
            if (lightItems.containsKey(stack.method_7909())) {
                int itemLightLevel = this.calculateDroppedItemLightLevel(stack.method_7909());
                LightSource lightSource = new LightSource(itemLightLevel, world.method_8510(), entity2);
                lightBlocks.put(newPos, lightSource);
                pendingUpdates.add(newPos);
                this.updateLightAt(world, newPos, itemLightLevel);
                entityLightPositions.put(entity2, newPos);
                continue;
            }
            toRemove.add(entity2);
        }
        for (class_1297 entity3 : toRemove) {
            entityLightPositions.remove(entity3);
        }
        for (class_1542 itemEntity : world.method_8390(class_1542.class, player.method_5829().method_1014((double)droppedItemScanRadius), entity -> true)) {
            class_1799 stack;
            if (entityLightPositions.containsKey(itemEntity) || !lightItems.containsKey((stack = itemEntity.method_6983()).method_7909())) continue;
            class_2338 itemPos = itemEntity.method_24515();
            int itemLightLevel = this.calculateDroppedItemLightLevel(stack.method_7909());
            LightSource lightSource = new LightSource(itemLightLevel, world.method_8510(), (class_1297)itemEntity);
            lightBlocks.put(itemPos, lightSource);
            pendingUpdates.add(itemPos);
            this.updateLightAt(world, itemPos, itemLightLevel);
            entityLightPositions.put((class_1297)itemEntity, itemPos);
        }
    }

    private int calculateDroppedItemLightLevel(class_1792 item) {
        if (!lightItems.containsKey(item)) {
            return 0;
        }
        int baseLevel = lightItems.get(item);
        return Math.max(1, (int)((double)baseLevel * droppedItemLightMultiplier));
    }

    private boolean placeLightSource(class_1937 world, class_2338 pos, int lightLevel, boolean isPersistent) {
        try {
            boolean shouldUpdateLight;
            if (!world.method_8320(pos).method_26215() && world.method_8320(pos).method_26204() != class_2246.field_31037) {
                return false;
            }
            LightSource existingLight = lightBlocks.get(pos);
            boolean bl = shouldUpdateLight = existingLight == null || existingLight.lightLevel < lightLevel || !existingLight.isActive;
            if (shouldUpdateLight) {
                if (existingLight == null) {
                    lightBlocks.put(pos, new LightSource(lightLevel, world.method_8510(), isPersistent));
                } else {
                    existingLight.lightLevel = lightLevel;
                    existingLight.lastUpdate = world.method_8510();
                    existingLight.isActive = true;
                    existingLight.isPersistent = isPersistent;
                }
                if (!pendingUpdates.contains(pos)) {
                    pendingUpdates.add(pos);
                    return this.updateLightAt(world, pos, lightLevel);
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error placing light source at " + pos, (Throwable)e);
            return false;
        }
    }

    private void removeLightAtPosition(class_1937 world, class_2338 pos) {
        if (lightBlocks.containsKey(pos)) {
            LightAuraMod.lightBlocks.get((Object)pos).isActive = false;
            LightAuraMod.lightBlocks.get((Object)pos).lastUpdate = world.method_8510() - (long)cleanupDelay;
            if (!pendingUpdates.contains(pos)) {
                pendingUpdates.add(pos);
                this.updateLightAt(world, pos, 0);
            }
            lightBlocks.remove(pos);
        }
    }

    private void cleanupLightSources(class_1937 world, long currentTime, class_2338 currentPlayerPos) {
        HashSet<class_2338> toRemove = new HashSet<class_2338>();
        for (Map.Entry<class_2338, LightSource> entry : lightBlocks.entrySet()) {
            int effectiveCleanupDelay;
            class_2338 pos = entry.getKey();
            LightSource lightSource = entry.getValue();
            if (pos.equals((Object)currentPlayerPos) || pos.equals((Object)lastPlayerHeadPos) || lightSource.trackedEntity != null) continue;
            int n = effectiveCleanupDelay = lightSource.isPersistent ? cleanupDelay * persistentLightDurationMultiplier : cleanupDelay;
            if (lightSource.isActive && currentTime - lightSource.lastUpdate <= (long)effectiveCleanupDelay) continue;
            toRemove.add(pos);
            if (pendingUpdates.contains(pos)) continue;
            pendingUpdates.add(pos);
            this.updateLightAt(world, pos, 0);
        }
        for (class_2338 pos : toRemove) {
            lightBlocks.remove(pos);
        }
    }

    private boolean updateLightAt(class_1937 world, class_2338 pos, int lightLevel) {
        try {
            if (lightLevel > 0) {
                LOGGER.debug("Setting light level {} at {}", (Object)lightLevel, (Object)pos);
                if (world.method_8320(pos).method_26215() || world.method_8320(pos).method_26204() == class_2246.field_31037) {
                    int flags = 2;
                    world.method_8652(pos, class_2246.field_31037.method_9564(), flags);
                    return true;
                }
                return false;
            }
            LOGGER.debug("Removing light at {}", (Object)pos);
            if (world.method_8320(pos).method_26204() == class_2246.field_31037) {
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error updating light at " + pos, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLightUpdates(class_1937 world) {
        if (!pendingUpdates.isEmpty()) {
            try {
                for (class_2338 pos : pendingUpdates) {
                    world.method_8408(pos, class_2246.field_31037);
                    world.method_8398().method_12130().method_15513(pos);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error applying light updates", (Throwable)e);
            }
            finally {
                pendingUpdates.clear();
            }
        }
    }

    private static class LightSource {
        public int lightLevel;
        public long lastUpdate;
        public boolean isActive;
        public class_1297 trackedEntity;
        public boolean isPersistent;

        public LightSource(int lightLevel, long lastUpdate) {
            this.lightLevel = lightLevel;
            this.lastUpdate = lastUpdate;
            this.isActive = true;
            this.trackedEntity = null;
            this.isPersistent = false;
        }

        public LightSource(int lightLevel, long lastUpdate, class_1297 entity) {
            this(lightLevel, lastUpdate);
            this.trackedEntity = entity;
        }

        public LightSource(int lightLevel, long lastUpdate, boolean persistent) {
            this(lightLevel, lastUpdate);
            this.isPersistent = persistent;
        }
    }
}

