/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DroppedItemLightingHandler;
import com.example.lightaura.DynamicLightingConfig;
import com.example.lightaura.LightManager;
import com.example.lightaura.PlayerLightingHandler;
import java.io.Serializable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightaura")
public class DynamicLightingMod {
    public static final String MOD_ID = "lightaura";
    private static final Logger LOGGER = LogManager.getLogger();

    public DynamicLightingMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightingConfig.SPEC);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        LOGGER.info("Dynamic Lighting (client) initialized for 1.20.1");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientEventHandler {
        private final LightManager lightManager = new LightManager();
        private final PlayerLightingHandler playerLightingHandler = new PlayerLightingHandler();
        private final DroppedItemLightingHandler droppedItemLightingHandler = new DroppedItemLightingHandler();
        private BlockPos lastPlayerPos;
        private BlockPos lastPlayerHeadPos;

        private ClientEventHandler() {
        }

        @SubscribeEvent
        public void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
            this.lightManager.cleanupAllLights();
            this.playerLightingHandler.cleanup();
        }

        @SubscribeEvent
        public void onItemPickup(EntityItemPickupEvent event) {
            if (event.getEntity().m_9236_().f_46443_) {
                ItemEntity itemEntity = event.getItem();
                this.lightManager.addPendingPickupEntity((Entity)itemEntity);
                this.lightManager.removeEntityLight((Entity)itemEntity);
            }
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            boolean shouldProcess;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ClientLevel level = mc.f_91073_;
            if (player == null || level == null) {
                return;
            }
            int updateInterval = DynamicLightingConfig.getUpdateFrequency();
            int cleanupDelay = DynamicLightingConfig.getCleanupDelay();
            int scanRadius = DynamicLightingConfig.getDroppedItemRadius();
            double droppedItemLightMultiplier = DynamicLightingConfig.getDroppedItemMultiplier();
            boolean enablePlayerLighting = DynamicLightingConfig.playerLightingEnabled();
            int transitionLightDuration = 5;
            int maxTrackedEntities = 50;
            int lightUpdateDistance = 32;
            boolean enableSmoothTransitions = false;
            boolean enhancedOffhandLighting = true;
            boolean enhancedMainhandLighting = true;
            boolean optimizeLightUpdates = true;
            boolean enablePlayerLightingOffsets = true;
            this.lightManager.setEnableSmoothTransitions(enableSmoothTransitions);
            boolean bl = shouldProcess = level.m_46467_() % (long)updateInterval == 0L;
            if (this.playerLightingHandler.isAscending() || this.playerLightingHandler.getVerticalMoveCooldown() > 0) {
                shouldProcess = true;
                if (this.playerLightingHandler.getVerticalMoveCooldown() > 0) {
                    this.playerLightingHandler.setVerticalMoveCooldown(this.playerLightingHandler.getVerticalMoveCooldown() - 1);
                }
            }
            if (!shouldProcess) {
                return;
            }
            BlockPos currentPos = player.m_20183_();
            this.playerLightingHandler.detectVerticalMovement((Player)player, currentPos, this.lastPlayerPos);
            this.playerLightingHandler.detectPlayerDigging(mc);
            if (enablePlayerLighting) {
                this.playerLightingHandler.updatePlayerLightLevels((Player)player);
                this.playerLightingHandler.handlePlayerLighting((Level)level, (Player)player, currentPos, this.lightManager, enablePlayerLightingOffsets, enhancedMainhandLighting, enhancedOffhandLighting);
            }
            if (level.m_46467_() % (long)(updateInterval * 2) == 0L) {
                this.droppedItemLightingHandler.handleDroppedItemLighting((Level)level, (Player)player, this.lightManager, scanRadius, maxTrackedEntities, droppedItemLightMultiplier);
            }
            if (enableSmoothTransitions) {
                this.lightManager.processTransitioningLights((Level)level, enableSmoothTransitions, transitionLightDuration, this.playerLightingHandler.isAscending());
            }
            this.lightManager.cleanupLights((Level)level, currentPos, this.playerLightingHandler.isAscending(), this.playerLightingHandler.getPlayerLightPositions(), this.playerLightingHandler.getOffhandLightPositions(), this.playerLightingHandler.getMainhandLightPositions(), this.playerLightingHandler.getTallGrassLightPositions(), cleanupDelay, transitionLightDuration, lightUpdateDistance, optimizeLightUpdates, enableSmoothTransitions);
            this.lightManager.applyLightUpdates((Level)level, this.lastPlayerPos, this.playerLightingHandler.isAscending());
            this.lastPlayerPos = currentPos;
            this.lastPlayerHeadPos = BlockPos.m_274446_((Position)player.m_146892_());
        }
    }
}

