/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import com.example.lightaura.DynamicLightingConfig;
import com.example.lightaura.LightManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerLightingHandler {
    private int playerLightLevel = 0;
    private int mainHandLightLevel = 0;
    private int offHandLightLevel = 0;
    private boolean isPlayerDigging = false;
    private long lastDiggingTime = 0L;
    private boolean isAscending = false;
    private long lastVerticalMoveTime = 0L;
    private int verticalMoveCooldown = 0;
    private final Set<BlockPos> playerLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> offhandLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> mainhandLightPositions = new HashSet<BlockPos>();
    private final Set<BlockPos> tallGrassLightPositions = new HashSet<BlockPos>();
    private static final int MAX_LIGHT_LEVEL = 15;

    public void detectVerticalMovement(Player player, BlockPos currentPos, BlockPos lastPlayerPos) {
        if (lastPlayerPos != null) {
            boolean movingUpward;
            boolean movingVertically = currentPos.m_123342_() != lastPlayerPos.m_123342_();
            boolean bl = movingUpward = currentPos.m_123342_() > lastPlayerPos.m_123342_();
            if (movingVertically) {
                this.lastVerticalMoveTime = player.m_9236_().m_46467_();
                if (movingUpward) {
                    this.isAscending = true;
                    this.verticalMoveCooldown = 5;
                }
            } else {
                long timeSinceVerticalMove = player.m_9236_().m_46467_() - this.lastVerticalMoveTime;
                if (timeSinceVerticalMove > 3L) {
                    this.isAscending = false;
                }
            }
        }
    }

    public void detectPlayerDigging(Minecraft mc) {
        boolean digging;
        boolean bl = digging = mc.f_91072_ != null && mc.f_91072_.m_105296_();
        if (digging && !this.isPlayerDigging) {
            this.lastDiggingTime = mc.f_91073_.m_46467_();
        }
        this.isPlayerDigging = digging;
    }

    public void updatePlayerLightLevels(Player player) {
        this.playerLightLevel = 0;
        this.mainHandLightLevel = 0;
        this.offHandLightLevel = 0;
        this.mainHandLightLevel = this.getLightLevel(player.m_21205_());
        this.playerLightLevel = Math.max(this.playerLightLevel, this.mainHandLightLevel);
        this.offHandLightLevel = this.getLightLevel(player.m_21206_());
        this.playerLightLevel = Math.max(this.playerLightLevel, this.offHandLightLevel);
        for (ItemStack armor : player.m_6168_()) {
            int armorLight = this.getLightLevel(armor);
            this.playerLightLevel = Math.max(this.playerLightLevel, armorLight);
        }
        this.playerLightLevel = this.clampLightLevel(this.playerLightLevel);
        this.mainHandLightLevel = this.clampLightLevel(this.mainHandLightLevel);
        this.offHandLightLevel = this.clampLightLevel(this.offHandLightLevel);
    }

    private int getLightLevel(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Map<Item, Integer> lightItems = DynamicLightingConfig.getLightItems();
        int level = lightItems.getOrDefault(stack.m_41720_(), 0);
        return this.clampLightLevel(level);
    }

    private int clampLightLevel(int level) {
        return Math.max(0, Math.min(15, level));
    }

    public void handlePlayerLighting(Level level, Player player, BlockPos currentPos, LightManager lightManager, boolean enablePlayerLightingOffsets, boolean enhancedMainhandLighting, boolean enhancedOffhandLighting) {
        this.playerLightPositions.clear();
        this.mainhandLightPositions.clear();
        this.offhandLightPositions.clear();
        this.tallGrassLightPositions.clear();
        boolean inTallGrass = this.isPlayerInTallGrass(level, player, currentPos);
        boolean onSpecialBlock = this.isSpecialBlock(level, currentPos);
        if (this.playerLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.playerLightPositions);
            } else {
                this.playerLightPositions.add(currentPos);
                if (enablePlayerLightingOffsets) {
                    BlockPos headPos = BlockPos.m_274446_((Position)player.m_146892_());
                    this.playerLightPositions.add(headPos);
                    if (this.isAscending) {
                        this.playerLightPositions.add(headPos.m_7494_());
                    }
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos offsetPos = currentPos.m_7918_(x, 0, z);
                        if (this.isPlantBlock(level.m_8055_(offsetPos))) continue;
                        this.playerLightPositions.add(offsetPos);
                    }
                }
                if (onSpecialBlock) {
                    this.playerLightPositions.add(currentPos.m_7494_());
                }
            }
        }
        if (enhancedMainhandLighting && this.mainHandLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.mainhandLightPositions);
            } else {
                this.mainhandLightPositions.add(currentPos);
                Vec3 lookVec = player.m_20154_();
                BlockPos frontPos = currentPos.m_7918_((int)Math.round(lookVec.f_82479_), (int)Math.round(lookVec.f_82480_), (int)Math.round(lookVec.f_82481_));
                if (!this.isPlantBlock(level.m_8055_(frontPos))) {
                    this.mainhandLightPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    this.mainhandLightPositions.add(currentPos.m_7494_());
                }
            }
        }
        if (enhancedOffhandLighting && this.offHandLightLevel > 0) {
            if (inTallGrass) {
                this.addTallGrassLightPositions(level, player, currentPos, this.offhandLightPositions);
            } else {
                this.offhandLightPositions.add(currentPos);
                Vec3 lookVec = player.m_20154_();
                BlockPos frontPos = currentPos.m_7918_((int)Math.round(lookVec.f_82479_), (int)Math.round(lookVec.f_82480_), (int)Math.round(lookVec.f_82481_));
                if (!this.isPlantBlock(level.m_8055_(frontPos))) {
                    this.offhandLightPositions.add(frontPos);
                }
                if (onSpecialBlock) {
                    this.offhandLightPositions.add(currentPos.m_7494_());
                }
            }
        }
        for (BlockPos pos : this.playerLightPositions) {
            lightManager.placeLight(level, pos, this.playerLightLevel, true, null, false, false);
        }
        for (BlockPos pos : this.mainhandLightPositions) {
            lightManager.placeLight(level, pos, this.mainHandLightLevel, true, null, false, true);
        }
        for (BlockPos pos : this.offhandLightPositions) {
            lightManager.placeLight(level, pos, this.offHandLightLevel, true, null, true, false);
        }
        for (BlockPos pos : this.tallGrassLightPositions) {
            lightManager.placeLight(level, pos, this.playerLightLevel, true, null, false, false);
        }
        lightManager.removeOldLightPositions(level, this.getPlayerLightPositions(), this.playerLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getMainhandLightPositions(), this.mainhandLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getOffhandLightPositions(), this.offhandLightPositions, this.isAscending);
        lightManager.removeOldLightPositions(level, this.getTallGrassLightPositions(), this.tallGrassLightPositions, this.isAscending);
    }

    private boolean isPlayerInTallGrass(Level level, Player player, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        BlockState belowState = level.m_8055_(pos.m_7495_());
        boolean inPlant = this.isPlantBlock(state) || this.isPlantBlock(aboveState);
        boolean onPlant = this.isPlantBlock(belowState) || belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_152481_);
        return inPlant || onPlant;
    }

    private boolean isSpecialBlock(Level level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return !belowState.m_60795_() && !belowState.m_60713_(Blocks.f_152480_) && (belowState.m_60713_(Blocks.f_50440_) || belowState.m_60713_(Blocks.f_50493_) || belowState.m_60713_(Blocks.f_50599_) || belowState.m_60713_(Blocks.f_50195_) || belowState.m_60713_(Blocks.f_50093_) || belowState.m_60713_(Blocks.f_152481_) || belowState.m_60713_(Blocks.f_50156_) || belowState.m_60713_(Blocks.f_50030_) || belowState.m_60713_(Blocks.f_50031_) || belowState.m_60713_(Blocks.f_50285_) || belowState.m_60713_(Blocks.f_50125_) || belowState.m_60713_(Blocks.f_50127_) || this.isPlantBlock(belowState));
    }

    private void addTallGrassLightPositions(Level level, Player player, BlockPos currentPos, Set<BlockPos> targetSet) {
        targetSet.add(currentPos.m_7494_());
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos offsetPos = currentPos.m_7918_(x, 0, z);
                BlockState offsetState = level.m_8055_(offsetPos);
                if (!this.isPlantBlock(offsetState)) {
                    targetSet.add(offsetPos);
                    continue;
                }
                BlockPos aboveOffset = offsetPos.m_7494_();
                if (!level.m_8055_(aboveOffset).m_60795_()) continue;
                targetSet.add(aboveOffset);
            }
        }
        targetSet.add(currentPos.m_7494_().m_122012_());
        targetSet.add(currentPos.m_7494_().m_122019_());
        targetSet.add(currentPos.m_7494_().m_122029_());
        targetSet.add(currentPos.m_7494_().m_122024_());
    }

    private boolean isPlantBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50359_) || state.m_60713_(Blocks.f_50035_) || state.m_60713_(Blocks.f_50360_) || state.m_60713_(Blocks.f_50130_) || state.m_60713_(Blocks.f_50092_) || state.m_60713_(Blocks.f_50249_) || state.m_60713_(Blocks.f_50250_) || state.m_60713_(Blocks.f_50444_) || state.m_60713_(Blocks.f_50189_) || state.m_60713_(Blocks.f_50190_) || state.m_60713_(Blocks.f_50191_) || state.m_60713_(Blocks.f_50196_) || state.m_60713_(Blocks.f_50037_) || state.m_60713_(Blocks.f_50038_) || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) || state.m_60713_(Blocks.f_50571_) || state.m_60713_(Blocks.f_50570_) || state.m_60713_(Blocks.f_50128_) || state.m_60713_(Blocks.f_50036_) || state.m_60713_(Blocks.f_50111_) || state.m_60713_(Blocks.f_50112_) || state.m_60713_(Blocks.f_50113_) || state.m_60713_(Blocks.f_50114_) || state.m_60713_(Blocks.f_50115_) || state.m_60713_(Blocks.f_50116_) || state.m_60713_(Blocks.f_50117_) || state.m_60713_(Blocks.f_50118_) || state.m_60713_(Blocks.f_50119_) || state.m_60713_(Blocks.f_50120_) || state.m_60713_(Blocks.f_50121_) || state.m_60713_(Blocks.f_50071_) || state.m_60713_(Blocks.f_50070_) || state.m_60713_(Blocks.f_50355_) || state.m_60713_(Blocks.f_50356_) || state.m_60713_(Blocks.f_50357_) || state.m_60713_(Blocks.f_50358_) || state.m_60713_(Blocks.f_50654_) || state.m_60713_(Blocks.f_50693_) || state.m_60713_(Blocks.f_50694_) || state.m_60713_(Blocks.f_50702_) || state.m_60713_(Blocks.f_50704_) || state.m_60713_(Blocks.f_152475_);
    }

    public int getPlayerLightLevel() {
        return this.playerLightLevel;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public int getVerticalMoveCooldown() {
        return this.verticalMoveCooldown;
    }

    public void setVerticalMoveCooldown(int verticalMoveCooldown) {
        this.verticalMoveCooldown = verticalMoveCooldown;
    }

    public Set<BlockPos> getPlayerLightPositions() {
        return this.playerLightPositions;
    }

    public Set<BlockPos> getOffhandLightPositions() {
        return this.offhandLightPositions;
    }

    public Set<BlockPos> getMainhandLightPositions() {
        return this.mainhandLightPositions;
    }

    public Set<BlockPos> getTallGrassLightPositions() {
        return this.tallGrassLightPositions;
    }

    public boolean isPlayerDigging() {
        return this.isPlayerDigging;
    }

    public long getLastDiggingTime() {
        return this.lastDiggingTime;
    }

    public void cleanup() {
        this.playerLightLevel = 0;
        this.mainHandLightLevel = 0;
        this.offHandLightLevel = 0;
        this.isPlayerDigging = false;
        this.lastDiggingTime = 0L;
        this.isAscending = false;
        this.lastVerticalMoveTime = 0L;
        this.verticalMoveCooldown = 0;
        this.playerLightPositions.clear();
        this.offhandLightPositions.clear();
        this.mainhandLightPositions.clear();
        this.tallGrassLightPositions.clear();
    }
}

