/*
 * Decompiled with CFR 0.152.
 */
package com.example.lightaura;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lightaura", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DynamicLightingConfig {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.IntValue UPDATE_FREQUENCY;
    public static ForgeConfigSpec.IntValue DEFAULT_LIGHT_LEVEL;
    public static ForgeConfigSpec.IntValue CLEANUP_DELAY;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> LIGHT_ITEMS;
    public static ForgeConfigSpec.IntValue LIGHT_FOLLOW_DISTANCE;
    public static ForgeConfigSpec.IntValue LIGHT_CHANGE_DELAY;
    public static final ForgeConfigSpec CLIENT_CONFIG;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
    }

    public static Map<Item, Integer> getLightItemsFromConfig() {
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        for (String entry : (List)LIGHT_ITEMS.get()) {
            try {
                String[] parts = entry.split("=");
                String itemName = parts[0];
                int lightLevel = Integer.parseInt(parts[1]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)itemName));
                if (item == null) continue;
                result.put(item, lightLevel);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    static {
        CLIENT_BUILDER.comment("Dynamic Lighting Mod Configuration");
        UPDATE_FREQUENCY = CLIENT_BUILDER.comment("How often to update dynamic lighting in ticks (1-20, lower = more frequent)").defineInRange("updateFrequency", 2, 1, 20);
        DEFAULT_LIGHT_LEVEL = CLIENT_BUILDER.comment("Default light level for items not specifically defined").defineInRange("defaultLightLevel", 14, 1, 15);
        CLEANUP_DELAY = CLIENT_BUILDER.comment("How long light persists after the source is removed (in ticks)").defineInRange("cleanupDelay", 5, 1, 100);
        LIGHT_FOLLOW_DISTANCE = CLIENT_BUILDER.comment("How far light sources should follow the player (in blocks)").defineInRange("lightFollowDistance", 2, 1, 5);
        LIGHT_CHANGE_DELAY = CLIENT_BUILDER.comment("Delay before changing light levels (in ticks, helps prevent flickering)").defineInRange("lightChangeDelay", 10, 1, 40);
        LIGHT_ITEMS = CLIENT_BUILDER.comment("Custom items and their light levels (format: 'modid:item_name=level')").defineList("lightItems", new ArrayList(), entry -> entry instanceof String && ((String)entry).contains("="));
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

