/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.wizard.client.gui.screens;

import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.inventories.UnenchantingMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UnenchantingScreen
extends AbstractContainerScreen<UnenchantingMenu> {
    private static final int SIZE_BUTTON_RESULT = 17;
    private static final int SIZE_CONTENT = 18;
    private static final int SIZE_EXPERIENCE_IMAGE = 16;
    private static final int POS_X_BUTTON_EXP = 115;
    private static final int POS_X_BUTTONS = 0;
    private static final int POS_Y_BUTTON_DISABLED = 166;
    private static final int POS_Y_BUTTON_ENABLED = 184;
    private static final int POS_Y_BUTTON_HOUVER = 202;
    private static final int POS_Y_BUTTON_EXP = 7;
    private static final int POS_Y_IMAGE_EXP_DISABLED = 236;
    private static final int POS_Y_IMAGE_EXP_ENABLED = 220;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"neovillagerswizard", (String)"textures/gui/container/unenchanting.png");

    public UnenchantingScreen(UnenchantingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    private List<Component> generateToolTip(int pLvlExp, int pCost, int pDamage) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!((UnenchantingMenu)this.menu).isInCreativeMode() && this.minecraft.player.experienceLevel < pCost) {
            list.add((Component)Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{pCost}).withStyle(ChatFormatting.RED));
        } else {
            MutableComponent levelRequiredMessage;
            MutableComponent lapisRequiredMessage;
            int numLapis = ((UnenchantingMenu)this.menu).getCurrentNumLapis();
            if (pLvlExp == 1) {
                lapisRequiredMessage = Component.translatable((String)"container.unenchanting.block.lapis.one");
                levelRequiredMessage = Component.translatable((String)"container.enchant.level.one");
            } else {
                lapisRequiredMessage = Component.translatable((String)"container.unenchanting.block.lapis.many", (Object[])new Object[]{pLvlExp});
                levelRequiredMessage = Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{pLvlExp});
            }
            if (((UnenchantingMenu)this.menu).isInCreativeMode()) {
                list.add((Component)lapisRequiredMessage.withStyle(ChatFormatting.GRAY));
                list.add((Component)levelRequiredMessage.withStyle(ChatFormatting.GRAY));
            } else {
                list.add((Component)lapisRequiredMessage.withStyle(numLapis >= pLvlExp ? ChatFormatting.GREEN : ChatFormatting.RED));
                list.add((Component)levelRequiredMessage.withStyle(ChatFormatting.GREEN));
            }
            if (pDamage > 0) {
                MutableComponent damageMessage = Component.translatable((String)"container.unenchanting.damage", (Object[])new Object[]{pDamage});
                list.add((Component)damageMessage.withStyle(ChatFormatting.GRAY));
            }
        }
        return list;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        for (int btnExp = 0; btnExp < 4; ++btnExp) {
            int lvlExp = btnExp + 1;
            boolean isHover = this.isHovering(115, 7 + 18 * btnExp, 17, 17, pMouseX, pMouseY);
            if (!isHover || ((UnenchantingMenu)this.menu).getEnchantMinLevel()[btnExp] <= 0) continue;
            int cost = ((UnenchantingMenu)this.menu).getEnchantMinLevel()[btnExp];
            int damage = ((UnenchantingMenu)this.menu).getEnchantDamage()[btnExp];
            List<Component> list = this.generateToolTip(lvlExp, cost, damage);
            pGuiGraphics.setTooltipForNextFrame(this.font, list, Optional.empty(), pMouseX, pMouseY);
            break;
        }
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        for (int resultIndex = 0; resultIndex < 4; ++resultIndex) {
            int btnExpX = this.leftPos + 115;
            int btnExpY = this.topPos + 7 + 18 * resultIndex;
            if (((UnenchantingMenu)this.menu).getEnchantMinLevel()[resultIndex] == 0) {
                pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX, btnExpY, 0.0f, 184.0f, 17, 18, 256, 256);
                continue;
            }
            this.renderButton(pGuiGraphics, resultIndex, pMouseX, pMouseY, btnExpX, btnExpY);
        }
    }

    private void renderButton(GuiGraphics pGuiGraphics, int resultIndex, int pMouseX, int pMouseY, int btnExpX, int btnExpY) {
        int expImageStartPosX = 16 * resultIndex;
        boolean hasExperience = this.minecraft.player.experienceLevel >= ((UnenchantingMenu)this.menu).getEnchantMinLevel()[resultIndex];
        boolean hasResources = ((UnenchantingMenu)this.menu).getCurrentNumLapis() >= resultIndex + 1;
        int resultButtonY = this.topPos + 8 + 18 * resultIndex;
        if (!(((UnenchantingMenu)this.menu).isInCreativeMode() || hasExperience && hasResources)) {
            pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX, btnExpY, 0.0f, 184.0f, 18, 18, 256, 256);
            pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX, resultButtonY, (float)expImageStartPosX, 236.0f, 16, 16, 256, 256);
        } else {
            int k2 = pMouseX - btnExpX;
            int l2 = pMouseY - btnExpY;
            int posY = this.topPos + 7 + 18 * resultIndex;
            int longResultContent = 36;
            if (k2 >= 0 && l2 >= 0 && k2 < 36 && l2 < 18) {
                pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX, posY, 0.0f, 202.0f, 18, 18, 256, 256);
            } else {
                pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX, posY, 0.0f, 166.0f, 18, 18, 256, 256);
            }
            pGuiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, btnExpX + 1, resultButtonY, (float)expImageStartPosX, 220.0f, 16, 16, 256, 256);
        }
    }
}

