/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.wizard.inventories;

import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.NeoVillagersWizard;
import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.helpers.UnenchantingHelper;
import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.inventories.slots.ItemSlotInput;
import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.setup.SetupBlocks;
import com.ryu.minecraft.mod.neoforge.neovillagers.wizard.setup.SetupMenus;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class UnenchantingMenu
extends AbstractContainerMenu {
    public static final String MENU_NAME = "unenchanting";
    private static final int[] REQUIRE_EXPERIENCE = new int[]{5, 10, 15, 20};
    private static final int RESULT_X = 134;
    private static final int RESULT_Y_INCREMENT = 18;
    private static final int RESULT_Y_START = 8;
    private static final int SLOT_INPUT_ITEM_INDEX = 0;
    private static final int SLOT_LAPIS_BLOCK_INDEX = 2;
    private static final int SLOT_LAST_INVENTORY_INDEX = 43;
    private static final int SLOT_START_INVENTORY_INDEX = 7;
    private static final int SLOT_START_RESULT_INDEX = 3;
    private static final int SLOT_WRITABLE_BOOK_INDEX = 1;
    private final ContainerLevelAccess access;
    private final int[] enchantDamage = new int[]{0, 0, 0, 0};
    private final int[] enchantLevel = new int[]{-1, -1, -1, -1};
    private final int[] enchantMinLevel = new int[]{0, 0, 0, 0};
    private final Container inputSlots = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            UnenchantingMenu.this.slotsChanged((Container)this);
        }
    };
    private final Player player;
    private final ResultContainer[] resultSlots = new ResultContainer[4];
    private int currentNumLapis = 0;
    private int totalPower = 0;

    public UnenchantingMenu(int pContainerId, Inventory pInventory) {
        this(pContainerId, pInventory, ContainerLevelAccess.NULL);
    }

    public UnenchantingMenu(int pContainerId, Inventory pInventory, ContainerLevelAccess pAccess) {
        super((MenuType)SetupMenus.UNENCHANTING.get(), pContainerId);
        this.player = pInventory.player;
        this.access = pAccess;
        this.access.execute((level, blockPos) -> {
            this.totalPower = UnenchantingHelper.calculateTotalPower(level, blockPos);
        });
        this.addSlot(new SlotEnchantInput(this, this.inputSlots, 0, 26, 20));
        this.addSlot(new SlotBookInput(this, this.inputSlots, 1, 66, 30));
        this.addSlot(new ItemSlotInput(this.inputSlots, 2, 26, 41, Items.LAPIS_BLOCK));
        for (int i = 0; i < this.resultSlots.length; ++i) {
            this.resultSlots[i] = new ResultContainer();
            this.addSlot(new SlotOutput((Container)this.resultSlots[i], i, 134, 8 + 18 * i));
        }
        this.addInventorySlots(pInventory);
    }

    private void addInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    private void changeResult(ResultContainer resultContainer, Holder<Enchantment> pEnchantment, int pLevel, int i) {
        if (resultContainer.getItem(0).isEmpty()) {
            ItemStack resultItem = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ItemStack inputItem = this.inputSlots.getItem(0);
            int newLevel = UnenchantingHelper.defineLevel((Enchantment)pEnchantment.value(), pLevel, this.totalPower);
            resultItem.enchant(pEnchantment, newLevel);
            NeoVillagersWizard.LOGGER.debug("Adding enchantment: {}, level: {}", (Object)((Enchantment)pEnchantment.value()).description().getString(), (Object)newLevel);
            resultContainer.setItem(0, resultItem);
            this.enchantLevel[i - 1] = newLevel;
            this.enchantMinLevel[i - 1] = i * 5;
            if (inputItem.getItem() == Items.ENCHANTED_BOOK) {
                this.enchantDamage[i - 1] = 0;
            } else {
                int damage = i * 10;
                if (this.totalPower > 20) {
                    damage = damage * 10 / 100;
                } else if (this.totalPower > 0) {
                    int minDamage = damage / 10;
                    int varDamage = damage - minDamage;
                    int gainDamage = varDamage * this.totalPower * 5 / 100;
                    damage = minDamage + (varDamage - gainDamage);
                }
                this.enchantDamage[i - 1] = damage;
            }
        }
    }

    private void cleanEnchantInfo() {
        for (int i = 0; i < this.resultSlots.length; ++i) {
            this.resultSlots[i].setItem(0, ItemStack.EMPTY);
            this.enchantMinLevel[i] = 0;
            this.enchantDamage[i] = 0;
            this.enchantLevel[i] = -1;
        }
    }

    public int getCurrentNumLapis() {
        return this.currentNumLapis;
    }

    public int[] getEnchantDamage() {
        return this.enchantDamage;
    }

    public int[] getEnchantMinLevel() {
        return this.enchantMinLevel;
    }

    private boolean hasAllInputSlot() {
        boolean hasValues = false;
        if (!this.inputSlots.isEmpty()) {
            boolean hasItem;
            boolean bl = hasItem = !this.inputSlots.getItem(0).isEmpty();
            if (!this.isInCreativeMode()) {
                boolean hasBook = !this.inputSlots.getItem(1).isEmpty();
                boolean hasLapis = !this.inputSlots.getItem(2).isEmpty();
                hasValues = hasBook && hasLapis && hasItem;
            } else {
                hasValues = hasItem;
            }
        }
        return hasValues;
    }

    public boolean isInCreativeMode() {
        return this.player.getAbilities().instabuild;
    }

    protected boolean mayPickup(int pIndex) {
        boolean mayPickup = this.isInCreativeMode();
        if (!mayPickup) {
            ItemStack inputLapis = this.inputSlots.getItem(2);
            mayPickup = this.player.experienceLevel >= REQUIRE_EXPERIENCE[pIndex] && inputLapis.getCount() >= pIndex + 1;
        }
        return mayPickup;
    }

    protected void onTake(ItemStack pStack) {
        Optional result = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)pStack).keySet().stream().findFirst();
        if (result.isEmpty()) {
            return;
        }
        ItemStack inputItem = this.inputSlots.getItem(0);
        Enchantment resultEnchantment = (Enchantment)((Holder)result.get()).value();
        int weight = resultEnchantment.getWeight();
        int cost = 0;
        EnchantmentHelper.updateEnchantments((ItemStack)inputItem, element -> element.removeIf(holderElement -> holderElement.value() == resultEnchantment));
        int damage = switch (weight) {
            case 1 -> {
                cost = 4;
                yield this.enchantDamage[3];
            }
            case 2 -> {
                cost = 3;
                yield this.enchantDamage[2];
            }
            case 5 -> {
                cost = 2;
                yield this.enchantDamage[1];
            }
            default -> {
                cost = 1;
                yield this.enchantDamage[0];
            }
        };
        if (inputItem.isDamageableItem() && damage > 0) {
            inputItem.setDamageValue(inputItem.getDamageValue() + inputItem.getMaxDamage() * damage / 100);
            if (inputItem.getDamageValue() >= inputItem.getMaxDamage() - 1) {
                this.inputSlots.removeItem(0, 1);
            } else {
                this.inputSlots.setChanged();
            }
        } else if (inputItem.is(Items.ENCHANTED_BOOK) && EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputItem).isEmpty()) {
            this.inputSlots.setItem(0, new ItemStack((ItemLike)Items.BOOK));
        }
        this.inputSlots.removeItem(1, 1);
        this.inputSlots.removeItem(2, cost);
        this.player.giveExperienceLevels(-cost);
        this.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        Slot slot = (Slot)this.slots.get(pIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotItem = slot.getItem();
        ItemStack slotItemCopy = slotItem.copy();
        if (pIndex < 3) {
            if (!this.moveItemStackTo(slotItem, 7, 43, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 7) {
            if (!this.moveItemStackTo(slotItem, 7, 43, true)) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotItemCopy);
        } else if (pIndex < 43 && !this.moveItemStackTo(slotItem, 0, 3, true)) {
            return ItemStack.EMPTY;
        }
        if (slotItem.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotItem.getCount() == slotItemCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((pLevel, pPos) -> this.clearContainer(pPlayer, this.inputSlots));
    }

    public void slotsChanged(Container pContainer) {
        this.cleanEnchantInfo();
        if (this.hasAllInputSlot()) {
            ItemStack inputItem = this.inputSlots.getItem(0);
            EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputItem).keySet().forEach(enchantment -> {
                int weight = ((Enchantment)enchantment.value()).getWeight();
                int level = inputItem.getEnchantmentLevel(enchantment);
                switch (weight) {
                    case 1: {
                        this.changeResult(this.resultSlots[3], (Holder<Enchantment>)enchantment, level, 4);
                        break;
                    }
                    case 2: {
                        this.changeResult(this.resultSlots[2], (Holder<Enchantment>)enchantment, level, 3);
                        break;
                    }
                    case 5: {
                        this.changeResult(this.resultSlots[1], (Holder<Enchantment>)enchantment, level, 2);
                        break;
                    }
                    case 10: {
                        this.changeResult(this.resultSlots[0], (Holder<Enchantment>)enchantment, level, 1);
                        break;
                    }
                }
            });
            this.currentNumLapis = this.inputSlots.getItem(2).getCount();
            this.broadcastChanges();
        } else {
            super.slotsChanged(pContainer);
        }
    }

    public boolean stillValid(Player pPlayer) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)SetupBlocks.UNENCHANTING.get()));
    }

    public class SlotEnchantInput
    extends Slot {
        public SlotEnchantInput(UnenchantingMenu this$0, Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack pStack) {
            return pStack.getItem() != Items.BOOK && pStack.isEnchanted() || pStack.getItem() == Items.ENCHANTED_BOOK;
        }
    }

    public class SlotBookInput
    extends Slot {
        public SlotBookInput(UnenchantingMenu this$0, Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPlace(ItemStack pStack) {
            return pStack.getItem() == Items.WRITABLE_BOOK && !pStack.isEnchanted();
        }
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean mayPickup(Player pPlayer) {
            return UnenchantingMenu.this.mayPickup(this.getSlotIndex());
        }

        public boolean mayPlace(ItemStack pStack) {
            return false;
        }

        public void onTake(Player pPlayer, ItemStack pStack) {
            UnenchantingMenu.this.onTake(pStack);
        }
    }
}

