/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.rendering.opengl.objects.GlTarget;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import at.redi2go.photonic.client.rendering.world.PBlock;
import at.redi2go.photonic.client.rendering.world.buffer.GlMemoryManager;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryOwner;
import at.redi2go.photonic.client.rendering.world.buffer.SimpleMemoryOwner;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_827;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL42;

public class BlockBuilder {
    private static final Map<class_293, String> SCHEMATIC_SHADER_BY_FORMAT = new HashMap<class_293, String>(Map.of(class_290.field_1590, "schematic6", class_290.field_1580, "schematic7"));
    private static final GlMemoryManager SCHEMATIC_MEMORY_MANAGER = new GlMemoryManager(GlTarget.SSBO, "world_array_block", 16384, false);
    private static final MemoryOwner SCHEMATIC_MEMORY = new SimpleMemoryOwner(SCHEMATIC_MEMORY_MANAGER, SCHEMATIC_MEMORY_MANAGER.getCapacity());
    public static int RENDER_INDEX = 0;
    public static boolean IS_BUILDING_BLOCK_BUFFER = false;
    private static final Map<class_1921, class_287> RENDER_TYPE_BUFFER_BUILDERS = new HashMap<class_1921, class_287>();
    private static class_291 BLOCK_RENDERER = null;
    private static final class_4597 MULTI_BUFFER_BUILDER = renderType -> {
        class_287 bufferBuilder = RENDER_TYPE_BUFFER_BUILDERS.get(renderType);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = new class_287(new class_9799(4096), renderType.method_23033(), renderType.method_23031());
        RENDER_TYPE_BUFFER_BUILDERS.put(renderType, bufferBuilder);
        return bufferBuilder;
    };

    public static void streamBlockBuild(class_2680 blockState, PBlock block) {
        if (blockState.method_26204() == class_2246.field_10164 || blockState.method_26204() == class_2246.field_31037 || blockState.method_26204() == class_2246.field_10027) {
            return;
        }
        Raytracer.INSTANCE.queueOpenGLJob(() -> {
            Schematic schematic = BlockBuilder.buildBlockSchematic(blockState);
            schematic.initialize();
            Raytracer.INSTANCE.queueUrgentBuildJob(() -> {
                block.setCompiledSchematicSupplier(() -> schematic);
                block.update(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
            });
            schematic.optimizeThreaded().thenRun(() -> Raytracer.INSTANCE.queueUrgentBuildJob(() -> {
                block.setCompiledSchematicSupplier(() -> schematic);
                block.update(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
            }));
        });
    }

    public static Schematic buildBlockSchematic(class_2680 blockState) {
        class_1087 model;
        class_2343 entityBlock;
        class_2586 blockEntity;
        if (BLOCK_RENDERER == null) {
            BLOCK_RENDERER = new class_291(class_291.class_8555.field_44794);
        }
        class_310 minecraft = class_310.method_1551();
        IS_BUILDING_BLOCK_BUFFER = true;
        if (blockState.method_31709() && (blockEntity = (entityBlock = (class_2343)blockState.method_26204()).method_10123(new class_2338(0, 0, 0), blockState)) != null) {
            blockEntity.method_31662((class_1937)minecraft.field_1687);
            float partialTick = CapturedRenderingState.INSTANCE.getTickDelta();
            class_827 blockEntityRenderer = minecraft.method_31975().method_3550(blockEntity);
            class_4587 poseStack = new class_4587();
            poseStack.method_22903();
            if (blockEntityRenderer != null) {
                blockEntityRenderer.method_3569(blockEntity, partialTick, poseStack, MULTI_BUFFER_BUILDER, 240, class_4608.field_21444);
            }
        }
        if ((model = minecraft.method_1541().method_3349(blockState)) != minecraft.method_1554().method_4744()) {
            minecraft.method_1541().method_3350().method_3374((class_1920)class_310.method_1551().field_1687, model, blockState, new class_2338(0, 0, 0), new class_4587(), MULTI_BUFFER_BUILDER.getBuffer(class_4696.method_23679((class_2680)blockState)), false, class_5819.method_43049((long)0L), blockState.method_26190(new class_2338(0, 0, 0)), class_4608.field_21444);
        }
        IS_BUILDING_BLOCK_BUFFER = false;
        BLOCK_RENDERER.method_1353();
        Matrix4f modelViewMatrix = new Matrix4f();
        modelViewMatrix.identity();
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        GL11.glViewport((int)0, (int)0, (int)16, (int)16);
        SCHEMATIC_MEMORY_MANAGER.queueUpload(SCHEMATIC_MEMORY);
        SCHEMATIC_MEMORY_MANAGER.upload();
        RENDER_TYPE_BUFFER_BUILDERS.forEach((renderType, bufferBuilder) -> {
            try (class_9801 meshData = bufferBuilder.method_60794();){
                if (meshData == null) {
                    return;
                }
                BLOCK_RENDERER.method_1352(meshData);
                class_5944 shader = minecraft.field_1773.method_35767(SCHEMATIC_SHADER_BY_FORMAT.get(renderType.method_23031()));
                if (shader == null) {
                    throw new IllegalStateException("There is no shader for vertex format " + String.valueOf(renderType.method_23031()));
                }
                renderType.method_23516();
                RenderSystem.setShader(() -> shader);
                RenderSystem.disableCull();
                int blockIndex = SCHEMATIC_MEMORY_MANAGER.findInProgram(shader.method_1270());
                SCHEMATIC_MEMORY_MANAGER.bind(shader.method_1270(), blockIndex, 0);
                for (RENDER_INDEX = 0; RENDER_INDEX < 3; ++RENDER_INDEX) {
                    BLOCK_RENDERER.method_34427(modelViewMatrix, identityMatrix, RenderSystem.getShader());
                }
                renderType.method_23518();
            }
        });
        RENDER_TYPE_BUFFER_BUILDERS.clear();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        GL11.glViewport((int)GlStateManager.class_1040.method_35330(), (int)GlStateManager.class_1040.method_35331(), (int)GlStateManager.class_1040.method_35332(), (int)GlStateManager.class_1040.method_35333());
        GL11.glFinish();
        GL42.glMemoryBarrier((int)512);
        GL42.glMemoryBarrier((int)8192);
        int[] schematicData = new int[SCHEMATIC_MEMORY.getSize() >> 2];
        SCHEMATIC_MEMORY_MANAGER.download(byteBuffer -> byteBuffer.asIntBuffer().get(schematicData));
        return new Schematic(schematicData, 16, 16, 16);
    }
}

