/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.BlockBuilder;
import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.magicavoxel.VoxReader;
import at.redi2go.photonic.client.mixin.ReloadableResourceManagerAccessor;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.schematics.AirEntry;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import at.redi2go.photonic.client.rendering.world.PBlock;
import at.redi2go.photonic.client.rendering.world.position.PBlockPos;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

public class BlockRegistry
implements Destructable {
    private static final Schematic EMPTY_BLOCK;
    public static final Set<class_2248> DEFAULT_STATE_BLOCKS;
    public static final Set<class_2769<?>> DEFAULT_PROPERTIES;
    private final Map<class_2680, PBlock> blockSchematicCache = new HashMap<class_2680, PBlock>();
    private final class_3302 resourceReloadListener = new class_3302(){

        public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 applyProfiler, Executor applyExecutor, Executor executor2) {
            return preparationBarrier.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> {
                applyProfiler.method_16065();
                applyProfiler.method_15396("schematic_reload");
                BlockRegistry.this.reloadBlockModels();
                applyProfiler.method_15407();
                applyProfiler.method_16066();
            }, applyExecutor);
        }
    };

    public BlockRegistry() {
        ((class_3304)class_310.method_1551().method_1478()).method_14477(this.resourceReloadListener);
    }

    public PBlock getBlock(PBlockPos blockPosition) {
        class_2680 blockState;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        try {
            blockState = level.method_8320(new class_2338(blockPosition.x, blockPosition.y, blockPosition.z));
        }
        catch (Exception ignore) {
            blockState = class_2246.field_10124.method_9564();
        }
        return this.getBlock(blockState);
    }

    public PBlock getBlock(class_2680 blockState) {
        if ((blockState = BlockRegistry.cleanUpBlockState(blockState)) == null) {
            return null;
        }
        PBlock block = this.blockSchematicCache.get(blockState);
        if (block != null) {
            return block;
        }
        block = new PBlock(() -> EMPTY_BLOCK);
        block.allocate(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
        block.update(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
        Raytracer.INSTANCE.getWorldRegistry().getLightRegistry().registerBlockState(blockState, block);
        this.blockSchematicCache.put(blockState, block);
        Schematic schematic = BlockRegistry.loadSchematicFromDisk(blockState, false);
        if (schematic == null) {
            BlockBuilder.streamBlockBuild(blockState, block);
        } else {
            schematic.initialize();
            PBlock finalBlock = block;
            schematic.optimizeThreaded().thenRun(() -> Raytracer.INSTANCE.queueUrgentBuildJob(() -> {
                finalBlock.setCompiledSchematicSupplier(() -> schematic);
                finalBlock.update(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
            }));
        }
        return block;
    }

    public void reloadBlockModels() {
        Raytracer.INSTANCE.queueUrgentBuildJob(() -> {
            for (Map.Entry<class_2680, PBlock> entry : this.blockSchematicCache.entrySet()) {
                Schematic schematic = BlockRegistry.loadSchematicFromDisk(entry.getKey(), false);
                if (schematic == null) {
                    BlockBuilder.streamBlockBuild(entry.getKey(), entry.getValue());
                    continue;
                }
                schematic.initialize();
                schematic.optimizeThreaded().thenRun(() -> Raytracer.INSTANCE.queueUrgentBuildJob(() -> {
                    ((PBlock)entry.getValue()).setCompiledSchematicSupplier(() -> schematic);
                    ((PBlock)entry.getValue()).update(Raytracer.INSTANCE.getWorldRegistry().getCbMemoryManager());
                }));
            }
        });
    }

    @Override
    public void free() {
        this.blockSchematicCache.clear();
        ((ReloadableResourceManagerAccessor)class_310.method_1551().method_1478()).getListeners().remove(this.resourceReloadListener);
    }

    public Map<class_2680, PBlock> getBlockSchematicCache() {
        return this.blockSchematicCache;
    }

    private static Schematic loadSchematicFromDisk(class_2680 blockState, boolean aliased) {
        Optional resource2;
        class_3300 resourceFactory = class_310.method_1551().method_1478();
        if (!aliased) {
            try {
                List lines;
                resource2 = resourceFactory.method_14486(class_2960.method_60656((String)("schematics/" + BlockRegistry.encodeBlockState(blockState) + ".alias")));
                if (resource2.isPresent() && (lines = IOUtils.readLines((InputStream)((class_3298)resource2.get()).method_14482(), (Charset)Charset.defaultCharset())).size() >= 2) {
                    class_2680 baseBlockState = BlockRegistry.decodeBlockState((String)lines.get(0));
                    Consumer<Vector3f> transformation = BlockRegistry.decodeTransformation((String)lines.get(1));
                    Schematic schematic = BlockRegistry.loadSchematicFromDisk(baseBlockState, true);
                    if (baseBlockState != null && schematic != null && (schematic = schematic.transform(transformation)) != null) {
                        return schematic;
                    }
                }
            }
            catch (IOException resource2) {
                // empty catch block
            }
        }
        try {
            Schematic schematic;
            resource2 = resourceFactory.method_14486(class_2960.method_60656((String)("schematics/" + BlockRegistry.encodeBlockState(blockState) + ".vox")));
            if (resource2.isPresent() && (schematic = VoxReader.readToSchematic(((class_3298)resource2.get()).method_14482())).getWidth() == 16 && schematic.getHeight() == 16 && schematic.getDepth() == 16) {
                return schematic;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String encodeTransformation(int[] baseHash, int[] targetHash) {
        StringBuilder builder = new StringBuilder();
        boolean[] usedAxis = new boolean[3];
        int matches = 0;
        block0: for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (usedAxis[j] || Math.abs(baseHash[j]) != Math.abs(targetHash[i])) continue;
                int sign = baseHash[j] != targetHash[i] ? -1 : 1;
                builder.append(sign * (j + 1)).append(' ');
                usedAxis[j] = true;
                ++matches;
                continue block0;
            }
        }
        if (matches < 3) {
            System.err.println("Incorrect number of matches");
            return "1 2 3";
        }
        return builder.toString();
    }

    public static Consumer<Vector3f> decodeTransformation(String encodedTransformation) {
        int[] transformation = Arrays.stream(encodedTransformation.split(" ")).mapToInt(Integer::parseInt).toArray();
        int[] indices = new int[3];
        int[] signs = new int[3];
        int[] offsets = new int[3];
        for (int i = 0; i < 3; ++i) {
            indices[i] = Math.abs(transformation[i]) - 1;
            signs[i] = transformation[i] < 0 ? -1 : 1;
            offsets[i] = transformation[i] < 0 ? 15 : 0;
        }
        return v -> v.set((float)offsets[0] + (float)signs[0] * v.get(indices[0]), (float)offsets[1] + (float)signs[1] * v.get(indices[1]), (float)offsets[2] + (float)signs[2] * v.get(indices[2]));
    }

    public static String encodeBlockState(class_2680 blockState) {
        StringBuilder builder = new StringBuilder();
        builder.append(class_7923.field_41175.method_10221((Object)blockState.method_26204()).method_12832());
        blockState.method_11656().forEach((p, v) -> {
            if (DEFAULT_PROPERTIES.contains(p)) {
                return;
            }
            builder.append('-').append(p.method_11899().toLowerCase()).append('_').append(v.toString().toLowerCase());
        });
        return builder.toString();
    }

    public static class_2680 decodeBlockState(String encodedBlockState) {
        String blockName = encodedBlockState.split("-")[0];
        for (class_2680 blockState : ((class_2248)class_7923.field_41175.method_10223(class_2960.method_60656((String)blockName))).method_9595().method_11662()) {
            if (!BlockRegistry.encodeBlockState(blockState).equals(encodedBlockState)) continue;
            return blockState;
        }
        return null;
    }

    public static class_2680 cleanUpBlockState(class_2680 blockState) {
        if (blockState.method_26215()) {
            return null;
        }
        if (DEFAULT_STATE_BLOCKS.contains(blockState.method_26204())) {
            blockState = blockState.method_26204().method_9564();
        }
        return blockState;
    }

    static {
        DEFAULT_STATE_BLOCKS = Set.of(class_2246.field_10179);
        DEFAULT_PROPERTIES = Set.of(class_2741.field_12514, class_2741.field_12541, class_2741.field_12508, class_2741.field_12528);
        EMPTY_BLOCK = new Schematic(16, 16, 16);
        Arrays.fill(EMPTY_BLOCK.getData(), AirEntry.toAirEntry(0, 0, 0, 16, 16, 16));
        EMPTY_BLOCK.setState(2);
    }
}

