/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.PhotonicsStorage;
import at.redi2go.photonic.client.SchematicExporter;
import at.redi2go.photonic.client.ToggleableListScreen;
import at.redi2go.photonic.client.rendering.world.LightBlock;
import at.redi2go.photonic.client.rendering.world.LightType;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import net.minecraft.class_4071;
import net.minecraft.class_4185;
import net.minecraft.class_425;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

public class ModSettingsScreen
extends class_437 {
    private static final ToggleableListScreen.Model BLOCKS_3D_MODEL = new ToggleableListScreen.Model(class_7923.field_41175.method_10220().filter(block -> {
        Set<class_2248> blacklistedBlocks = Set.of(class_2246.field_10124, class_2246.field_10382, class_2246.field_10164);
        return !blacklistedBlocks.contains(block);
    }).sorted(Comparator.comparing(block -> block.method_9518().getString())).map(block -> new BlockModel3DEntry((class_2248)block)).toList());
    private static final ToggleableListScreen.Model BLOCKS_TRACED_MODEL;
    private final class_437 parent;
    private SchematicExporter schematicExporter = null;
    private final class_8132 layout = new class_8132((class_437)this, 61, 33);

    protected ModSettingsScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Photonic Client Settings"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        ArrayList<PButton> buttons = new ArrayList<PButton>();
        buttons.add(new PButton("Generate schematics.zip", w -> this.exportSchematics(), "Exports all blockstates to the root\nMinecraft folder (schematics.zip). Only works in-game!", () -> class_310.method_1551().field_1687 != null));
        PhotonicsStorage.Parameter<Boolean> doMultithreading = PhotonicsStorage.DO_MULTITHREADING;
        buttons.add(new PButton("MultiThreading: " + ((Boolean)doMultithreading.value != false ? "On" : "Off"), w -> {
            doMultithreading.value = (Boolean)doMultithreading.value == false;
            doMultithreading.modified();
            w.method_25355(class_2561.method_30163((String)("MultiThreading: " + ((Boolean)doMultithreading.value != false ? "On" : "Off"))));
        }, "Turns MultiThreading on or off; MultiThreading is considerably faster, but can cause bugs.", () -> true));
        ToggleableListScreen volumetricRenderedBlocks = new ToggleableListScreen(this, "3D Blocks", BLOCKS_3D_MODEL);
        buttons.add(new PButton("3D Blocks", w -> this.field_22787.method_1507((class_437)volumetricRenderedBlocks), "Configures, whether a specific block should be rendered as a 3D block", () -> true));
        ToggleableListScreen tracedBlocks = new ToggleableListScreen(this, "Raytraced Block Lights", BLOCKS_TRACED_MODEL);
        buttons.add(new PButton("Raytraced Lights", w -> this.field_22787.method_1507((class_437)tracedBlocks), "Configures, whether a specific block should emit ray-traced light", () -> true));
        class_8667 linearLayout = (class_8667)this.layout.method_48992((class_8021)class_8667.method_52741().method_52735(8));
        linearLayout.method_52738((class_8021)new class_7842(class_2561.method_30163((String)"Photonics Mod settings"), this.field_22793), class_7847::method_46467);
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46477(4).method_46475(4).method_46467();
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        int midX = this.field_22789 / 2;
        int i = 0;
        for (PButton button : buttons) {
            int x = i % 2 * 220 + midX - 210;
            int y = (i / 2 + 1) * 30;
            button.widget = class_4185.method_46430((class_2561)class_2561.method_30163((String)button.text), (class_4185.class_4241)button.pressAction).method_46433(x, y).method_46437(200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_30163((String)button.toolTip))).method_46431();
            button.widget.field_22763 = button.active.getAsBoolean();
            rowHelper.method_47612((class_8021)button.widget);
            ++i;
        }
        this.layout.method_48999((class_8021)gridLayout);
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, buttonx -> this.method_25419()).method_46432(200).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.layout.method_48222();
    }

    public void method_25394(@NotNull class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_25420(drawContext, mouseX, mouseY, delta);
        super.method_25394(drawContext, mouseX, mouseY, delta);
    }

    public void exportSchematics() {
        if (this.schematicExporter != null) {
            return;
        }
        try {
            this.schematicExporter = new SchematicExporter(new File("."));
            class_310.method_1551().method_18502((class_4071)ModSettingsScreen.buildLoadingOverlay(() -> {
                if (this.schematicExporter == null) {
                    return Float.valueOf(1.0f);
                }
                for (int i = 0; i < 100; ++i) {
                    if (this.schematicExporter.exportOne()) continue;
                    this.schematicExporter = null;
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(this.schematicExporter.getProgress());
            }));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private static class_425 buildLoadingOverlay(final Supplier<Float> progressSupplier) {
        return new class_425(class_310.method_1551(), new class_4011(){

            public CompletableFuture<class_3902> method_18364() {
                return null;
            }

            public float method_18229() {
                return ((Float)progressSupplier.get()).floatValue();
            }

            public boolean method_18787() {
                return this.method_18229() == 1.0f;
            }
        }, o -> {}, false);
    }

    static {
        Set lightBlocks = (Set)PhotonicsStorage.TRACED_LIGHT_BLOCKS.value;
        BLOCKS_TRACED_MODEL = new ToggleableListScreen.Model(lightBlocks.stream().sorted(Comparator.comparing(lightblock -> lightblock.block.method_9518().getString())).map(lightBlock -> new TracedLightBlockEntry(lightBlock.block)).toList());
    }

    private static class PButton {
        public class_4185 widget;
        public final String text;
        public final class_4185.class_4241 pressAction;
        public final String toolTip;
        public final BooleanSupplier active;

        public PButton(String text, class_4185.class_4241 pressAction, String toolTip, BooleanSupplier active) {
            this.text = text;
            this.pressAction = pressAction;
            this.toolTip = toolTip;
            this.active = active;
        }
    }

    public static class TracedLightBlockEntry
    extends ToggleableListScreen.ModelEntry {
        private final class_2248 block;

        public TracedLightBlockEntry(class_2248 block) {
            this.block = block;
        }

        @Override
        public String getDisplayValue() {
            return class_7923.field_41175.method_10221((Object)this.block).method_12832();
        }

        @Override
        public boolean isEnabled() {
            return ((Set)PhotonicsStorage.TRACED_LIGHT_BLOCKS.value).stream().anyMatch(lightBlock -> lightBlock.block == this.block && lightBlock.lightType.isTraced());
        }

        @Override
        public void setEnabled(boolean traced) {
            PhotonicsStorage.Parameter<Set<LightBlock>> lightBlocks = PhotonicsStorage.TRACED_LIGHT_BLOCKS;
            LightBlock lightBlock = ((Set)lightBlocks.value).stream().filter(lightBlock1 -> lightBlock1.block == this.block).findFirst().orElse(null);
            if (lightBlock == null) {
                return;
            }
            lightBlock.lightType = new LightType(lightBlock.lightType.getColor(), lightBlock.lightType.getAttenuation(), traced);
            lightBlocks.modified();
        }
    }

    public static class BlockModel3DEntry
    extends ToggleableListScreen.ModelEntry {
        private final class_2248 block;

        public BlockModel3DEntry(class_2248 block) {
            this.block = block;
        }

        @Override
        public String getDisplayValue() {
            return this.block.method_9518().getString();
        }

        @Override
        public boolean isEnabled() {
            return ((Set)PhotonicsStorage.VOLUMETRIC_RENDERED_BLOCKS.value).contains(this.block);
        }

        @Override
        public void setEnabled(boolean enabled) {
            PhotonicsStorage.Parameter<Set<class_2248>> lightBlocks = PhotonicsStorage.VOLUMETRIC_RENDERED_BLOCKS;
            if (enabled) {
                ((Set)lightBlocks.value).add(this.block);
            } else {
                ((Set)lightBlocks.value).remove(this.block);
            }
            lightBlocks.modified();
        }
    }
}

