/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.StorageIO;
import at.redi2go.photonic.client.rendering.world.LightBlock;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2248;

public final class PhotonicsStorage {
    private static final Map<String, String[]> CONFIG_VALUES = StorageIO.readConfig();
    public static final Parameter<Boolean> DO_MULTITHREADING = new Parameter<Boolean>("do_multithreading", booleanString -> StorageIO.readBoolean(booleanString, false), StorageIO::writeBoolean);
    public static final Parameter<Set<class_2248>> VOLUMETRIC_RENDERED_BLOCKS = new Parameter<Set>("volumetric_blocks", blocksString -> new HashSet<class_2248>(StorageIO.readBlocks(blocksString, Raytracer.DEFAULT_VOLUMETRIC_RENDERED_BLOCKS)), StorageIO::writeBlocks);
    public static final Parameter<Set<LightBlock>> TRACED_LIGHT_BLOCKS = new Parameter<Set>("traced_light_blocks", lightBlocksString -> new HashSet<LightBlock>(StorageIO.readLightBlocks(lightBlocksString, Raytracer.DEFAULT_LIGHT_BLOCKS)), StorageIO::writeLightBlocks);

    public static class Parameter<T> {
        private final List<Consumer<T>> observers = new LinkedList<Consumer<T>>();
        public final String configKey;
        public final Function<T, String[]> serializer;
        public T value;

        public Parameter(String configKey, Function<String[], T> deserializer, Function<T, String[]> serializer) {
            this.configKey = configKey;
            this.serializer = serializer;
            this.value = deserializer.apply(CONFIG_VALUES.get(configKey));
        }

        public void modified() {
            this.observers.forEach(observer -> observer.accept(this.value));
            CONFIG_VALUES.put(this.configKey, this.serializer.apply(this.value));
            StorageIO.writeConfig(CONFIG_VALUES);
        }

        public void addObserver(Consumer<T> observer) {
            this.observers.add(observer);
        }

        public void removeObserver(Consumer<T> observer) {
            this.observers.remove(observer);
        }
    }
}

