/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.BlockElementFaceExt;
import at.redi2go.photonic.client.BlockRegistry;
import at.redi2go.photonic.client.PhotonicsStorage;
import at.redi2go.photonic.client.RenderDispatcher;
import at.redi2go.photonic.client.ShaderPackPath;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.rendering.MainRenderer;
import at.redi2go.photonic.client.rendering.opengl.rendering.ShaderUtil;
import at.redi2go.photonic.client.rendering.patching.Patch;
import at.redi2go.photonic.client.rendering.world.LightBlock;
import at.redi2go.photonic.client.rendering.world.LightType;
import at.redi2go.photonic.client.rendering.world.WorldRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.shaderpack.include.IncludeGraph;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_783;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Raytracer
implements Destructable {
    public static Raytracer INSTANCE;
    public static final Path DEV_ENV_SHADERS_PATH;
    public static Map<String, String> SHADERPACK_CHANGED_OPTIONS;
    public static Properties SHADERPACK_PROPERTIES;
    public static final List<Patch> AVAILABLE_PATCHES;
    public static final TerrainRenderPass VOXEL;
    public static final Set<class_2248> DEFAULT_VOLUMETRIC_RENDERED_BLOCKS;
    public static final Set<LightBlock> DEFAULT_LIGHT_BLOCKS;
    private final MainRenderer mainRenderer;
    private final RenderDispatcher renderDispatcher;
    private final WorldRegistry worldRegistry;
    private final BlockRegistry blockRegistry = new BlockRegistry();
    public Path shaderPackPath = Iris.getShaderpacksDirectory().resolve((String)Iris.getIrisConfig().getShaderPackName().orElseThrow(() -> new RuntimeException("No shaderpack selected!")));
    private final Consumer<Set<class_2248>> volumetricBlocksUpdated;

    public Raytracer() {
        this.renderDispatcher = new RenderDispatcher();
        this.worldRegistry = new WorldRegistry(this.renderDispatcher);
        this.mainRenderer = new MainRenderer(this.worldRegistry);
        this.worldRegistry.startWorldBuilder();
        this.volumetricBlocksUpdated = volumetricBlocks -> class_310.method_1551().field_1769.method_3279();
        PhotonicsStorage.VOLUMETRIC_RENDERED_BLOCKS.addObserver(this.volumetricBlocksUpdated);
    }

    public void queueBuildJob(Runnable job) {
        this.worldRegistry.queueBuildJob(job);
    }

    public void queueUrgentBuildJob(Runnable job) {
        this.queueBuildJob(job);
        this.worldRegistry.wakeUpWorldBuilder();
    }

    public void queueOpenGLJob(Runnable job) {
        this.worldRegistry.queueGlJob(job);
    }

    public static void filterDoubleFaces(Map<class_2350, class_783> faces, Vector3f from, Vector3f to) {
        Vector3f delta = new Vector3f((Vector3fc)from).add(-to.x, -to.y, -to.z);
        if (delta.x * delta.y * delta.z != 0.0f) {
            return;
        }
        Vector3f normal = new Vector3f((Vector3fc)to).add((Vector3fc)from).mul(0.03125f).add((Vector3fc)new Vector3f(-0.5f, -0.5f, -0.5f));
        normal.mul(1.0f / normal.length());
        class_2350 normalDirection = Arrays.stream(class_2350.values()).filter(direction -> class_243.method_24954((class_2382)direction.method_10163()).method_1026(new class_243((double)normal.x, (double)normal.y, (double)normal.z)) > Math.cos(Math.toRadians(45.0))).findFirst().orElse(null);
        if (normalDirection == null) {
            return;
        }
        faces.forEach((key, value) -> {
            class_2350 oppositeDirection = key.method_10153();
            if (!faces.containsKey(oppositeDirection)) {
                return;
            }
            if (key == normalDirection) {
                ((BlockElementFaceExt)value).photonic$setShouldBeVoxelized(false);
            }
        });
    }

    @Override
    public void free() {
        this.renderDispatcher.free();
        this.blockRegistry.free();
        this.worldRegistry.free();
        this.mainRenderer.free();
        PhotonicsStorage.VOLUMETRIC_RENDERED_BLOCKS.removeObserver(this.volumetricBlocksUpdated);
    }

    public static boolean isDisabled() {
        return INSTANCE == null;
    }

    public static boolean shouldBeEnabled() {
        if (!Iris.getIrisConfig().areShadersEnabled()) {
            return false;
        }
        boolean shaderPackSupported = Boolean.parseBoolean(SHADERPACK_PROPERTIES.getOrDefault((Object)"photonics.enabled", (Object)false).toString());
        if (!shaderPackSupported) {
            return false;
        }
        return Boolean.parseBoolean(SHADERPACK_CHANGED_OPTIONS.getOrDefault("PHOTONICS_ENABLED", "true"));
    }

    public static void watchFolder(File folder, Runnable callback) {
        if (!folder.exists()) {
            return;
        }
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            WatchKey watchKey = folder.toPath().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            new Thread(() -> {
                while (true) {
                    if (!watchKey.pollEvents().isEmpty()) {
                        callback.run();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MainRenderer getMainRenderer() {
        return this.mainRenderer;
    }

    public RenderDispatcher getRenderDispatcher() {
        return this.renderDispatcher;
    }

    public WorldRegistry getWorldRegistry() {
        return this.worldRegistry;
    }

    public BlockRegistry getBlockRegistry() {
        return this.blockRegistry;
    }

    public static Patch getAppliedPatch() {
        return Iris.getIrisConfig().getShaderPackName().flatMap(config -> AVAILABLE_PATCHES.stream().filter(p -> p.canBeApplied((String)config, Raytracer.shouldBeEnabled())).findFirst()).orElse(null);
    }

    public static void reloadPatches() {
        AVAILABLE_PATCHES.clear();
        Path fsPath = DEV_ENV_SHADERS_PATH.resolve("patches");
        try (Stream<Path> fsStream = Files.exists(fsPath, new LinkOption[0]) ? Files.list(fsPath) : Stream.of(new Path[0]);
             Stream<Path> classStream = Files.list(Path.of(Objects.requireNonNull(Patch.class.getClassLoader().getResource("assets/photonic/shaders/patches/")).toURI()));){
            Stream.concat(fsStream, classStream).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(p -> {
                try {
                    AVAILABLE_PATCHES.add(Patch.of(p, true));
                    AVAILABLE_PATCHES.add(Patch.of(p, false));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readShaderFile(ShaderPackPath path, boolean patchFile) {
        String source;
        block9: {
            source = null;
            Patch patch = Raytracer.getAppliedPatch();
            if (patch != null && patchFile) {
                source = patch.readPatchedFile(path);
            }
            if (source == null) {
                try {
                    if (path.isPhotonicsPath()) {
                        String relativeToPhotonics = path.getRelativeToPhotonics();
                        Path devEnvShaderPath = DEV_ENV_SHADERS_PATH.resolve(relativeToPhotonics);
                        if (Files.exists(devEnvShaderPath, new LinkOption[0])) {
                            return Raytracer.readShaderAndPreprocess(new ShaderPackPath(devEnvShaderPath));
                        }
                        URL jarShaderUrl = IncludeGraph.class.getClassLoader().getResource("assets/photonic/shaders/" + relativeToPhotonics);
                        if (jarShaderUrl == null) {
                            return null;
                        }
                        Path jarShaderPath = Path.of(jarShaderUrl.toURI());
                        if (Files.exists(jarShaderPath, new LinkOption[0])) {
                            return Raytracer.readShaderAndPreprocess(new ShaderPackPath(jarShaderPath));
                        }
                        break block9;
                    }
                    return Raytracer.readShaderAndPreprocess(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (source == null) {
            throw new IllegalStateException("Couldn't read file " + String.valueOf(path));
        }
        source = ShaderUtil.preprocessForward(source);
        return source;
    }

    private static String readShaderAndPreprocess(ShaderPackPath path) throws IOException {
        return ShaderUtil.preprocessForward(path.readFile());
    }

    private static void registerDefaultLightBlock(List<LightBlock> lightBlocks, Vector3f color, boolean traced, class_2248 ... blocks) {
        for (class_2248 block : blocks) {
            LightType lightType = new LightType(color, new Vector2f(0.9f, 0.9f), traced);
            lightBlocks.add(new LightBlock(block, lightType));
        }
    }

    public static boolean blockStateEmitsLight(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block == class_2246.field_10091) {
            return (Integer)blockState.method_11654((class_2769)class_2457.field_11432) > 0;
        }
        if (block == class_2246.field_10002 || block == class_2246.field_10234 || block == class_2246.field_10441) {
            return true;
        }
        return blockState.method_26213() > 0;
    }

    static {
        DEV_ENV_SHADERS_PATH = Path.of("../src/main/resources/assets/photonic/shaders", new String[0]);
        SHADERPACK_CHANGED_OPTIONS = null;
        SHADERPACK_PROPERTIES = null;
        AVAILABLE_PATCHES = new ArrayList<Patch>();
        VOXEL = new TerrainRenderPass(class_1921.method_23581(), false, true);
        Raytracer.watchFolder(DEV_ENV_SHADERS_PATH.toFile(), () -> RenderSystem.recordRenderCall(() -> {
            try {
                Iris.reload();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
        DEFAULT_VOLUMETRIC_RENDERED_BLOCKS = Set.of(class_2246.field_9980, class_2246.field_10181, class_2246.field_9983, class_2246.field_37569, class_2246.field_10091, class_2246.field_10025, class_2246.field_10167, class_2246.field_10425, class_2246.field_10546);
        LinkedList<LightBlock> lightBlocks = new LinkedList<LightBlock>();
        Vector3f redstoneColor = new Vector3f(255.0f, 51.0f, 51.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, redstoneColor, true, class_2246.field_10523, class_2246.field_10301);
        Raytracer.registerDefaultLightBlock(lightBlocks, redstoneColor, false, class_2246.field_10002, class_2246.field_10080, class_2246.field_29030, class_2246.field_10091);
        Vector3f torchColor = new Vector3f(119.0f, 106.0f, 56.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, torchColor, true, class_2246.field_27099, class_2246.field_27100, class_2246.field_27101, class_2246.field_27102, class_2246.field_27103, class_2246.field_27104, class_2246.field_27105, class_2246.field_27106, class_2246.field_27107, class_2246.field_27108, class_2246.field_27109, class_2246.field_27110, class_2246.field_27111, class_2246.field_27112, class_2246.field_27113, class_2246.field_27140, class_2246.field_27141, class_2246.field_27142, class_2246.field_27143, class_2246.field_27144, class_2246.field_27145, class_2246.field_27146, class_2246.field_27147, class_2246.field_27148, class_2246.field_27149, class_2246.field_27150, class_2246.field_27151, class_2246.field_27152, class_2246.field_27153, class_2246.field_27154, class_2246.field_27155, class_2246.field_27156, class_2246.field_27157, class_2246.field_27158);
        Raytracer.registerDefaultLightBlock(lightBlocks, torchColor, true, class_2246.field_10336, class_2246.field_10099, class_2246.field_10009, class_2246.field_16541, class_2246.field_17350, class_2246.field_10524);
        Raytracer.registerDefaultLightBlock(lightBlocks, torchColor, true, class_2246.field_47072, class_2246.field_47073, class_2246.field_47075, class_2246.field_47074, class_2246.field_47076, class_2246.field_47077, class_2246.field_47079, class_2246.field_47078);
        Raytracer.registerDefaultLightBlock(lightBlocks, torchColor, false, class_2246.field_10164, class_2246.field_10092, class_2246.field_22122, class_2246.field_10171, class_2246.field_27098, class_2246.field_10036, class_2246.field_10333, class_2246.field_10181, class_2246.field_16333, class_2246.field_16334, class_2246.field_28675, class_2246.field_28676);
        Vector3f soulColor = new Vector3f(51.0f, 204.0f, 255.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, soulColor, true, class_2246.field_22092, class_2246.field_22093, class_2246.field_22110, class_2246.field_23860);
        Raytracer.registerDefaultLightBlock(lightBlocks, soulColor, false, class_2246.field_22089);
        Vector3f endColor = new Vector3f(170.0f, 170.0f, 170.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, endColor, true, class_2246.field_10455);
        Raytracer.registerDefaultLightBlock(lightBlocks, endColor, false, class_2246.field_10027, class_2246.field_10398, class_2246.field_10613);
        Vector3f whiteColor = new Vector3f(100.0f, 100.0f, 100.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, whiteColor, false, class_2246.field_31037, class_2246.field_10443, class_2246.field_10476, class_2246.field_10174, class_2246.field_10327);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f((Vector3fc)whiteColor).mul(0.5f), true, class_2246.field_10081);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f((Vector3fc)whiteColor).mul(0.5f), false, class_2246.field_47336);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f((Vector3fc)whiteColor).mul(0.5f), false, class_2246.field_48851);
        Vector3f purpleColor = new Vector3f(131.0f, 8.0f, 228.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, purpleColor, false, class_2246.field_22423, class_2246.field_23152, class_2246.field_10316);
        Vector3f amethystColor = new Vector3f((Vector3fc)new Vector3f(122.0f, 91.0f, 181.0f).mul(0.003921569f));
        Raytracer.registerDefaultLightBlock(lightBlocks, amethystColor, false, class_2246.field_27159, class_2246.field_27161, class_2246.field_27162, class_2246.field_27163, class_2246.field_27164);
        Vector3f sculkColor = new Vector3f(39.0f, 133.0f, 145.0f).mul(0.003921569f);
        Raytracer.registerDefaultLightBlock(lightBlocks, sculkColor, false, class_2246.field_28108, class_2246.field_43231, class_2246.field_37570);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(0.0f, 0.0f, 0.0f).mul(0.003921569f), false, class_2246.field_10251, class_2246.field_10502);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(227.0f, 236.0f, 228.0f).mul(0.003921569f), false, class_2246.field_37571);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(29.0f, 74.0f, 149.0f).mul(0.003921569f), false, class_2246.field_10441);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(23.0f, 221.0f, 98.0f).mul(0.003921569f), false, class_2246.field_10234);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(178.0f, 138.0f, 189.0f).mul(0.003921569f), false, class_2246.field_37574);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(145.0f, 195.0f, 130.0f).mul(0.003921569f), false, class_2246.field_37573);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(150.0f, 220.0f, 134.0f).mul(0.003921569f), false, class_2246.field_37572);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(128.0f, 70.0f, 0.0f).mul(0.003921569f), false, class_2246.field_10485);
        Raytracer.registerDefaultLightBlock(lightBlocks, new Vector3f(113.0f, 134.0f, 126.0f).mul(0.003921569f), false, class_2246.field_28411);
        DEFAULT_LIGHT_BLOCKS = new HashSet<LightBlock>(lightBlocks);
    }
}

