/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.PhotonicsStorage;
import at.redi2go.photonic.client.rendering.opengl.objects.AtomicIntegerImage;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.objects.TextureObject;
import at.redi2go.photonic.client.rendering.opengl.rendering.IRenderDispatcher;
import at.redi2go.photonic.client.rendering.world.LightBlock;
import at.redi2go.photonic.client.rendering.world.position.PChunkPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.parsing.MatrixType;
import net.irisshaders.iris.parsing.VectorType;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.uniforms.custom.cached.CachedUniform;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderDispatcher
implements IRenderDispatcher,
Destructable {
    private static final class_310 MC_INSTANCE = class_310.method_1551();
    private final AtomicIntegerImage[] gi;
    private final Map<Integer, Integer> boundTextures = new HashMap<Integer, Integer>();

    public RenderDispatcher() {
        this.gi = (AtomicIntegerImage[])IntStream.range(0, 5).mapToObj(i -> new AtomicIntegerImage(() -> {
            class_1041 window = class_310.method_1551().method_22683();
            return new Vector3f((float)window.method_4489(), (float)window.method_4506(), 2.0f);
        })).toArray(AtomicIntegerImage[]::new);
    }

    @Override
    public TextureObject getTextureObject(String textureType) {
        return switch (textureType) {
            case "gi_x" -> this.gi[0];
            case "gi_y" -> this.gi[1];
            case "gi_z" -> this.gi[2];
            case "gi_w" -> this.gi[3];
            case "gi_d" -> this.gi[4];
            default -> throw new UnsupportedOperationException();
        };
    }

    @Override
    public void onChunkLoad() {
    }

    @Override
    public Set<PChunkPos> getInboundChunks() {
        HashSet<PChunkPos> chunks = new HashSet<PChunkPos>();
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity == null) {
            return Set.of();
        }
        class_243 chunkPos = cameraEntity.method_19538().method_18805(0.0625, 0.0625, 0.0625);
        int renderRadius = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + 1;
        for (int x = -renderRadius; x < renderRadius; ++x) {
            for (int y = -renderRadius; y < renderRadius; ++y) {
                for (int z = -renderRadius; z < renderRadius; ++z) {
                    PChunkPos worldChunkPos = new PChunkPos((int)(chunkPos.field_1352 + (double)x), (int)(chunkPos.field_1351 + (double)y), (int)(chunkPos.field_1350 + (double)z));
                    chunks.add(worldChunkPos);
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean isChunkEmpty(PChunkPos pos) {
        int posY;
        class_638 level = RenderDispatcher.MC_INSTANCE.field_1687;
        if (level == null) {
            return true;
        }
        if (level.method_31601(16 * pos.y)) {
            return true;
        }
        class_2826[] sections = level.method_22350(new class_2338(16 * pos.x, 16 * pos.y, 16 * pos.z)).method_12006();
        return sections[posY = pos.y - level.method_31607() / 16] == null || sections[posY].method_38292();
    }

    public Matrix4f getModelViewMatrix(Vector3f cameraPosition) {
        Matrix4f matrix4f = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        matrix4f = matrix4f.translate(-cameraPosition.x, -cameraPosition.y, -cameraPosition.z);
        return matrix4f;
    }

    @Override
    public Matrix4f getModelViewProjectionMatrix(Vector3f cameraPosition) {
        return new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferProjection()).mul((Matrix4fc)this.getModelViewMatrix(cameraPosition));
    }

    @Override
    public boolean isLeftHanded() {
        return true;
    }

    public Object getValueUniform(String uniformName) {
        CachedUniform cachedUniform;
        WorldRenderingPipeline worldRenderingPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (!(worldRenderingPipeline instanceof IrisRenderingPipeline)) {
            return null;
        }
        CustomUniforms customUniforms = ((IrisRenderingPipeline)worldRenderingPipeline).getCustomUniforms();
        try {
            cachedUniform = (CachedUniform)customUniforms.getVariable(uniformName);
        }
        catch (RuntimeException e) {
            return null;
        }
        if (cachedUniform == null) {
            return null;
        }
        cachedUniform.update();
        FunctionReturn functionReturn = new FunctionReturn();
        cachedUniform.writeTo(functionReturn);
        if (cachedUniform.getType() == Type.Float) {
            return Float.valueOf(functionReturn.floatReturn);
        }
        if (cachedUniform.getType() == Type.Int) {
            return functionReturn.intReturn;
        }
        if (cachedUniform.getType() == VectorType.VEC3) {
            Vector3f vector3f = (Vector3f)functionReturn.objectReturn;
            return new Vector3f(vector3f.x, vector3f.y, vector3f.z);
        }
        if (cachedUniform.getType() == MatrixType.MAT4) {
            return functionReturn.objectReturn;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector3f getHandheldColor() {
        return RenderDispatcher.getHandheld();
    }

    private static Vector3f getHandheld() {
        class_746 player = RenderDispatcher.MC_INSTANCE.field_1724;
        if (player == null) {
            return new Vector3f();
        }
        class_1661 inventory = player.method_31548();
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        itemStacks.add(inventory.method_7391());
        itemStacks.add((class_1799)inventory.field_7544.get(0));
        Vector3f color = new Vector3f();
        for (class_1799 itemStack : itemStacks) {
            if (itemStack.method_7942()) {
                color.add(0.12941177f, 0.050980393f, 0.30980393f);
                continue;
            }
            class_5321 itemRegistryKey = class_7923.field_41178.method_29113((Object)itemStack.method_7909()).orElse(null);
            if (itemRegistryKey == null) continue;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(itemRegistryKey.method_29177());
            LightBlock lightBlock = ((Set)PhotonicsStorage.TRACED_LIGHT_BLOCKS.value).stream().filter(lightBlock1 -> lightBlock1.block == block).findFirst().orElse(null);
            if (lightBlock == null || !lightBlock.lightType.blockStateEmitsLight(block.method_9564())) continue;
            color.add((Vector3fc)lightBlock.lightType.getColor());
        }
        return color;
    }

    @Override
    public void free() {
        for (AtomicIntegerImage image : this.gi) {
            image.free();
        }
    }
}

