/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.BlockBuilder;
import at.redi2go.photonic.client.BlockRegistry;
import at.redi2go.photonic.client.ZipWriteContext;
import at.redi2go.photonic.client.magicavoxel.VoxWriter;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import java.util.zip.ZipOutputStream;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

public class SchematicExporter {
    private final class_2680[] blockStates;
    private final Map<Long, class_3545<class_2680, Schematic>> baseCases = new HashMap<Long, class_3545<class_2680, Schematic>>();
    private final ZipWriteContext writeContext;
    private int index;

    public SchematicExporter(File folder) throws FileNotFoundException {
        File zipFile = new File(folder, "schematics.zip");
        if (zipFile.exists()) {
            zipFile.delete();
        }
        this.blockStates = (class_2680[])StreamSupport.stream(class_7923.field_41175.spliterator(), false).flatMap(block -> block.method_9595().method_11662().stream()).map(BlockRegistry::cleanUpBlockState).filter(Objects::nonNull).distinct().toArray(class_2680[]::new);
        this.writeContext = new ZipWriteContext(new ZipOutputStream(new FileOutputStream(zipFile)), 16384);
    }

    public boolean exportOne() {
        if (this.index >= this.blockStates.length) {
            try {
                this.writeContext.getZipOutputStream().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
        class_2680 blockState = this.blockStates[this.index++];
        class_2680 defaultBlockState = blockState.method_26204().method_9564();
        for (class_2769 property : blockState.method_28501()) {
            if (!BlockRegistry.DEFAULT_PROPERTIES.contains(property) || blockState.method_11654(property).equals(defaultBlockState.method_11654(property))) continue;
            return true;
        }
        SchematicExporter.exportBlockState(this.writeContext, blockState, this.baseCases);
        return true;
    }

    public float getProgress() {
        return (float)this.index / (float)this.blockStates.length;
    }

    private static void exportBlockState(ZipWriteContext writeContext, class_2680 blockState, Map<Long, class_3545<class_2680, Schematic>> baseCases) {
        if (blockState.method_26215()) {
            return;
        }
        Schematic schematic = BlockBuilder.buildBlockSchematic(blockState);
        schematic.calcRotationHash();
        int[] targetHash = schematic.getHashVector();
        int ax = Math.abs(targetHash[0]);
        int ay = Math.abs(targetHash[1]);
        int az = Math.abs(targetHash[2]);
        long hash = (long)ax * (long)ax + (long)ay * (long)ay + (long)az * (long)az;
        class_3545<class_2680, Schematic> baseCase = baseCases.get(hash);
        if (baseCase != null) {
            writeContext.write(BlockRegistry.encodeBlockState(blockState) + ".alias", new String[]{BlockRegistry.encodeBlockState((class_2680)baseCase.method_15442()), BlockRegistry.encodeTransformation(((Schematic)baseCase.method_15441()).getHashVector(), targetHash)});
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            VoxWriter.writeFromSchematic(schematic, byteArrayOutputStream);
            writeContext.write(BlockRegistry.encodeBlockState(blockState) + ".vox", byteArrayOutputStream.toByteArray());
            baseCases.put(hash, (class_3545<class_2680, Schematic>)new class_3545((Object)blockState, (Object)schematic));
        }
    }
}

