/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client;

import at.redi2go.photonic.client.rendering.world.LightBlock;
import at.redi2go.photonic.client.rendering.world.LightType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class StorageIO {
    public static final File STORAGE_FILE = new File("ph_config.txt");

    public static boolean readBoolean(String[] booleanString, boolean elseBoolean) {
        return booleanString == null ? elseBoolean : Boolean.parseBoolean(booleanString[0]);
    }

    public static String[] writeBoolean(boolean bool) {
        return new String[]{Boolean.toString(bool)};
    }

    public static Collection<class_2248> readBlocks(String[] blocksString, Collection<class_2248> elseBlocks) {
        if (blocksString == null) {
            return elseBlocks;
        }
        return Arrays.stream(blocksString).map(blockString -> (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockString))).toList();
    }

    public static String[] writeBlocks(Collection<class_2248> blocks) {
        return blocks.stream().map(block -> class_7923.field_41175.method_10221(block).toString()).toList().toArray(new String[0]);
    }

    public static Collection<LightBlock> readLightBlocks(String[] lightBlocksString, Collection<LightBlock> defaultLightBlocks) {
        if (lightBlocksString == null) {
            return defaultLightBlocks;
        }
        return Arrays.stream(lightBlocksString).map(lightBlockString -> {
            String[] blockStringSplit = lightBlockString.split(";");
            return new LightBlock((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockStringSplit[0])), new LightType(new Vector3f(Float.parseFloat(blockStringSplit[1]), Float.parseFloat(blockStringSplit[2]), Float.parseFloat(blockStringSplit[3])), new Vector2f(Float.parseFloat(blockStringSplit[4]), Float.parseFloat(blockStringSplit[5])), Boolean.parseBoolean(blockStringSplit[6])));
        }).toList();
    }

    public static String[] writeLightBlocks(Set<LightBlock> lightBlocks) {
        return lightBlocks.stream().map(lightBlock -> String.valueOf(class_7923.field_41175.method_10221((Object)lightBlock.block)) + ";" + lightBlock.lightType.getColor().x + ";" + lightBlock.lightType.getColor().y + ";" + lightBlock.lightType.getColor().z + ";" + lightBlock.lightType.getAttenuation().x + ";" + lightBlock.lightType.getAttenuation().y + ";" + lightBlock.lightType.isTraced()).toList().toArray(new String[0]);
    }

    public static Map<String, String[]> readConfig() {
        HashMap<String, String[]> config = new HashMap<String, String[]>();
        try {
            List<String> lines = Files.readAllLines(STORAGE_FILE.toPath());
            for (String line : lines) {
                int keyValueSeparator = line.indexOf("=");
                if (keyValueSeparator == -1) continue;
                String key = line.substring(0, keyValueSeparator);
                String[] value = line.substring(keyValueSeparator + 1).split(" ");
                config.put(key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    public static void writeConfig(Map<String, String[]> config) {
        StringBuilder configStringBuilder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : config.entrySet()) {
            if (entry.getValue().length == 0) continue;
            configStringBuilder.append(entry.getKey()).append("=").append(String.join((CharSequence)" ", entry.getValue())).append("\n");
        }
        try {
            Files.writeString(STORAGE_FILE.toPath(), (CharSequence)configStringBuilder.toString(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

