/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.magicavoxel;

import at.redi2go.photonic.client.magicavoxel.MagicaVox;
import at.redi2go.photonic.client.magicavoxel.OutputBuffer;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoxWriter {
    private static final Map<Class<?>, Integer> CHUNK_WRITE_ORDER = Map.of(MagicaVox.Voxels.class, 1, MagicaVox.Palette.class, 2);

    public static void writeFromSchematic(Schematic schematic, OutputStream outputStream) {
        if (schematic.getState() != 0) {
            return;
        }
        MagicaVox.Size size = new MagicaVox.Size();
        size.width = schematic.getWidth();
        size.height = schematic.getHeight();
        size.depth = schematic.getDepth();
        MagicaVox.Chunk sizeChunk = new MagicaVox.Chunk();
        sizeChunk.id = MagicaVox.Size.IDENTIFIER;
        sizeChunk.content = size;
        MagicaVox.Voxels voxels = new MagicaVox.Voxels();
        voxels.size = size;
        voxels.voxels = new byte[size.width * size.height * size.depth];
        MagicaVox.Chunk voxelChunk = new MagicaVox.Chunk();
        voxelChunk.id = MagicaVox.Voxels.IDENTIFIER;
        voxelChunk.content = voxels;
        MagicaVox.Palette palette = new MagicaVox.Palette();
        palette.colors = new int[256];
        VoxWriter.populateVoxels(schematic, voxels, palette, 0.0f);
        MagicaVox.Chunk paletteChunk = new MagicaVox.Chunk();
        paletteChunk.id = MagicaVox.Palette.IDENTIFIER;
        paletteChunk.content = palette;
        MagicaVox.Chunk root = new MagicaVox.Chunk();
        root.id = "MAIN";
        root.children = Map.of(MagicaVox.Size.class, List.of(sizeChunk), MagicaVox.Voxels.class, List.of(voxelChunk), MagicaVox.Palette.class, List.of(paletteChunk));
        MagicaVox.Vox vox = new MagicaVox.Vox();
        vox.version = 200;
        vox.main = root;
        VoxWriter.writeFromVox(vox, outputStream);
    }

    public static void writeFromVox(MagicaVox.Vox vox, OutputStream outputStream) {
        OutputBuffer buffer = new OutputBuffer(MagicaVox.BYTE_ORDER);
        VoxWriter.writeString(buffer, "VOX ");
        buffer.putInt(vox.version);
        buffer.put(VoxWriter.writeChunk(vox.main).array());
        try {
            outputStream.write(buffer.array());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static OutputBuffer writeChunk(MagicaVox.Chunk chunk) {
        OutputBuffer buffer = new OutputBuffer(MagicaVox.BYTE_ORDER);
        VoxWriter.writeString(buffer, chunk.id);
        OutputBuffer contentBuffer = VoxWriter.writeContent(chunk.id, chunk.content);
        OutputBuffer childrenBuffer = new OutputBuffer(MagicaVox.BYTE_ORDER);
        if (chunk.children != null) {
            chunk.children.entrySet().stream().sorted(Comparator.comparingInt(entry -> CHUNK_WRITE_ORDER.getOrDefault(entry.getKey(), 0))).forEach(entry -> ((List)entry.getValue()).forEach(c -> childrenBuffer.put(VoxWriter.writeChunk(c).array())));
        }
        buffer.putInt(contentBuffer.getIndex());
        buffer.putInt(childrenBuffer.getIndex());
        buffer.put(contentBuffer.array());
        buffer.put(childrenBuffer.array());
        return buffer;
    }

    private static OutputBuffer writeContent(String id, Object content) {
        OutputBuffer buffer = new OutputBuffer(MagicaVox.BYTE_ORDER);
        switch (id) {
            case "SIZE": {
                MagicaVox.Size size = (MagicaVox.Size)content;
                buffer.putInt(size.width);
                buffer.putInt(size.depth);
                buffer.putInt(size.height);
                break;
            }
            case "XYZI": {
                MagicaVox.Voxels voxels = (MagicaVox.Voxels)content;
                MagicaVox.Size size = voxels.size;
                int voxelCount = 0;
                for (byte b : voxels.voxels) {
                    if (b == 0) continue;
                    ++voxelCount;
                }
                buffer.putInt(voxelCount);
                for (int x = 0; x < size.width; ++x) {
                    for (int y = 0; y < size.height; ++y) {
                        for (int z = 0; z < size.depth; ++z) {
                            int palette = voxels.get(x, y, z);
                            if (palette == 0) continue;
                            buffer.put((byte)x);
                            buffer.put((byte)z);
                            buffer.put((byte)y);
                            buffer.put((byte)palette);
                        }
                    }
                }
                break;
            }
            case "RGBA": {
                MagicaVox.Palette palette = (MagicaVox.Palette)content;
                buffer.putInt(palette.colors);
                break;
            }
            case "MAIN": 
            case "nTRN": 
            case "nGRP": 
            case "nSHP": 
            case "LAYR": 
            case "MATL": 
            case "rOBJ": 
            case "rCAM": 
            case "NOTE": {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return buffer;
    }

    private static void writeString(OutputBuffer buffer, String string) {
        buffer.put(string.getBytes());
    }

    private static void populateVoxels(Schematic schematic, MagicaVox.Voxels voxels, MagicaVox.Palette palette, float minDistance) {
        MagicaVox.Size size = voxels.size;
        HashMap<float[], Integer> palettes = new HashMap<float[], Integer>();
        for (int x = 0; x < size.width; ++x) {
            for (int y = 0; y < size.height; ++y) {
                for (int z = 0; z < size.depth; ++z) {
                    int entry = schematic.getEntry(x, y, z);
                    if (entry == 0) continue;
                    float[] color2 = MagicaVox.unpackNormalized(entry);
                    color2[3] = color2[3] * 2.0f;
                    int index2 = -1;
                    float bestDistance = Float.POSITIVE_INFINITY;
                    for (Map.Entry paletteEntry : palettes.entrySet()) {
                        float dw;
                        float dz;
                        float dy;
                        float[] otherColor = (float[])paletteEntry.getKey();
                        float dx = color2[0] - otherColor[0];
                        float dist = dx * dx + (dy = color2[1] - otherColor[1]) * dy + (dz = color2[2] - otherColor[2]) * dz + (dw = color2[3] - otherColor[3]) * dw;
                        if (!(dist <= minDistance) || !(dist < bestDistance)) continue;
                        bestDistance = dist;
                        index2 = (Integer)paletteEntry.getValue();
                    }
                    if (index2 == -1) {
                        index2 = palettes.size();
                        if (index2 > 254) {
                            VoxWriter.populateVoxels(schematic, voxels, palette, minDistance != 0.0f ? 10.0f * minDistance : 0.001f);
                        } else {
                            palettes.put(color2, index2);
                        }
                    }
                    voxels.set(x, y, z, index2 + 1);
                }
            }
        }
        palettes.forEach((color, index) -> {
            palette.colors[index.intValue()] = MagicaVox.packNormalized(color);
        });
    }
}

