/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.mixin;

import at.redi2go.photonic.client.Photonic;
import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.ShaderPackPath;
import at.redi2go.photonic.client.rendering.patching.Patch;
import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.irisshaders.iris.shaderpack.include.AbsolutePackPath;
import net.irisshaders.iris.shaderpack.include.FileNode;
import net.irisshaders.iris.shaderpack.include.IncludeGraph;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IncludeGraph.class}, remap=false)
public class IncludeGraphMixin {
    @Inject(method={"<init>(Ljava/nio/file/Path;Lcom/google/common/collect/ImmutableList;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/HashSet;<init>(Ljava/util/Collection;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void afterInitArrayList(Path root, ImmutableList<Path> startingPaths, boolean isZip, CallbackInfo ci, @Local List<AbsolutePackPath> queue) {
        try {
            Path path = Path.of(Objects.requireNonNull(this.getClass().getClassLoader().getResource("assets/photonic/shaders")).toURI());
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                pathStream.forEach(file -> {
                    if (!Files.isRegularFile(file, new LinkOption[0])) {
                        return;
                    }
                    Path relativePath = path.relativize((Path)file);
                    if (relativePath.subpath(0, 1).toString().equals("patches")) {
                        return;
                    }
                    queue.add(AbsolutePackPath.fromAbsolutePath((String)"/photonics").resolve(relativePath.toString().replace("\\", "/")));
                });
            }
        }
        catch (Exception e) {
            Photonic.error(e);
        }
        Patch patch = Raytracer.getAppliedPatch();
        if (patch != null) {
            for (String createdFile : patch.files) {
                queue.add(AbsolutePackPath.fromAbsolutePath((String)createdFile.substring("/shaders".length())));
            }
        }
    }

    @Redirect(method={"<init>(Ljava/nio/file/Path;Lcom/google/common/collect/ImmutableList;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z"))
    public boolean contains(Set instance, Object object, @Local FileNode node) {
        if (!node.getPath().getPathString().startsWith("/photonics/")) {
            return instance.contains(object);
        }
        return true;
    }

    @Inject(method={"readFile"}, at={@At(value="HEAD")}, cancellable=true)
    private static void readFile(Path path, CallbackInfoReturnable<String> cir) throws IOException {
        cir.setReturnValue((Object)Raytracer.readShaderFile(new ShaderPackPath(path), true));
        cir.cancel();
    }
}

