/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.mixin;

import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.rendering.opengl.objects.TextureObject;
import at.redi2go.photonic.client.rendering.opengl.rendering.ColorFramebuffer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.function.Supplier;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureAccess;
import net.irisshaders.iris.samplers.IrisSamplers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IrisSamplers.class}, remap=false)
public abstract class IrisSamplersMixin {
    @Inject(method={"addCustomTextures"}, at={@At(value="TAIL")})
    private static void addCustomTexture(SamplerHolder samplers, Object2ObjectMap<String, TextureAccess> irisCustomTextures, CallbackInfo ci) {
        if (!Raytracer.shouldBeEnabled()) {
            return;
        }
        Supplier<ColorFramebuffer> lightBuffer = () -> Raytracer.INSTANCE.getMainRenderer().getLightBuffer();
        IrisSamplersMixin.addTextureSampler(samplers, "radiosity_position", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getWriteAttachment("position"));
        IrisSamplersMixin.addTextureSampler(samplers, "radiosity_normal", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getWriteAttachment("normal"));
        IrisSamplersMixin.addTextureSampler(samplers, "radiosity_direct", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getWriteAttachment("direct"));
        IrisSamplersMixin.addTextureSampler(samplers, "radiosity_direct_soft", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getWriteAttachment("direct_soft"));
        IrisSamplersMixin.addTextureSampler(samplers, "radiosity_handheld", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getWriteAttachment("handheld"));
        IrisSamplersMixin.addTextureSampler(samplers, "prev_radiosity_position", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getReadAttachment("position"));
        IrisSamplersMixin.addTextureSampler(samplers, "prev_radiosity_normal", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getReadAttachment("normal"));
        IrisSamplersMixin.addTextureSampler(samplers, "prev_radiosity_direct", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getReadAttachment("direct"));
        IrisSamplersMixin.addTextureSampler(samplers, "prev_radiosity_direct_soft", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getReadAttachment("direct_soft"));
        IrisSamplersMixin.addTextureSampler(samplers, "prev_radiosity_handheld", () -> ((ColorFramebuffer)((Object)((Object)lightBuffer.get()))).getReadAttachment("handheld"));
    }

    @Unique
    private static void addTextureSampler(SamplerHolder samplers, String name, Supplier<TextureObject> textureObjectSupplier) {
        samplers.addDynamicSampler(() -> {
            TextureObject textureObject = (TextureObject)textureObjectSupplier.get();
            textureObject.updatePerFrame();
            return textureObject.getTextureId();
        }, new String[]{name});
    }
}

