/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.mixin;

import at.redi2go.photonic.client.Raytracer;
import com.google.common.collect.ImmutableSet;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.gl.shader.GlProgram;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.SodiumPrograms;
import net.irisshaders.iris.shaderpack.programs.ProgramFallbackResolver;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.irisshaders.iris.targets.RenderTargets;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SodiumPrograms.class}, remap=false)
public class SodiumProgramsMixin {
    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/util/EnumMap;put(Ljava/lang/Enum;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1)})
    public void putShader(IrisRenderingPipeline pipeline, ProgramSet programSet, ProgramFallbackResolver resolver, RenderTargets renderTargets, Supplier shadowRenderTargets, CustomUniforms customUniforms, CallbackInfo ci, @Local SodiumPrograms.Pass pass, @Local GlProgram<ChunkShaderInterface> program) {
        if (Raytracer.isDisabled()) {
            return;
        }
        if (pass != SodiumPrograms.Pass.valueOf((String)"VOXELS") && pass != SodiumPrograms.Pass.valueOf((String)"SHADOW_VOXELS")) {
            return;
        }
        Raytracer.INSTANCE.getMainRenderer().configureVoxelsShaders(program);
    }

    @Inject(method={"mapTerrainRenderPass"}, at={@At(value="HEAD")}, cancellable=true)
    public void mapTerrainRenderPass(TerrainRenderPass pass, CallbackInfoReturnable<SodiumPrograms.Pass> cir) {
        if (pass == Raytracer.VOXEL) {
            SodiumPrograms.Pass sodiumPass = ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? SodiumPrograms.Pass.valueOf((String)"SHADOW_VOXELS") : SodiumPrograms.Pass.valueOf((String)"VOXELS");
            cir.setReturnValue((Object)sodiumPass);
        }
    }

    @Inject(method={"createFramebuffer"}, at={@At(value="HEAD")}, cancellable=true)
    public void createFramebuffer(SodiumPrograms.Pass pass, ProgramSource source, Supplier<ShadowRenderTargets> shadowRenderTargets, RenderTargets renderTargets, Supplier<ImmutableSet<Integer>> flipState, CallbackInfoReturnable<GlFramebuffer> cir) {
        int[] nArray;
        if (pass != SodiumPrograms.Pass.valueOf((String)"SHADOW_VOXELS")) {
            return;
        }
        ImmutableSet immutableSet = ImmutableSet.of();
        if (source == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else if (source.getDirectives().hasUnknownDrawBuffers()) {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        } else {
            nArray = source.getDirectives().getDrawBuffers();
        }
        GlFramebuffer framebuffer = shadowRenderTargets.get().createShadowFramebuffer(immutableSet, nArray);
        cir.setReturnValue((Object)framebuffer);
        cir.cancel();
    }
}

