/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.objects;

import at.redi2go.photonic.client.rendering.opengl.objects.TextureObject;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;

public class CubeMapFramebuffer
extends TextureObject {
    private final int fbo;
    private final int depthBuffer;
    private final int size;

    public CubeMapFramebuffer(int size) {
        super(new int[]{1, 1, 4, 1}, 6408, 34067, CubeMapFramebuffer.createCubeMapTexture(size), false);
        this.size = size;
        this.fbo = GL30.glGenFramebuffers();
        this.depthBuffer = GL30.glGenRenderbuffers();
    }

    public void render(Consumer<Integer> consumer) {
        GL30.glBindFramebuffer((int)36160, (int)this.fbo);
        GL11.glDrawBuffer((int)36064);
        GL30.glBindRenderbuffer((int)36161, (int)this.depthBuffer);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)this.size, (int)this.size);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthBuffer);
        GL11.glViewport((int)0, (int)0, (int)this.size, (int)this.size);
        for (int i = 0; i < 6; ++i) {
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)(34069 + i), (int)this.getTextureId(), (int)0);
            consumer.accept(i);
        }
        class_1041 window = class_310.method_1551().method_22683();
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
    }

    private static int createCubeMapTexture(int size) {
        int texID = GL11.glGenTextures();
        GL11.glBindTexture((int)34067, (int)texID);
        for (int i = 0; i < 6; ++i) {
            GL11.glTexImage2D((int)(34069 + i), (int)0, (int)32856, (int)size, (int)size, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        }
        GL11.glTexParameteri((int)34067, (int)10240, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10241, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL11.glTexParameteri((int)34067, (int)32882, (int)33071);
        GL11.glBindTexture((int)34067, (int)0);
        return texID;
    }

    @Override
    public void bind() {
        GL13.glActiveTexture((int)(33984 + this.getTextureUnit()));
        GL11.glBindTexture((int)34067, (int)this.getTextureId());
    }

    @Override
    public void unbind() {
        GL11.glBindTexture((int)34067, (int)0);
    }

    @Override
    public void clear(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updatePerFrame() {
    }

    @Override
    public void free() {
        GL30.glDeleteFramebuffers((int)this.fbo);
        GL30.glDeleteRenderbuffers((int)this.depthBuffer);
        GL11.glDeleteTextures((int)this.textureId);
    }
}

