/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.objects;

import at.redi2go.photonic.client.rendering.opengl.GL;
import at.redi2go.photonic.client.rendering.opengl.objects.TextureObject;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL44;

public class UImage3D
extends TextureObject {
    private static final int[] FORMATS = new int[]{36244, 33320, 36248, 36249};
    private static final int[] TYPES = new int[]{5121, 5123, -1, 5125};
    private final Supplier<Vector3f> resolutionSupplier;

    public UImage3D(Supplier<Vector3f> resolutionSupplier, String dataType, boolean alpha, int bytesPerChannel, boolean interpolate) {
        super(new int[]{0, 0, 0, alpha ? 4 : 3, bytesPerChannel}, GL.pGetInternalFormat((alpha ? "RGBA" : "RGB") + 8 * bytesPerChannel + dataType), 32879, GL11.glGenTextures(), true);
        this.resolutionSupplier = resolutionSupplier;
        GL11.glBindTexture((int)32879, (int)this.getTextureId());
        GL11.glTexParameteri((int)32879, (int)10241, (int)(interpolate ? 9729 : 9728));
        GL11.glTexParameteri((int)32879, (int)10240, (int)(interpolate ? 9729 : 9728));
        GL11.glTexParameteri((int)32879, (int)10242, (int)33071);
        GL11.glTexParameteri((int)32879, (int)10243, (int)33071);
        GL11.glTexParameteri((int)32879, (int)32882, (int)33071);
        GL11.glBindTexture((int)32879, (int)0);
    }

    @Override
    public void bind() {
        GL11.glBindTexture((int)32879, (int)this.getTextureId());
        GL42.glBindImageTexture((int)this.getTextureUnit(), (int)this.getTextureId(), (int)0, (boolean)true, (int)0, (int)35002, (int)this.getFormat());
    }

    @Override
    public void unbind() {
        GL11.glBindTexture((int)32879, (int)this.getTextureId());
        GL42.glBindImageTexture((int)this.getTextureUnit(), (int)0, (int)0, (boolean)true, (int)0, (int)35002, (int)this.getFormat());
        GL11.glBindTexture((int)32879, (int)0);
    }

    @Override
    public void clear(int value) {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)1);
        buffer.put(value);
        buffer.flip();
        GL44.glClearTexImage((int)this.getTextureId(), (int)0, (int)this.getFormat(), (int)5125, (IntBuffer)buffer);
    }

    @Override
    public void updatePerFrame() {
        Vector3f resolution = this.resolutionSupplier.get();
        if ((float)this.dimensions[0] != resolution.x || (float)this.dimensions[1] != resolution.y || (float)this.dimensions[2] != resolution.z) {
            this.dimensions[0] = (int)Math.max(resolution.x, 1.0f);
            this.dimensions[1] = (int)Math.max(resolution.y, 1.0f);
            this.dimensions[2] = (int)Math.max(resolution.z, 1.0f);
            GL12.glTexImage3D((int)32879, (int)0, (int)this.getFormat(), (int)this.dimensions[0], (int)this.dimensions[1], (int)this.dimensions[2], (int)0, (int)FORMATS[this.getChannelCount() - 1], (int)TYPES[this.getChannelByteCount() - 1], (ByteBuffer)null);
        }
    }

    @Override
    public void free() {
        GL11.glDeleteTextures((int)this.textureId);
    }
}

