/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.rendering;

import at.redi2go.photonic.client.rendering.opengl.GL;
import at.redi2go.photonic.client.rendering.opengl.objects.TextureObject;
import at.redi2go.photonic.client.rendering.util.BufferUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.uniforms.SystemTimeUniforms;
import net.minecraft.class_310;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL42;

public class ColorFramebuffer
extends GlFramebuffer {
    private final Supplier<Vector2f> resolutionSupplier;
    private int width;
    private int height;
    private int viewportSide = -1;
    private int lastFrameUpdate = -1;
    private final List<String> attachmentNames = new ArrayList<String>();
    private Map<String, FramebufferAttachment> readAttachment = new HashMap<String, FramebufferAttachment>();
    private Map<String, FramebufferAttachment> writeAttachment = new HashMap<String, FramebufferAttachment>();

    public ColorFramebuffer() {
        this(() -> new Vector2f((float)class_310.method_1551().method_22683().method_4489(), (float)class_310.method_1551().method_22683().method_4506()));
    }

    public ColorFramebuffer(Supplier<Vector2f> resolutionSupplier) {
        this.resolutionSupplier = resolutionSupplier;
    }

    public void createAttachment(String name, String internalFormat, boolean interpolate) {
        this.attachmentNames.add(name);
        this.readAttachment.put(name, new FramebufferAttachment(this, this.width, this.height, internalFormat, interpolate));
        this.writeAttachment.put(name, new FramebufferAttachment(this, this.width, this.height, internalFormat, interpolate));
        this.swap();
    }

    public void bind() {
        this.updatePerFrame();
        GL30.glBindFramebuffer((int)36160, (int)this.getId());
        if (this.viewportSide != -1) {
            int x = this.viewportSide * this.width / 2;
            int w = this.width / 2;
            GL11.glViewport((int)x, (int)0, (int)w, (int)this.height);
        } else {
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
        int i = 0;
        IntBuffer buffer = BufferUtils.createIntBuffer(this.writeAttachment.size());
        for (String name : this.attachmentNames) {
            int texture = name == null ? 0 : this.writeAttachment.get(name).getTextureId();
            GL11.glBindTexture((int)3553, (int)texture);
            if (!Objects.equals(name, "depth")) {
                buffer.put(36064 + i);
                GL30.glFramebufferTexture2D((int)36160, (int)(36064 + i), (int)3553, (int)texture, (int)0);
                ++i;
                continue;
            }
            GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)texture, (int)0);
        }
        buffer.position(0);
        buffer.limit(i);
        GL20.glDrawBuffers((IntBuffer)buffer);
        int status = GL30.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("Framebuffer in invalid state: " + status);
        }
    }

    public void unbind() {
        GL30.glBindFramebuffer((int)36160, (int)class_310.method_1551().method_1522().field_1476);
        int width = class_310.method_1551().method_22683().method_4489();
        int height = class_310.method_1551().method_22683().method_4506();
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void swap() {
        Map<String, FramebufferAttachment> tmp = this.readAttachment;
        this.readAttachment = this.writeAttachment;
        this.writeAttachment = tmp;
    }

    public void clear(Vector4f clearColor) {
        this.bind();
        GL11.glClearColor((float)clearColor.x, (float)clearColor.y, (float)clearColor.z, (float)clearColor.w);
        GL11.glClear((int)16640);
        this.unbind();
    }

    public FramebufferAttachment getReadAttachment(String name) {
        FramebufferAttachment attachment = this.readAttachment.get(name);
        if (attachment == null) {
            throw new NullPointerException("Cannot find attachment " + name);
        }
        return attachment;
    }

    public FramebufferAttachment getWriteAttachment(String name) {
        FramebufferAttachment attachment = this.writeAttachment.get(name);
        if (attachment == null) {
            throw new NullPointerException("Cannot find attachment " + name);
        }
        return attachment;
    }

    public void updatePerFrame() {
        int counter = SystemTimeUniforms.COUNTER.getAsInt();
        if (counter == this.lastFrameUpdate) {
            return;
        }
        this.lastFrameUpdate = counter;
        Vector2f resolution = this.resolutionSupplier.get();
        if ((float)this.width != resolution.x || (float)this.height != resolution.y) {
            this.width = (int)Math.max(resolution.x, 1.0f);
            this.height = (int)Math.max(resolution.y, 1.0f);
            this.readAttachment.values().forEach(attachment -> attachment.init(this.width, this.height));
            this.writeAttachment.values().forEach(attachment -> attachment.init(this.width, this.height));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getViewportSide() {
        return this.viewportSide;
    }

    public void setViewportSide(int viewportSide) {
        this.viewportSide = viewportSide;
    }

    protected void destroyInternal() {
        super.destroyInternal();
        for (FramebufferAttachment attachment : this.readAttachment.values()) {
            attachment.free();
        }
        for (FramebufferAttachment attachment : this.writeAttachment.values()) {
            attachment.free();
        }
    }

    public void addDepthAttachment(int texture) {
        throw new UnsupportedOperationException();
    }

    public void addColorAttachment(int index, int texture) {
        throw new UnsupportedOperationException();
    }

    public void noDrawBuffers() {
        throw new UnsupportedOperationException();
    }

    public void drawBuffers(int[] buffers) {
        throw new UnsupportedOperationException();
    }

    public void readBuffer(int buffer) {
        throw new UnsupportedOperationException();
    }

    public int getColorAttachment(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasDepthAttachment() {
        throw new UnsupportedOperationException();
    }

    public void bindAsReadBuffer() {
        throw new UnsupportedOperationException();
    }

    public void bindAsDrawBuffer() {
        throw new UnsupportedOperationException();
    }

    public static class FramebufferAttachment
    extends TextureObject {
        private final ColorFramebuffer framebuffer;
        private final String internalFormat;
        private final boolean interpolate;

        private FramebufferAttachment(ColorFramebuffer framebuffer, int width, int height, String internalFormat, boolean interpolate) {
            super(new int[]{width, height}, GL.pGetInternalFormat(internalFormat), 3553, GL11.glGenTextures(), false);
            this.framebuffer = framebuffer;
            this.internalFormat = internalFormat;
            this.interpolate = interpolate;
            this.init(width, height);
        }

        private void init(int width, int height) {
            if (width <= 0 || height <= 0) {
                return;
            }
            this.dimensions[0] = width;
            this.dimensions[1] = height;
            GL11.glDeleteTextures((int)this.textureId);
            this.textureId = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.getTextureId());
            GL42.glTexStorage2D((int)3553, (int)1, (int)GL.pGetInternalFormat(this.internalFormat), (int)width, (int)height);
            int interpolateFlag = this.interpolate ? 9729 : 9728;
            GL11.glTexParameteri((int)3553, (int)10241, (int)interpolateFlag);
            GL11.glTexParameteri((int)3553, (int)10240, (int)interpolateFlag);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        }

        @Override
        public void bind() {
            GlStateManager._activeTexture((int)(33984 + this.getTextureUnit()));
            GlStateManager._bindTexture((int)this.getTextureId());
        }

        @Override
        public void unbind() {
            GlStateManager._bindTexture((int)0);
        }

        @Override
        public void clear(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updatePerFrame() {
            this.framebuffer.updatePerFrame();
        }

        @Override
        public void free() {
            GL11.glDeleteTextures((int)this.textureId);
        }
    }
}

