/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.rendering;

import at.redi2go.photonic.client.GlProgramExt;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.objects.GLMemoryCollection;
import at.redi2go.photonic.client.rendering.opengl.rendering.ColorFramebuffer;
import at.redi2go.photonic.client.rendering.opengl.rendering.PhotonicsShader;
import at.redi2go.photonic.client.rendering.world.WorldRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.client.gl.shader.GlProgram;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.irisshaders.iris.pipeline.CompositeRenderer;

public class MainRenderer
implements Destructable {
    private final WorldRegistry worldRegistry;
    private CompositeRenderer compositeRenderer;
    private final GLMemoryCollection memoryCollection;
    private final ColorFramebuffer lightingBuffer;

    public MainRenderer(WorldRegistry worldRegistry) {
        this.worldRegistry = worldRegistry;
        this.lightingBuffer = new ColorFramebuffer();
        this.lightingBuffer.createAttachment("position", "RGB32F", false);
        this.lightingBuffer.createAttachment("normal", "RGBA16F", false);
        this.lightingBuffer.createAttachment("direct", "RGBA16F", false);
        this.lightingBuffer.createAttachment("direct_soft", "RGBA32F", false);
        this.lightingBuffer.createAttachment("handheld", "RGBA8", false);
        this.memoryCollection = this.buildGlMemoryCollection();
    }

    public void setup() {
        while (!this.worldRegistry.getGlQueue().isEmpty()) {
            Objects.requireNonNull(this.worldRegistry.getGlQueue().poll()).run();
        }
        this.worldRegistry.upload();
    }

    public void finishRender() {
        this.lightingBuffer.swap();
        this.compositeRenderer.renderAll();
    }

    public void createCompositeRenderer(Function<List<PhotonicsShader>, CompositeRenderer> rendererCreator) {
        this.compositeRenderer = rendererCreator.apply(List.of(new PhotonicsShader("ph_lighting.glsl", "ph_screen.glsl", this.memoryCollection, this.lightingBuffer), new PhotonicsShader("ph_indirect.glsl", "ph_screen.glsl", this.memoryCollection, null)));
    }

    public void configureVoxelsShaders(GlProgram<ChunkShaderInterface> voxelProgram) {
        PhotonicsShader photonicsShader = new PhotonicsShader("", "", this.memoryCollection, null);
        ((GlProgramExt)voxelProgram).photonic$setPhotonicsShader(photonicsShader);
    }

    @Override
    public void free() {
        this.compositeRenderer.destroy();
        this.lightingBuffer.destroy();
    }

    private GLMemoryCollection buildGlMemoryCollection() {
        GLMemoryCollection memoryCollection = new GLMemoryCollection();
        memoryCollection.add(this.worldRegistry::getRootMemoryManager);
        memoryCollection.add(this.worldRegistry::getCbMemoryManager);
        memoryCollection.add(() -> this.worldRegistry.getLightRegistry().getLightsMemoryManager());
        memoryCollection.add(() -> this.worldRegistry.getLightRegistry().getRegistryMemoryManager());
        return memoryCollection;
    }

    public void recalculateSizes() {
        this.compositeRenderer.recalculateSizes();
    }

    public ColorFramebuffer getLightBuffer() {
        return this.lightingBuffer;
    }
}

