/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.rendering;

import at.redi2go.photonic.client.rendering.opengl.objects.GLMemoryCollection;
import at.redi2go.photonic.client.rendering.opengl.rendering.ColorFramebuffer;
import at.redi2go.photonic.client.rendering.world.buffer.GlMemoryManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class PhotonicsShader {
    private List<Map.Entry<Integer, GlMemoryManager>> foundGlMemories;
    private final String fragmentName;
    private final String vertexName;
    private final GLMemoryCollection memoryCollection;
    private final ColorFramebuffer framebuffer;

    public PhotonicsShader(String fragmentName, String vertexName, GLMemoryCollection memoryCollection, ColorFramebuffer framebuffer) {
        this.fragmentName = fragmentName;
        this.vertexName = vertexName;
        this.memoryCollection = memoryCollection;
        this.framebuffer = framebuffer;
    }

    public void bind(int shaderId) {
        if (this.foundGlMemories == null) {
            this.foundGlMemories = new ArrayList<Map.Entry<Integer, GlMemoryManager>>();
            for (Supplier glMemoryManagerSupplier : this.memoryCollection) {
                GlMemoryManager glMemoryManager = (GlMemoryManager)glMemoryManagerSupplier.get();
                int blockIndex = glMemoryManager.findInProgram(shaderId);
                if (blockIndex == -1) continue;
                this.foundGlMemories.add(Map.entry(blockIndex, glMemoryManager));
            }
        }
        int bindingPointIndex = 0;
        for (Map.Entry<Integer, GlMemoryManager> entry : this.foundGlMemories) {
            entry.getValue().bind(shaderId, entry.getKey(), bindingPointIndex++);
        }
        if (this.framebuffer != null) {
            this.framebuffer.bind();
        }
    }

    public String getFragmentName() {
        return this.fragmentName;
    }

    public String getVertexName() {
        return this.vertexName;
    }
}

