/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.opengl.rendering;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ShaderUtil {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("(\\w+\\s+\\w+\\(.*\\))\\s*\\{");
    private static final List<Pair<String, String>> IRIS_UNIFORMS = List.of(Pair.of((Object)"int", (Object)"heldItemId"), Pair.of((Object)"int", (Object)"heldBlockLightValue"), Pair.of((Object)"int", (Object)"heldItemId2"), Pair.of((Object)"int", (Object)"heldBlockLightValue2"), Pair.of((Object)"int", (Object)"fogMode"), Pair.of((Object)"float", (Object)"fogStart"), Pair.of((Object)"float", (Object)"fogEnd"), Pair.of((Object)"int", (Object)"fogShape"), Pair.of((Object)"float", (Object)"fogDensity"), Pair.of((Object)"vec3", (Object)"fogColor"), Pair.of((Object)"vec3", (Object)"skyColor"), Pair.of((Object)"int", (Object)"worldTime"), Pair.of((Object)"int", (Object)"worldDay"), Pair.of((Object)"int", (Object)"moonPhase"), Pair.of((Object)"int", (Object)"frameCounter"), Pair.of((Object)"float", (Object)"frameTime"), Pair.of((Object)"float", (Object)"frameTimeCounter"), Pair.of((Object)"float", (Object)"sunAngle"), Pair.of((Object)"float", (Object)"shadowAngle"), Pair.of((Object)"float", (Object)"rainStrength"), Pair.of((Object)"float", (Object)"aspectRatio"), Pair.of((Object)"float", (Object)"viewWidth"), Pair.of((Object)"float", (Object)"viewHeight"), Pair.of((Object)"float", (Object)"near"), Pair.of((Object)"float", (Object)"far"), Pair.of((Object)"vec3", (Object)"sunPosition"), Pair.of((Object)"vec3", (Object)"moonPosition"), Pair.of((Object)"vec3", (Object)"shadowLightPosition"), Pair.of((Object)"vec3", (Object)"upPosition"), Pair.of((Object)"vec3", (Object)"cameraPosition"), Pair.of((Object)"vec3", (Object)"previousCameraPosition"), Pair.of((Object)"mat4", (Object)"gbufferModelView"), Pair.of((Object)"mat4", (Object)"gbufferModelViewInverse"), Pair.of((Object)"mat4", (Object)"gbufferPreviousModelView"), Pair.of((Object)"mat4", (Object)"gbufferProjection"), Pair.of((Object)"mat4", (Object)"gbufferProjectionInverse"), Pair.of((Object)"mat4", (Object)"gbufferPreviousProjection"), Pair.of((Object)"mat4", (Object)"shadowProjection"), Pair.of((Object)"mat4", (Object)"shadowProjectionInverse"), Pair.of((Object)"mat4", (Object)"shadowModelView"), Pair.of((Object)"mat4", (Object)"shadowModelViewInverse"), Pair.of((Object)"float", (Object)"wetness"), Pair.of((Object)"float", (Object)"eyeAltitude"), Pair.of((Object)"ivec2", (Object)"eyeBrightness"), Pair.of((Object)"ivec2", (Object)"eyeBrightnessSmooth"), Pair.of((Object)"ivec2", (Object)"terrainTextureSize"), Pair.of((Object)"int", (Object)"terrainIconSize"), Pair.of((Object)"int", (Object)"isEyeInWater"), Pair.of((Object)"float", (Object)"nightVision"), Pair.of((Object)"float", (Object)"blindness"), Pair.of((Object)"float", (Object)"screenBrightness"), Pair.of((Object)"int", (Object)"hideGUI"), Pair.of((Object)"float", (Object)"centerDepthSmooth"), Pair.of((Object)"ivec2", (Object)"atlasSize"), Pair.of((Object)"vec4", (Object)"spriteBounds"), Pair.of((Object)"vec4", (Object)"entityColor"), Pair.of((Object)"int", (Object)"entityId"), Pair.of((Object)"int", (Object)"blockEntityId"), Pair.of((Object)"ivec4", (Object)"blendFunc"), Pair.of((Object)"int", (Object)"instanceId"), Pair.of((Object)"float", (Object)"playerMood"), Pair.of((Object)"int", (Object)"renderStage"), Pair.of((Object)"int", (Object)"bossBattle"), Pair.of((Object)"mat4", (Object)"modelViewMatrix"), Pair.of((Object)"mat4", (Object)"modelViewMatrixInverse"), Pair.of((Object)"mat4", (Object)"projectionMatrix"), Pair.of((Object)"mat4", (Object)"projectionMatrixInverse"), Pair.of((Object)"mat4", (Object)"textureMatrix"), Pair.of((Object)"mat3", (Object)"normalMatrix"), Pair.of((Object)"vec3", (Object)"modelOffset"), Pair.of((Object)"float", (Object)"alphaTestRef"), Pair.of((Object)"float", (Object)"darknessFactor"), Pair.of((Object)"float", (Object)"darknessLightFactor"), Pair.of((Object)"sampler2D", (Object)"gtexture"), Pair.of((Object)"sampler2D", (Object)"lightmap"), Pair.of((Object)"sampler2D", (Object)"normals"), Pair.of((Object)"sampler2D", (Object)"specular"), Pair.of((Object)"sampler2D", (Object)"shadow"), Pair.of((Object)"sampler2D", (Object)"watershadow"), Pair.of((Object)"sampler2D", (Object)"shadowtex0"), Pair.of((Object)"sampler2D", (Object)"shadowtex1"), Pair.of((Object)"sampler2D", (Object)"depthtex0"), Pair.of((Object)"sampler2D", (Object)"gaux1"), Pair.of((Object)"sampler2D", (Object)"gaux2"), Pair.of((Object)"sampler2D", (Object)"gaux3"), Pair.of((Object)"sampler2D", (Object)"gaux4"), Pair.of((Object)"sampler2D", (Object)"colortex4"), Pair.of((Object)"sampler2D", (Object)"colortex5"), Pair.of((Object)"sampler2D", (Object)"colortex6"), Pair.of((Object)"sampler2D", (Object)"colortex7"), Pair.of((Object)"sampler2D", (Object)"colortex8"), Pair.of((Object)"sampler2D", (Object)"colortex9"), Pair.of((Object)"sampler2D", (Object)"colortex10"), Pair.of((Object)"sampler2D", (Object)"colortex11"), Pair.of((Object)"sampler2D", (Object)"colortex12"), Pair.of((Object)"sampler2D", (Object)"colortex13"), Pair.of((Object)"sampler2D", (Object)"colortex14"), Pair.of((Object)"sampler2D", (Object)"colortex15"), Pair.of((Object)"sampler2D", (Object)"depthtex1"), Pair.of((Object)"sampler2D", (Object)"shadowcolor"), Pair.of((Object)"sampler2D", (Object)"shadowcolor0"), Pair.of((Object)"sampler2D", (Object)"shadowcolor1"), Pair.of((Object)"sampler2D", (Object)"noisetex"));

    public static Matrix4f createScreenCameraMatrix(Matrix4fc projectionMatrix, Matrix4fc rotationMatrix) {
        return new Matrix4f(projectionMatrix).mul(rotationMatrix).invert();
    }

    public static String preprocessAutoUniforms(String source) {
        return source;
    }

    public static String preprocessForward(String source) {
        String forward = "//#forward";
        if (!source.contains(forward)) {
            return source;
        }
        Matcher forwardMatcher = FUNCTION_PATTERN.matcher(source);
        HashSet<CallSite> functionSignatures = new HashSet<CallSite>();
        while (forwardMatcher.find()) {
            functionSignatures.add((CallSite)((Object)(forwardMatcher.group(1) + ";")));
        }
        source = source.replace(forward, String.join((CharSequence)"\n", functionSignatures));
        return source;
    }
}

