/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.patching;

import at.redi2go.photonic.client.Photonic;
import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.ShaderPackPath;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class Patch {
    private static final int FORMAT_VERSION = 1;
    private final List<String> shaderPackNames;
    private final Map<String, Function<Path, String>> patchedFilesSuppliers;
    private final boolean debug;
    public final List<String> files;
    private final boolean photonicsEnabled;

    private Patch(List<String> shaderPackNames, Map<String, Function<Path, String>> patchedFilesSuppliers, List<String> files, boolean debug, boolean photonicsEnabled) {
        this.shaderPackNames = shaderPackNames;
        this.patchedFilesSuppliers = patchedFilesSuppliers;
        this.files = files;
        this.debug = debug;
        this.photonicsEnabled = photonicsEnabled;
    }

    public static Patch of(Path patchPath, boolean photonicsEnabled) throws IOException {
        PatchInfo info = (PatchInfo)new Gson().fromJson(Patch.readPath(patchPath.resolve("patch.json")), PatchInfo.class);
        if (info == null) {
            throw new PatchLoadException("Could not parse patch.json");
        }
        if (info.formatVersion != 1) {
            throw new PatchLoadException("The patch is written in an unsupported format");
        }
        if (!info.supportedVersions.contains(Photonic.MOD_VERSION)) {
            Photonic.warn("Patch " + String.valueOf(patchPath) + " is probably not compatible", new Object[0]);
        }
        HashMap<String, Function<Path, String>> patchFiles = new HashMap<String, Function<Path, String>>();
        ArrayList<String> files = new ArrayList<String>();
        try (Stream<Path> patches = Files.list(patchPath);){
            for (Path patchFile : patches.toList()) {
                if (patchFile.getFileName().toString().equals("patch.json")) continue;
                Patch.readPatchFile(patchFiles, files, patchFile);
            }
        }
        if (!photonicsEnabled) {
            for (String file2 : patchFiles.keySet().toArray(new String[0])) {
                String fileWithoutShaders = file2.substring("shaders".length());
                if (info.alwaysPatched.contains(fileWithoutShaders)) continue;
                patchFiles.remove(file2);
            }
            files.removeIf(file -> !info.alwaysPatched.contains(file.substring("/shaders".length())));
        }
        return new Patch(info.shaderPackNames, patchFiles, files, info.debug, photonicsEnabled);
    }

    private static void readPatchFile(Map<String, Function<Path, String>> patchedFilesSuppliers, List<String> files, Path patchFile) throws IOException {
        LinkedList<String> lines = new LinkedList<String>(Files.readAllLines(patchFile));
        Object[] fileLocations = null;
        Object[] templateLocations = null;
        String createContent = null;
        ArrayList<Pair> replacements = new ArrayList<Pair>();
        boolean expectCommand = true;
        String searchString = null;
        StringBuilder codeBlockBuilder = new StringBuilder();
        while (!lines.isEmpty()) {
            String line = (String)lines.poll();
            if (line.isBlank() || line.length() >= 2 && line.charAt(0) == '/' && line.charAt(1) == '/') continue;
            if (line.charAt(0) == '#') {
                String command;
                int spaceIndex = line.indexOf(" ");
                if (spaceIndex == -1) {
                    spaceIndex = line.length();
                }
                switch (command = line.substring(1, spaceIndex)) {
                    case "file": {
                        fileLocations = Patch.readLocations(line.split(" "));
                        break;
                    }
                    case "template": {
                        templateLocations = Patch.readLocations(line.split(" "));
                        break;
                    }
                    case "create": {
                        StringBuilder createBuilder = new StringBuilder();
                        while (!lines.isEmpty()) {
                            createBuilder.append((String)lines.poll()).append('\n');
                        }
                        createContent = createBuilder.toString();
                        break;
                    }
                    case "replace": {
                        searchString = line.substring(spaceIndex + 2, line.length() - 1);
                        codeBlockBuilder = new StringBuilder();
                        expectCommand = false;
                        break;
                    }
                    case "endreplace": {
                        if (searchString == null) {
                            throw new PatchLoadException("#endreplace without proper #replace before");
                        }
                        replacements.add(Pair.of(searchString, (Object)codeBlockBuilder.toString()));
                        codeBlockBuilder = new StringBuilder();
                        expectCommand = true;
                        break;
                    }
                    default: {
                        codeBlockBuilder.append(line).append('\n');
                        break;
                    }
                }
                continue;
            }
            if (expectCommand) {
                throw new PatchLoadException("Expected char '#' at position 0 in line " + line);
            }
            codeBlockBuilder.append(line).append('\n');
        }
        if (fileLocations == null) {
            throw new PatchLoadException("You must specify the file locations using 'file'");
        }
        if (templateLocations == null) {
            templateLocations = fileLocations;
        } else if (templateLocations.length == 1) {
            void templateLocation = templateLocations[0];
            templateLocations = new String[fileLocations.length];
            Arrays.fill(templateLocations, templateLocation);
        } else if (templateLocations.length != fileLocations.length) {
            throw new PatchLoadException("The amount of template files must eiter be 1, or equal to the amount of 'file' locations");
        }
        files.addAll(Arrays.asList(fileLocations));
        String createContentFinal = createContent;
        for (int i = 0; i < fileLocations.length; ++i) {
            String fileLocation = ((String)fileLocations[i]).substring(1);
            String templateLocation = ((String)templateLocations[i]).substring(1);
            patchedFilesSuppliers.put(fileLocation, rootPath -> {
                if (createContentFinal != null) {
                    return createContentFinal;
                }
                String source = Raytracer.readShaderFile(new ShaderPackPath(rootPath.resolve(templateLocation)), false);
                if (source == null) {
                    return null;
                }
                for (Pair replacement : replacements) {
                    source = source.replace((CharSequence)replacement.getLeft(), (CharSequence)replacement.getRight());
                }
                return source;
            });
        }
    }

    private static String[] readLocations(String[] lineTokens) throws PatchLoadException {
        if (lineTokens.length == 1) {
            throw new PatchLoadException("You must provide location directives");
        }
        String[] locations = new String[lineTokens.length - 1];
        for (int i = 1; i < lineTokens.length; ++i) {
            String location = lineTokens[i].substring(1, lineTokens[i].length() - 1);
            if (!location.startsWith("/")) {
                throw new PatchLoadException("Location file must start with a '/'");
            }
            locations[i - 1] = "/shaders" + location;
        }
        return locations;
    }

    public String readPatchedFile(ShaderPackPath path) {
        Function<Path, String> patchedFileSupplier = this.patchedFilesSuppliers.get(path.getRelativePath());
        if (patchedFileSupplier == null) {
            return null;
        }
        String patchedSource = patchedFileSupplier.apply(path.getRootPath());
        if (this.debug && patchedSource != null) {
            try {
                Path debugFolder = Path.of("debug", new String[0]);
                Path debugFilePath = debugFolder.resolve(path.getRelativePath());
                Files.createDirectories(debugFilePath.getParent(), new FileAttribute[0]);
                if (!Files.exists(debugFilePath, new LinkOption[0])) {
                    Files.createFile(debugFilePath, new FileAttribute[0]);
                }
                Files.writeString(debugFilePath, (CharSequence)patchedSource, new OpenOption[0]);
            }
            catch (IOException e) {
                Photonic.error(e);
            }
        }
        return patchedSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canBeApplied(String shaderPackName, boolean photonicsEnabled) {
        if (this.photonicsEnabled != photonicsEnabled) return false;
        if (!this.shaderPackNames.stream().anyMatch(shaderPackName::contains)) return false;
        return true;
    }

    private static String readPath(Path path) throws IOException {
        return Files.readString(path);
    }

    private record PatchInfo(int formatVersion, List<String> shaderPackNames, List<String> supportedVersions, boolean debug, Set<String> alwaysPatched) {
    }

    public static class PatchLoadException
    extends IOException {
        public PatchLoadException(String message) {
            super(message);
        }
    }
}

