/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.schematics;

import at.redi2go.photonic.client.rendering.schematics.AirEntry;
import at.redi2go.photonic.client.rendering.schematics.Schematic;
import java.util.LinkedList;
import org.joml.Vector3f;

public class SchematicAlgorithms {
    static void cullInside(Schematic schematic) {
        int y;
        int z;
        int y2;
        int x;
        boolean[] visible = new boolean[schematic.data.length];
        for (x = 0; x < schematic.width; ++x) {
            for (y2 = 0; y2 < schematic.height; ++y2) {
                SchematicAlgorithms.visibilityFill(schematic, visible, x, y2, 0);
            }
        }
        for (x = 0; x < schematic.width; ++x) {
            for (y2 = 0; y2 < schematic.height; ++y2) {
                SchematicAlgorithms.visibilityFill(schematic, visible, x, y2, schematic.depth - 1);
            }
        }
        for (x = 0; x < schematic.width; ++x) {
            for (z = 0; z < schematic.depth; ++z) {
                SchematicAlgorithms.visibilityFill(schematic, visible, x, 0, z);
            }
        }
        for (x = 0; x < schematic.width; ++x) {
            for (z = 0; z < schematic.depth; ++z) {
                SchematicAlgorithms.visibilityFill(schematic, visible, x, schematic.depth - 1, z);
            }
        }
        for (y = 0; y < schematic.height; ++y) {
            for (z = 0; z < schematic.depth; ++z) {
                SchematicAlgorithms.visibilityFill(schematic, visible, 0, y, z);
            }
        }
        for (y = 0; y < schematic.height; ++y) {
            for (z = 0; z < schematic.depth; ++z) {
                SchematicAlgorithms.visibilityFill(schematic, visible, schematic.depth - 1, y, z);
            }
        }
        for (int i = 0; i < schematic.data.length; ++i) {
            if (visible[i] || schematic.data[i] != 0) continue;
            schematic.data[i] = 1;
        }
    }

    static void setup(Schematic schematic) {
        for (int x = 0; x < schematic.width; ++x) {
            for (int y = 0; y < schematic.height; ++y) {
                for (int z = 0; z < schematic.depth; ++z) {
                    int idx = Schematic.toSchematicIndex(x, y, z);
                    int id = schematic.data[idx];
                    schematic.data[idx] = id != 0 ? -id : AirEntry.toAirEntry(x, y, z, x + 1, y + 1, z + 1);
                }
            }
        }
    }

    private static void visibilityFill(Schematic schematic, boolean[] visible, int x0, int y0, int z0) {
        LinkedList<Vector3f> queue = new LinkedList<Vector3f>();
        queue.add(new Vector3f((float)x0, (float)y0, (float)z0));
        while (!queue.isEmpty()) {
            Vector3f v = (Vector3f)queue.poll();
            int x = (int)v.x;
            int y = (int)v.y;
            int z = (int)v.z;
            if (x < 0 || x >= schematic.width || y < 0 || y >= schematic.height || z < 0 || z >= schematic.depth) continue;
            int index = Schematic.toSchematicIndex(x, y, z);
            if (visible[index] || schematic.data[index] != 0) continue;
            visible[index] = true;
            queue.add(new Vector3f((float)(x - 1), (float)y, (float)z));
            queue.add(new Vector3f((float)(x + 1), (float)y, (float)z));
            queue.add(new Vector3f((float)x, (float)(y - 1), (float)z));
            queue.add(new Vector3f((float)x, (float)(y + 1), (float)z));
            queue.add(new Vector3f((float)x, (float)y, (float)(z - 1)));
            queue.add(new Vector3f((float)x, (float)y, (float)(z + 1)));
        }
    }

    static void optimize(Schematic schematic, int x) {
        for (int y = 0; y < schematic.getHeight(); ++y) {
            for (int z = 0; z < schematic.getDepth(); ++z) {
                int airEntry1 = schematic.getUncheckedEntry(x, y, z);
                if (AirEntry.isData(airEntry1)) continue;
                schematic.setEntry(x, y, z, SchematicAlgorithms.mergeNeighbours(schematic, airEntry1));
            }
        }
    }

    private static int mergeNeighbours(Schematic schematic, int airEntry) {
        boolean merged;
        int startX = AirEntry.getX1(airEntry);
        int startY = AirEntry.getY1(airEntry);
        int startZ = AirEntry.getZ1(airEntry);
        int endX = AirEntry.getX2(airEntry);
        int endY = AirEntry.getY2(airEntry);
        int endZ = AirEntry.getZ2(airEntry);
        boolean northMerged = true;
        boolean southMerged = true;
        boolean eastMerged = true;
        boolean westMerged = true;
        boolean topMerged = true;
        boolean bottomMerged = true;
        do {
            merged = false;
            if (northMerged && SchematicAlgorithms.canMergeNorthSouth(schematic, startX, startY, endZ, endX, endY)) {
                ++endZ;
                merged = true;
            } else {
                northMerged = false;
            }
            if (southMerged && SchematicAlgorithms.canMergeNorthSouth(schematic, startX, startY, startZ - 1, endX, endY)) {
                --startZ;
                merged = true;
            } else {
                southMerged = false;
            }
            if (eastMerged && SchematicAlgorithms.canMergeEastWest(schematic, endX, startY, startZ, endY, endZ)) {
                ++endX;
                merged = true;
            } else {
                eastMerged = false;
            }
            if (westMerged && SchematicAlgorithms.canMergeEastWest(schematic, startX - 1, startY, startZ, endY, endZ)) {
                --startX;
                merged = true;
            } else {
                westMerged = false;
            }
            if (topMerged && SchematicAlgorithms.canMergeTopBottom(schematic, startX, endY, startZ, endX, endZ)) {
                ++endY;
                merged = true;
            } else {
                topMerged = false;
            }
            if (bottomMerged && SchematicAlgorithms.canMergeTopBottom(schematic, startX, startY - 1, startZ, endX, endZ)) {
                --startY;
                merged = true;
                continue;
            }
            bottomMerged = false;
        } while (merged && SchematicAlgorithms.surfaceArea(startX, startY, startZ, endX, endY, endZ) < 300);
        return AirEntry.toAirEntry(startX, startY, startZ, endX, endY, endZ);
    }

    private static boolean canMergeEastWest(Schematic schematic, int x, int startY, int startZ, int endY, int endZ) {
        if (!schematic.isInBounds(x, startY, startZ)) {
            return false;
        }
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                if (!AirEntry.isData(schematic.getUncheckedEntry(x, y, z))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canMergeNorthSouth(Schematic schematic, int startX, int startY, int z, int endX, int endY) {
        if (!schematic.isInBounds(startX, startY, z)) {
            return false;
        }
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                if (!AirEntry.isData(schematic.getUncheckedEntry(x, y, z))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canMergeTopBottom(Schematic schematic, int startX, int y, int startZ, int endX, int endZ) {
        if (!schematic.isInBounds(startX, y, startZ)) {
            return false;
        }
        for (int x = startX; x < endX; ++x) {
            for (int z = startZ; z < endZ; ++z) {
                if (!AirEntry.isData(schematic.getUncheckedEntry(x, y, z))) continue;
                return false;
            }
        }
        return true;
    }

    private static int surfaceArea(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        return 2 * (dx * dy + dx * dz + dy * dz);
    }
}

