/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class BufferUtils {
    public static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static IntBuffer createIntBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asIntBuffer();
    }

    public static FloatBuffer createFloatBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asFloatBuffer();
    }

    public static float[] array(FloatBuffer buffer) {
        float[] ar = new float[buffer.position()];
        buffer.flip();
        buffer.put(ar);
        return ar;
    }

    public static Float[] arrayBoxed(FloatBuffer buffer) {
        Float[] ar = new Float[buffer.position()];
        buffer.flip();
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = Float.valueOf(buffer.get());
        }
        return ar;
    }

    public static int[] array(IntBuffer buffer) {
        int[] ar = new int[buffer.position()];
        buffer.flip();
        buffer.put(ar);
        return ar;
    }

    public static Integer[] arrayBoxed(IntBuffer buffer) {
        Integer[] ar = new Integer[buffer.position()];
        buffer.flip();
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = buffer.get();
        }
        return ar;
    }

    public static byte[] packUnorm4x8(float ... data) {
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)Math.round(Math.clamp((double)data[i], 0.0, 1.0) * 255.0);
        }
        return bytes;
    }
}

