/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.util;

import at.redi2go.photonic.client.PhotonicsStorage;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class MultiThreader {
    public static final int DEFAULT_THREAD_COUNT = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
    private static final ExecutorService MULTI_THREAD_SERVICE = Executors.newFixedThreadPool(DEFAULT_THREAD_COUNT, CallAwareThread::new);
    private static final ExecutorService SINGLE_THREAD_SERVICE;
    private static ExecutorService EXECUTOR_SERVICE;

    public static void runAndWait(int dispatchCount, Consumer<Integer> consumer) {
        try {
            MultiThreader.run(dispatchCount, consumer).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompletableFuture<Void> run(int dispatchCount, Consumer<Integer> consumer) {
        if (Thread.currentThread() instanceof CallAwareThread) {
            new IllegalStateException().printStackTrace();
        }
        CompletableFuture[] completableFutures = new CompletableFuture[dispatchCount];
        for (int i = 0; i < dispatchCount; ++i) {
            int finalI = i;
            completableFutures[i] = CompletableFuture.runAsync(() -> consumer.accept(finalI), EXECUTOR_SERVICE);
        }
        return CompletableFuture.allOf(completableFutures);
    }

    public static boolean getMultiThreading() {
        return EXECUTOR_SERVICE == MULTI_THREAD_SERVICE;
    }

    public static void setMultiThreading(boolean multiThreading) {
        EXECUTOR_SERVICE = multiThreading ? MULTI_THREAD_SERVICE : SINGLE_THREAD_SERVICE;
    }

    static {
        EXECUTOR_SERVICE = SINGLE_THREAD_SERVICE = Executors.newSingleThreadExecutor(CallAwareThread::new);
        PhotonicsStorage.Parameter<Boolean> doMultithreadingParameter = PhotonicsStorage.DO_MULTITHREADING;
        MultiThreader.setMultiThreading((Boolean)doMultithreadingParameter.value);
        doMultithreadingParameter.addObserver(MultiThreader::setMultiThreading);
    }

    private static class CallAwareThread
    extends Thread {
        public CallAwareThread(Runnable target) {
            super(target, "WorldCompileWorker " + String.valueOf(UUID.randomUUID()));
        }
    }
}

