/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world;

import at.redi2go.photonic.client.PhotonicsStorage;
import at.redi2go.photonic.client.Raytracer;
import at.redi2go.photonic.client.rendering.MinecraftAccessor;
import at.redi2go.photonic.client.rendering.opengl.objects.Destructable;
import at.redi2go.photonic.client.rendering.opengl.objects.GlTarget;
import at.redi2go.photonic.client.rendering.util.MultiThreader;
import at.redi2go.photonic.client.rendering.world.LightBlock;
import at.redi2go.photonic.client.rendering.world.LightInstance;
import at.redi2go.photonic.client.rendering.world.LightType;
import at.redi2go.photonic.client.rendering.world.PBlock;
import at.redi2go.photonic.client.rendering.world.buffer.GlMemoryManager;
import at.redi2go.photonic.client.rendering.world.buffer.MemoryOwner;
import at.redi2go.photonic.client.rendering.world.buffer.SimpleMemoryOwner;
import at.redi2go.photonic.client.rendering.world.position.LightNodePos;
import at.redi2go.photonic.client.rendering.world.position.PBlockPos;
import at.redi2go.photonic.client.rendering.world.position.PChunkPos;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightRegistry
implements Destructable {
    public static final int MAX_LIGHT_COUNT = 1000;
    private static final int LIGHT_BYTE_SIZE = 32;
    private final Predicate<PChunkPos> chunkEmptyPredicate;
    private final GlMemoryManager registryMemoryManager;
    private final MemoryOwner registryMemory;
    private final GlMemoryManager lightsMemoryManager;
    private final MemoryOwner lightsMemory;
    private final int maxLightsPerNode;
    private final int nodeSize;
    private final int worldSize;
    private final int nodeCount;
    private PBlockPos offset = new PBlockPos(0, 0, 0);
    private List<Pair<LightInstance, Integer>> tracedLights = new ArrayList<Pair<LightInstance, Integer>>();
    private final Set<Vector3f> tracedLightPositions = ConcurrentHashMap.newKeySet();
    private final Consumer<Set<LightBlock>> lightBlockUpdated;
    private final Map<class_2248, LightType> lightTypes = new HashMap<class_2248, LightType>();
    private boolean building = false;

    public LightRegistry(int maxLightsPerNode, int nodeSize, int worldSize, Predicate<PChunkPos> chunkEmptyPredicate) {
        if (16 % nodeSize != 0) {
            throw new IllegalArgumentException();
        }
        this.chunkEmptyPredicate = chunkEmptyPredicate;
        this.maxLightsPerNode = maxLightsPerNode;
        this.nodeSize = nodeSize;
        this.worldSize = worldSize;
        this.nodeCount = worldSize / nodeSize;
        this.registryMemoryManager = new GlMemoryManager(GlTarget.SSBO, "light_registry_block", 4 * this.nodeCount * this.nodeCount * this.nodeCount * (1 + maxLightsPerNode), false);
        this.registryMemory = new SimpleMemoryOwner(this.registryMemoryManager, this.registryMemoryManager.getCapacity());
        this.lightsMemoryManager = new GlMemoryManager(GlTarget.UBO, "lights_uniform", 32004, true);
        this.lightsMemory = new SimpleMemoryOwner(this.lightsMemoryManager, this.lightsMemoryManager.getCapacity());
        PhotonicsStorage.Parameter<Set<LightBlock>> lightBlocksParameter = PhotonicsStorage.TRACED_LIGHT_BLOCKS;
        this.lightBlockUpdated = lightBlocks -> {
            this.registerLightBlocks((Collection<LightBlock>)lightBlocks);
            class_310.method_1551().field_1769.method_3279();
        };
        lightBlocksParameter.addObserver(this.lightBlockUpdated);
    }

    public void init() {
        PhotonicsStorage.Parameter<Set<LightBlock>> lightBlocksParameter = PhotonicsStorage.TRACED_LIGHT_BLOCKS;
        this.registerLightBlocks((Collection)lightBlocksParameter.value);
    }

    public void compileRegistry(PBlockPos blockOffset) {
        if (this.building) {
            throw new IllegalStateException();
        }
        if (MinecraftAccessor.getLevel() == null) {
            return;
        }
        this.building = true;
        this.offset = blockOffset;
        this.createTracedLights();
        MultiThreader.runAndWait(this.nodeCount, x -> {
            for (int y = 0; y < this.nodeCount; ++y) {
                for (int z = 0; z < this.nodeCount; ++z) {
                    LightNodePos lightNodePos = new LightNodePos((int)x, y, z);
                    if (this.chunkEmptyPredicate.test(lightNodePos.toBlockPos(this.nodeSize, blockOffset).toChunkPos())) continue;
                    this.compileAndStoreNode(lightNodePos);
                }
            }
        });
        this.storeLights();
        this.registryMemoryManager.queueUpload(this.registryMemory);
        this.lightsMemoryManager.queueUpload(this.lightsMemory);
        this.building = false;
    }

    /*
     * WARNING - void declaration
     */
    private void compileAndStoreNode(LightNodePos pos) {
        PBlockPos blockPos = pos.toBlockPos(this.nodeSize, this.offset);
        Vector3f middleBlockPos = new Vector3f((float)blockPos.x + (float)this.nodeSize / 2.0f, (float)blockPos.y + (float)this.nodeSize / 2.0f, (float)blockPos.z + (float)this.nodeSize / 2.0f);
        float[] luminanceCache = new float[this.tracedLights.size()];
        PriorityQueue<Map.Entry> sortedLights = new PriorityQueue<Map.Entry>(this.maxLightsPerNode, Comparator.comparing(l -> Float.valueOf(luminanceCache[(Integer)l.getValue()])));
        for (Map.Entry entry : this.tracedLights) {
            float luminance;
            luminanceCache[((Integer)entry.getValue()).intValue()] = luminance = ((LightInstance)entry.getKey()).getType().luminanceFrom(((LightInstance)entry.getKey()).getPosition(), middleBlockPos);
            if (luminance < 0.001f) continue;
            ((AbstractQueue)sortedLights).add(entry);
            if (((AbstractCollection)sortedLights).size() <= this.maxLightsPerNode) continue;
            sortedLights.poll();
        }
        IntBuffer buffer = this.registryMemory.getMemory().getBuffer().asIntBuffer();
        int n = (1 + this.maxLightsPerNode) * (pos.y * this.nodeCount * this.nodeCount + pos.z * this.nodeCount + pos.x);
        buffer.put(n, ((AbstractCollection)sortedLights).size());
        int n2 = n + ((AbstractCollection)sortedLights).size();
        while (!sortedLights.isEmpty()) {
            void var7_10;
            buffer.put((int)(--var7_10), (Integer)((Map.Entry)sortedLights.remove()).getValue());
        }
    }

    private void storeLights() {
        FloatBuffer buffer = this.lightsMemory.getMemory().getBuffer().asFloatBuffer();
        for (Map.Entry entry : this.tracedLights) {
            LightInstance lightInstance = (LightInstance)entry.getKey();
            buffer.position(8 * (Integer)entry.getValue());
            LightRegistry.store(lightInstance.getPosition(), buffer);
            LightRegistry.store(lightInstance.getType().getColor(), buffer);
            LightRegistry.store(lightInstance.getType().getAttenuation(), buffer);
        }
    }

    private void createTracedLights() {
        class_638 level = MinecraftAccessor.getLevel();
        HashMap<class_2680, AtomicInteger> usages = new HashMap<class_2680, AtomicInteger>();
        List<Object> lightInstances = new ArrayList();
        for (Vector3f lightPosition : this.tracedLightPositions) {
            class_2680 blockState = level.method_8320(new class_2338((int)Math.floor(lightPosition.x), (int)Math.floor(lightPosition.y), (int)Math.floor(lightPosition.z)));
            LightType lightType = this.lightTypes.get(blockState.method_26204());
            if (lightType == null || !lightType.isTraced() || !lightType.blockStateEmitsLight(blockState)) {
                this.tracedLightPositions.remove(lightPosition);
                continue;
            }
            lightInstances.add(new LightInstance(lightPosition, lightType));
            usages.computeIfAbsent(blockState, k -> new AtomicInteger(0)).addAndGet(1);
        }
        if (lightInstances.size() > 1000) {
            Vector3f cameraPosition = MinecraftAccessor.getCameraPosition();
            lightInstances = lightInstances.stream().sorted(Comparator.comparingDouble(l -> -l.getType().luminanceFrom(l.getPosition(), cameraPosition))).limit(1000L).toList();
        }
        AtomicInteger lightIdCounter = new AtomicInteger(0);
        this.tracedLights = lightInstances.stream().map(lightInstance -> Pair.of((Object)lightInstance, (Object)lightIdCounter.getAndIncrement())).toList();
    }

    public boolean upload() {
        boolean uploadDone = true;
        uploadDone &= this.registryMemoryManager.upload();
        return uploadDone &= this.lightsMemoryManager.upload();
    }

    public void registerBlockState(class_2680 blockState, PBlock pBlock) {
        LightType lightType = this.lightTypes.get(blockState.method_26204());
        if (lightType == null || !lightType.blockStateEmitsLight(blockState)) {
            return;
        }
        Vector3f lightColor = new Vector3f((Vector3fc)lightType.getColor());
        if (lightType.isTraced()) {
            lightColor.mul(0.5f);
        }
        Raytracer.INSTANCE.getWorldRegistry().registerEmittableBlock(pBlock, lightColor);
    }

    private void registerLightBlocks(Collection<LightBlock> lightBLocks) {
        for (LightBlock lightBlock : lightBLocks) {
            this.lightTypes.put(lightBlock.block, lightBlock.lightType);
            Vector3f emittingColor = lightBlock.lightType.isTraced() ? new Vector3f(0.0f) : lightBlock.lightType.getColor();
            Map<class_2680, PBlock> blockSchematicCache = Map.copyOf(Raytracer.INSTANCE.getBlockRegistry().getBlockSchematicCache());
            for (Map.Entry<class_2680, PBlock> entry : blockSchematicCache.entrySet()) {
                if (entry.getKey().method_26204() != lightBlock.block || !lightBlock.lightType.blockStateEmitsLight(entry.getKey())) continue;
                Raytracer.INSTANCE.getWorldRegistry().registerEmittableBlock(entry.getValue(), emittingColor);
            }
        }
    }

    public void onBlockLoad(Vector3f position) {
        class_638 level = MinecraftAccessor.getLevel();
        if (level == null) {
            return;
        }
        class_2680 blockState = level.method_8320(new class_2338((int)position.x, (int)position.y, (int)position.z));
        LightType lightType = this.lightTypes.get(blockState.method_26204());
        if (lightType == null) {
            return;
        }
        if (lightType.isTraced() && lightType.blockStateEmitsLight(blockState)) {
            this.tracedLightPositions.add(new Vector3f((Vector3fc)position).add(0.5f, 0.5f, 0.5f));
        }
    }

    public GlMemoryManager getRegistryMemoryManager() {
        return this.registryMemoryManager;
    }

    public GlMemoryManager getLightsMemoryManager() {
        return this.lightsMemoryManager;
    }

    @Override
    public void free() {
        this.lightsMemoryManager.free();
        this.registryMemoryManager.free();
        PhotonicsStorage.Parameter<Set<LightBlock>> lightBlocks = PhotonicsStorage.TRACED_LIGHT_BLOCKS;
        lightBlocks.removeObserver(this.lightBlockUpdated);
    }

    private static void store(Vector3f vector3f, FloatBuffer buffer) {
        buffer.put(vector3f.x);
        buffer.put(vector3f.y);
        buffer.put(vector3f.z);
    }

    private static void store(Vector2f vector2f, FloatBuffer buffer) {
        buffer.put(vector2f.x);
        buffer.put(vector2f.y);
    }
}

