/*
 * Decompiled with CFR 0.152.
 */
package at.redi2go.photonic.client.rendering.world;

import at.redi2go.photonic.client.Raytracer;
import java.util.Objects;
import net.minecraft.class_2680;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightType {
    private final Vector3f color;
    private final Vector2f attenuation;
    private final float luminanceDotColor;
    private final boolean traced;

    public LightType(Vector3f color, Vector2f lightFalloff, boolean traced) {
        this.color = color;
        this.attenuation = lightFalloff;
        this.luminanceDotColor = color.dot((Vector3fc)new Vector3f(0.2126f, 0.7152f, 0.0722f));
        this.traced = traced;
    }

    public float luminanceFrom(Vector3f lightPosition, Vector3f samplePosition) {
        float dx = samplePosition.x - lightPosition.x;
        float dy = samplePosition.y - lightPosition.y;
        float dz = samplePosition.z - lightPosition.z;
        float distanceSquared = dx * dx + dy * dy + dz * dz;
        return this.luminanceDotColor / (this.attenuation.x + distanceSquared * this.attenuation.y);
    }

    public boolean blockStateEmitsLight(class_2680 blockState) {
        return Raytracer.blockStateEmitsLight(blockState);
    }

    public Vector3f getColor() {
        return this.color;
    }

    public Vector2f getAttenuation() {
        return this.attenuation;
    }

    public boolean isTraced() {
        return this.traced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightType lightType = (LightType)o;
        return Objects.equals(this.color, lightType.color) && Objects.equals(this.attenuation, lightType.attenuation);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.attenuation);
    }
}

